/*
 * Decompiled with CFR 0.152.
 */
package com.javorosas.OpenWifi;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import java.util.List;

public class OpenWifiModule
extends ReactContextBaseJavaModule {
    public OpenWifiModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return "OpenWifi";
    }

    @ReactMethod
    public void connect(String ssid) {
        WifiConfiguration conf = new WifiConfiguration();
        conf.SSID = "\"" + ssid + "\"";
        conf.allowedKeyManagement.set(0);
        WifiManager wifiManager = (WifiManager)this.getReactApplicationContext().getSystemService("wifi");
        List mWifiConfigList = wifiManager.getConfiguredNetworks();
        String comparableSSID = '\"' + ssid + '\"';
        for (WifiConfiguration wifiConfig : mWifiConfigList) {
            if (!wifiConfig.SSID.equals(comparableSSID)) continue;
            int networkId = wifiConfig.networkId;
            wifiManager.removeNetwork(networkId);
            wifiManager.saveConfiguration();
        }
        int networkId = wifiManager.addNetwork(conf);
        wifiManager.disconnect();
        wifiManager.enableNetwork(networkId, true);
        wifiManager.reconnect();
    }

    @ReactMethod
    public void status(Callback statusResult) {
        ConnectivityManager connManager = (ConnectivityManager)this.getReactApplicationContext().getSystemService("connectivity");
        NetworkInfo mWifi = connManager.getNetworkInfo(1);
        statusResult.invoke(new Object[]{mWifi.getState().toString()});
    }

    private static Integer findNetworkInExistingConfig(WifiManager wifiManager, String ssid) {
        List existingConfigs = wifiManager.getConfiguredNetworks();
        for (WifiConfiguration existingConfig : existingConfigs) {
            if (!existingConfig.SSID.equals(ssid)) continue;
            return existingConfig.networkId;
        }
        return null;
    }
}

