/*
 * Decompiled with CFR 0.152.
 */
package com.rnpaystack;

import android.app.Activity;
import android.content.Context;
import co.paystack.android.Paystack;
import co.paystack.android.PaystackSdk;
import co.paystack.android.Transaction;
import co.paystack.android.model.Card;
import co.paystack.android.model.Charge;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import java.util.HashMap;
import java.util.Map;

public class RNPaystackPaymentModule
extends ReactContextBaseJavaModule {
    private final ReactApplicationContext reactContext;
    protected Card card;
    protected Charge charge;
    private Promise pendingPromise;

    public RNPaystackPaymentModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
        PaystackSdk.initialize((Context)reactContext);
    }

    @ReactMethod
    public void createPayment(int amount, String email, String panNum, String cvv, int expireMonth, int expireYear, String currency, String reference, String subaccount, int transaction_charge, String bearer, Promise promise) {
        PaystackSdk.setPublicKey((String)"pk_test_0a3aaced9a1b53974f920b3ce89aef6de8c93c49");
        this.card = new Card(panNum, Integer.valueOf(expireMonth), Integer.valueOf(expireYear), cvv);
        this.charge = new Charge();
        this.charge.setAmount(amount);
        this.charge.setEmail(email);
        if (!this.isEmptyString(currency)) {
            this.charge.setCurrency(currency);
        }
        if (!this.isEmptyString(reference)) {
            this.charge.setReference(reference);
        }
        if (!this.isEmptyString(subaccount)) {
            this.charge.setSubaccount(subaccount);
        }
        if (!this.isEmptyInt(transaction_charge)) {
            this.charge.setTransactionCharge(transaction_charge);
        }
        if (!this.isEmptyString(bearer)) {
            this.charge.setBearer(Charge.Bearer.valueOf((String)bearer));
        }
        this.charge.setCard(this.card);
        this.pendingPromise = promise;
        if (this.card != null && this.card.isValid()) {
            try {
                this.performCharge(this.charge);
            }
            catch (Exception error) {
                this.rejectPromise("CHARGE_ERROR", error.getMessage());
            }
        } else {
            this.rejectPromise("Card_is_InValid", "Invalid Card Details Provided");
        }
    }

    private void performCharge(Charge charge) {
        Activity currentActivity = this.getCurrentActivity();
        PaystackSdk.chargeCard((Activity)currentActivity, (Charge)charge, (Paystack.TransactionCallback)new Paystack.TransactionCallback(){

            public void onSuccess(Transaction transaction) {
                WritableMap map = Arguments.createMap();
                map.putString("reference", transaction.getReference());
                RNPaystackPaymentModule.this.resolvePromise(map);
            }

            public void beforeValidate(Transaction transaction) {
                WritableMap map = Arguments.createMap();
                map.putString("reference", transaction.getReference());
            }

            public void onError(Throwable error, Transaction transaction) {
                RNPaystackPaymentModule.this.rejectPromise("TRANSACTION_ERROR", error.getMessage());
            }
        });
    }

    private boolean isEmptyString(String s) {
        return s == null || s.length() < 1;
    }

    private boolean isEmptyInt(int i) {
        return i == 0;
    }

    private void rejectPromise(String code, String message) {
        if (this.pendingPromise != null) {
            this.pendingPromise.reject(code, message);
            this.pendingPromise = null;
        }
    }

    private void resolvePromise(Object data) {
        if (this.pendingPromise != null) {
            this.pendingPromise.resolve(data);
            this.pendingPromise = null;
        }
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("secret_key", "sk_test_a290fce93d923abfa18d843776a8a86c19cd83bc");
        return constants;
    }

    public String getName() {
        return "RNPaystackPayment";
    }
}

