/*
 * Decompiled with CFR 0.152.
 */
package com.reactlibrary;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.paytm.pgsdk.PaytmOrder;
import com.paytm.pgsdk.PaytmPGService;
import com.paytm.pgsdk.PaytmPaymentTransactionCallback;
import java.util.HashMap;
import javax.annotation.Nullable;

public class RNPayTmModule
extends ReactContextBaseJavaModule {
    private final ReactApplicationContext reactContext;

    public RNPayTmModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "RNPayTm";
    }

    @ReactMethod
    public void startPayment(ReadableMap options) {
        Activity currentActivity = this.getCurrentActivity();
        PaytmPGService Service = options.getString("mode").equals("Production") ? PaytmPGService.getProductionService() : PaytmPGService.getStagingService((String)"");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ORDER_ID", options.getString("ORDER_ID"));
        paramMap.put("MID", options.getString("MID"));
        paramMap.put("CUST_ID", options.getString("CUST_ID"));
        paramMap.put("CHANNEL_ID", options.getString("CHANNEL_ID"));
        paramMap.put("INDUSTRY_TYPE_ID", options.getString("INDUSTRY_TYPE_ID"));
        paramMap.put("WEBSITE", options.getString("WEBSITE"));
        paramMap.put("TXN_AMOUNT", options.getString("TXN_AMOUNT"));
        paramMap.put("EMAIL", options.getString("EMAIL"));
        paramMap.put("MOBILE_NO", options.getString("MOBILE_NO"));
        paramMap.put("CALLBACK_URL", options.getString("CALLBACK_URL"));
        paramMap.put("CHECKSUMHASH", options.getString("CHECKSUMHASH"));
        if (options.hasKey("MERC_UNQ_REF")) {
            paramMap.put("MERC_UNQ_REF", options.getString("MERC_UNQ_REF"));
        }
        PaytmOrder Order = new PaytmOrder(paramMap);
        Service.initialize(Order, null);
        Service.startPaymentTransaction((Context)this.getCurrentActivity(), true, true, new PaytmPaymentTransactionCallback(){

            public void someUIErrorOccurred(String inErrorMessage) {
                Log.d((String)"RNPayTm", (String)("Some UI Error Occurred: " + inErrorMessage));
                WritableNativeMap params = new WritableNativeMap();
                params.putString("status", "UIErrorOccurred");
                RNPayTmModule.this.sendEvent("PayTMResponse", (WritableMap)params);
            }

            public void onTransactionResponse(Bundle inResponse) {
                Log.d((String)"RNPayTm", (String)("Payment Transaction Response: " + inResponse));
                WritableMap params = Arguments.fromBundle((Bundle)inResponse);
                params.putString("status", "Success");
                RNPayTmModule.this.sendEvent("PayTMResponse", params);
            }

            public void networkNotAvailable() {
                Log.d((String)"RNPayTm", (String)"Network Not Available");
                WritableNativeMap params = new WritableNativeMap();
                params.putString("status", "NetworkNotAvailable");
                RNPayTmModule.this.sendEvent("PayTMResponse", (WritableMap)params);
            }

            public void clientAuthenticationFailed(String inErrorMessage) {
                Log.d((String)"RNPayTm", (String)("Client Authentication Failed: " + inErrorMessage));
                WritableNativeMap params = new WritableNativeMap();
                params.putString("status", "ClientAuthenticationFailed");
                RNPayTmModule.this.sendEvent("PayTMResponse", (WritableMap)params);
            }

            public void onErrorLoadingWebPage(int iniErrorCode, String inErrorMessage, String inFailingUrl) {
                Log.d((String)"RNPayTm", (String)("Error Loading WebPage: " + inErrorMessage));
                WritableNativeMap params = new WritableNativeMap();
                params.putString("status", "ErrorLoadingWebPage");
                RNPayTmModule.this.sendEvent("PayTMResponse", (WritableMap)params);
            }

            public void onBackPressedCancelTransaction() {
                Log.d((String)"RNPayTm", (String)"Transaction cancelled: BackPressedCancelTransaction");
                WritableNativeMap params = new WritableNativeMap();
                params.putString("status", "Cancel");
                RNPayTmModule.this.sendEvent("PayTMResponse", (WritableMap)params);
            }

            public void onTransactionCancel(String inErrorMessage, Bundle inResponse) {
                Log.d((String)"RNPayTm", (String)("Transaction cancelled: " + inErrorMessage));
                WritableMap params = Arguments.fromBundle((Bundle)inResponse);
                params.putString("status", "Cancel");
                RNPayTmModule.this.sendEvent("PayTMResponse", params);
            }
        });
    }

    private void sendEvent(String eventName, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }
}

