/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay.rn;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.razorpay.Checkout;
import com.razorpay.CheckoutActivity;
import com.razorpay.ExternalWalletListener;
import com.razorpay.PaymentData;
import com.razorpay.PaymentResultWithDataListener;
import com.razorpay.rn.NativeRazorpaySpec;
import com.razorpay.rn.Utils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@ReactModule(name="Razorpay")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001.B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001c\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\r2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J$\u0010#\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\r2\b\u0010$\u001a\u0004\u0018\u00010\"H\u0016J*\u0010\u0019\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u001eH\u0016J\u001c\u0010)\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\r2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/razorpay/rn/RazorpayModule;", "Lcom/razorpay/rn/NativeRazorpaySpec;", "Lcom/razorpay/PaymentResultWithDataListener;", "Lcom/razorpay/ExternalWalletListener;", "Lcom/facebook/react/bridge/ActivityEventListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "checkout", "Lcom/razorpay/Checkout;", "eventsHash", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getName", "multiply", "", "a", "b", "open", "", "options", "Lcom/facebook/react/bridge/ReadableMap;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onPaymentSuccess", "p0", "p1", "Lcom/razorpay/PaymentData;", "onPaymentError", "p2", "activity", "Landroid/app/Activity;", "onNewIntent", "intent", "onExternalWalletSelected", "sendEvent", "eventName", "params", "Lcom/facebook/react/bridge/WritableMap;", "Companion", "react-native-razorpay_debug"})
public final class RazorpayModule
extends NativeRazorpaySpec
implements PaymentResultWithDataListener,
ExternalWalletListener,
ActivityEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Checkout checkout;
    @NotNull
    private HashMap<String, Object> eventsHash;
    @NotNull
    public static final String NAME = "Razorpay";

    /*
     * WARNING - void declaration
     */
    public RazorpayModule(@NotNull ReactApplicationContext reactContext) {
        void $this$eventsHash_u24lambda_u240;
        HashMap hashMap;
        Intrinsics.checkNotNullParameter((Object)reactContext, (String)"reactContext");
        super(reactContext);
        HashMap hashMap2 = hashMap = new HashMap();
        RazorpayModule razorpayModule = this;
        boolean bl = false;
        $this$eventsHash_u24lambda_u240.put("success", "Razorpay::PAYMENT_SUCCESS");
        $this$eventsHash_u24lambda_u240.put("failure", "Razorpay::PAYMENT_ERROR");
        $this$eventsHash_u24lambda_u240.put("external_wallet", "Razorpay::EXTERNAL_WALLET_SELECTED");
        razorpayModule.eventsHash = hashMap;
        reactContext.addActivityEventListener((ActivityEventListener)this);
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    public double multiply(double a, double b) {
        return a * b;
    }

    @Override
    public void open(@Nullable ReadableMap options) {
        Activity activity = this.getReactApplicationContext().getCurrentActivity();
        if (activity == null) {
            Object object = this.eventsHash.get("failure");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            this.sendEvent((String)object, Utils.createErrorJson("REACT_NO_ACTIVITY_FOUND", "Activity object cannot be null", null));
            return;
        }
        try {
            Intent intent;
            if (options == null) {
                Object object = this.eventsHash.get("failure");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this.sendEvent((String)object, Utils.createErrorJson("REACT_INVALID_OPTIONS", "Options object is invalid. Please try again", null));
                return;
            }
            this.checkout = new Checkout();
            JSONObject optionsJSON = Utils.readableMapToJson(options);
            Intent $this$open_u24lambda_u241 = intent = new Intent((Context)activity, CheckoutActivity.class);
            boolean bl = false;
            $this$open_u24lambda_u241.putExtra("OPTIONS", optionsJSON.toString());
            $this$open_u24lambda_u241.putExtra("FRAMEWORK", "react_native");
            Intent intent2 = intent;
            activity.startActivityForResult(intent2, 62442);
        }
        catch (Exception e) {
            Object object = this.eventsHash.get("failure");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            this.sendEvent((String)object, Utils.createErrorJson("REACT_NATIVE_ERROR", e.getMessage(), null));
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 62442) {
            Checkout checkout = this.checkout;
            if (checkout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"checkout");
                checkout = null;
            }
            checkout.merchantActivityResult(this.getReactApplicationContext().getCurrentActivity(), requestCode, resultCode, data, (PaymentResultWithDataListener)this, (ExternalWalletListener)this);
        }
    }

    public void onPaymentSuccess(@Nullable String p0, @Nullable PaymentData p1) {
        block0: {
            PaymentData paymentData = p1;
            if (paymentData == null) break block0;
            PaymentData it = paymentData;
            boolean bl = false;
            Object object = this.eventsHash.get("success");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)object;
            JSONObject jSONObject = it.getData();
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getData(...)");
            this.sendEvent(string, Utils.jsonToWritableMap(jSONObject));
        }
    }

    public void onPaymentError(int p0, @Nullable String p1, @Nullable PaymentData p2) {
        block2: {
            PaymentData paymentData = p2;
            if (paymentData == null) break block2;
            PaymentData it = paymentData;
            boolean bl = false;
            JSONObject paymentDataJson = p2.getData();
            try {
                paymentDataJson.put("code", p0);
                paymentDataJson.put("description", (Object)p1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = this.eventsHash.get("failure");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)object;
            Intrinsics.checkNotNull((Object)paymentDataJson);
            this.sendEvent(string, Utils.jsonToWritableMap(paymentDataJson));
        }
    }

    public void onActivityResult(@NotNull Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.onActivityResult(requestCode, resultCode, data);
    }

    public void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
    }

    public void onExternalWalletSelected(@Nullable String p0, @Nullable PaymentData p1) {
        block0: {
            PaymentData paymentData = p1;
            if (paymentData == null) break block0;
            PaymentData it = paymentData;
            boolean bl = false;
            Object object = this.eventsHash.get("external_wallet");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)object;
            JSONObject jSONObject = it.getData();
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getData(...)");
            this.sendEvent(string, Utils.jsonToWritableMap(jSONObject));
        }
    }

    private final void sendEvent(String eventName, WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/razorpay/rn/RazorpayModule$Companion;", "", "<init>", "()V", "NAME", "", "react-native-razorpay_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

