/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay.rn;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0007\u00a8\u0006\u0017"}, d2={"Lcom/razorpay/rn/Utils;", "", "<init>", "()V", "createErrorJson", "Lcom/facebook/react/bridge/WritableMap;", "code", "", "message", "metadata", "readableMapToJson", "Lorg/json/JSONObject;", "readableMap", "Lcom/facebook/react/bridge/ReadableMap;", "readableArrayToJson", "Lorg/json/JSONArray;", "readableArray", "Lcom/facebook/react/bridge/ReadableArray;", "jsonToWritableMap", "jsonObject", "jsonToWritableArray", "Lcom/facebook/react/bridge/WritableArray;", "jsonArray", "react-native-razorpay_debug"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @JvmStatic
    @NotNull
    public static final WritableMap createErrorJson(@NotNull String code, @Nullable String message, @Nullable WritableMap metadata) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        WritableMap writableMap = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
        WritableMap errorJson = writableMap;
        errorJson.putString("code", code);
        if (message != null) {
            errorJson.putString("description", message);
        }
        if (metadata != null) {
            errorJson.putMap("metadata", (ReadableMap)metadata);
        }
        return errorJson;
    }

    @JvmStatic
    @NotNull
    public static final JSONObject readableMapToJson(@NotNull ReadableMap readableMap) {
        Intrinsics.checkNotNullParameter((Object)readableMap, (String)"readableMap");
        JSONObject jsonObject = new JSONObject();
        try {
            ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
            while (iterator.hasNextKey()) {
                String key = iterator.nextKey();
                switch (WhenMappings.$EnumSwitchMapping$0[readableMap.getType(key).ordinal()]) {
                    case 1: {
                        JSONObject jSONObject = jsonObject.put(key, JSONObject.NULL);
                        break;
                    }
                    case 2: {
                        JSONObject jSONObject = jsonObject.put(key, readableMap.getBoolean(key));
                        break;
                    }
                    case 3: {
                        JSONObject jSONObject = jsonObject.put(key, readableMap.getDouble(key));
                        break;
                    }
                    case 4: {
                        JSONObject jSONObject = jsonObject.put(key, (Object)readableMap.getString(key));
                        break;
                    }
                    case 5: {
                        ReadableMap readableMap2 = readableMap.getMap(key);
                        Intrinsics.checkNotNull((Object)readableMap2);
                        JSONObject jSONObject = jsonObject.put(key, (Object)Utils.readableMapToJson(readableMap2));
                        break;
                    }
                    case 6: {
                        ReadableArray readableArray = readableMap.getArray(key);
                        Intrinsics.checkNotNull((Object)readableArray);
                        JSONObject jSONObject = jsonObject.put(key, (Object)Utils.readableArrayToJson(readableArray));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    @JvmStatic
    @NotNull
    public static final JSONArray readableArrayToJson(@NotNull ReadableArray readableArray) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)readableArray, (String)"readableArray");
        JSONArray jsonArray = new JSONArray();
        int n = readableArray.size();
        block8: for (int i = 0; i < n; ++i) {
            switch (WhenMappings.$EnumSwitchMapping$0[readableArray.getType(i).ordinal()]) {
                case 1: {
                    Unit unit = Unit.INSTANCE;
                    continue block8;
                }
                case 2: {
                    Unit unit = jsonArray.put(readableArray.getBoolean(i));
                    continue block8;
                }
                case 3: {
                    Unit unit = jsonArray.put(readableArray.getDouble(i));
                    continue block8;
                }
                case 4: {
                    Unit unit = jsonArray.put((Object)readableArray.getString(i));
                    continue block8;
                }
                case 5: {
                    ReadableMap readableMap = readableArray.getMap(i);
                    Intrinsics.checkNotNull((Object)readableMap);
                    Unit unit = jsonArray.put((Object)Utils.readableMapToJson(readableMap));
                    continue block8;
                }
                case 6: {
                    ReadableArray readableArray2 = readableArray.getArray(i);
                    Intrinsics.checkNotNull((Object)readableArray2);
                    Unit unit = jsonArray.put((Object)Utils.readableArrayToJson(readableArray2));
                    continue block8;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return jsonArray;
    }

    @JvmStatic
    @NotNull
    public static final WritableMap jsonToWritableMap(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        WritableNativeMap writableMap = new WritableNativeMap();
        try {
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                Object value;
                Object e = iterator.next();
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                String key = (String)e;
                Object object = value = jsonObject.get(key);
                if (object instanceof Float || object instanceof Double) {
                    writableMap.putDouble(key, jsonObject.getDouble(key));
                    continue;
                }
                if (object instanceof Number) {
                    writableMap.putInt(key, jsonObject.getInt(key));
                    continue;
                }
                if (object instanceof String) {
                    writableMap.putString(key, jsonObject.getString(key));
                    continue;
                }
                if (object instanceof JSONObject) {
                    JSONObject jSONObject = jsonObject.getJSONObject(key);
                    Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getJSONObject(...)");
                    writableMap.putMap(key, (ReadableMap)Utils.jsonToWritableMap(jSONObject));
                    continue;
                }
                if (object instanceof JSONArray) {
                    JSONArray jSONArray = jsonObject.getJSONArray(key);
                    Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"getJSONArray(...)");
                    writableMap.putArray(key, (ReadableArray)Utils.jsonToWritableArray(jSONArray));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)object, (Object)JSONObject.NULL)) continue;
                writableMap.putNull(key);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return (WritableMap)writableMap;
    }

    @JvmStatic
    @NotNull
    public static final WritableArray jsonToWritableArray(@NotNull JSONArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        WritableNativeArray writableArray = new WritableNativeArray();
        try {
            int n = jsonArray.length();
            for (int i = 0; i < n; ++i) {
                Object value = jsonArray.get(i);
                Object object = value;
                if (object instanceof Float || object instanceof Double) {
                    writableArray.pushDouble(jsonArray.getDouble(i));
                    continue;
                }
                if (object instanceof Number) {
                    writableArray.pushInt(jsonArray.getInt(i));
                    continue;
                }
                if (object instanceof String) {
                    writableArray.pushString(jsonArray.getString(i));
                    continue;
                }
                if (object instanceof JSONObject) {
                    JSONObject jSONObject = jsonArray.getJSONObject(i);
                    Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getJSONObject(...)");
                    writableArray.pushMap((ReadableMap)Utils.jsonToWritableMap(jSONObject));
                    continue;
                }
                if (object instanceof JSONArray) {
                    JSONArray jSONArray = jsonArray.getJSONArray(i);
                    Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"getJSONArray(...)");
                    writableArray.pushArray((ReadableArray)Utils.jsonToWritableArray(jSONArray));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)object, (Object)JSONObject.NULL)) continue;
                writableArray.pushNull();
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return (WritableArray)writableArray;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadableType.values().length];
            try {
                nArray[ReadableType.Null.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Boolean.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Number.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.String.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Map.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Array.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

