/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.iot.esptouch.task;

import com.espressif.iot.esptouch.task.IEsptouchTaskParameter;

public class EsptouchTaskParameter
implements IEsptouchTaskParameter {
    private long mIntervalGuideCodeMillisecond = 10L;
    private long mIntervalDataCodeMillisecond = 10L;
    private long mTimeoutGuideCodeMillisecond = 2000L;
    private long mTimeoutDataCodeMillisecond = 4000L;
    private int mTotalRepeatTime = 1;
    private int mEsptouchResultOneLen = 1;
    private int mEsptouchResultMacLen = 6;
    private int mEsptouchResultIpLen = 4;
    private int mEsptouchResultTotalLen = 11;
    private int mPortListening = 18266;
    private int mTargetPort = 7001;
    private int mWaitUdpReceivingMilliseond = 15000;
    private int mWaitUdpSendingMillisecond = 45000;
    private int mThresholdSucBroadcastCount = 1;
    private int mExpectTaskResultCount = 1;
    private static int _datagramCount = 0;

    private static int __getNextDatagramCount() {
        return 1 + _datagramCount++ % 100;
    }

    @Override
    public long getIntervalGuideCodeMillisecond() {
        return this.mIntervalGuideCodeMillisecond;
    }

    @Override
    public long getIntervalDataCodeMillisecond() {
        return this.mIntervalDataCodeMillisecond;
    }

    @Override
    public long getTimeoutGuideCodeMillisecond() {
        return this.mTimeoutGuideCodeMillisecond;
    }

    @Override
    public long getTimeoutDataCodeMillisecond() {
        return this.mTimeoutDataCodeMillisecond;
    }

    @Override
    public long getTimeoutTotalCodeMillisecond() {
        return this.mTimeoutGuideCodeMillisecond + this.mTimeoutDataCodeMillisecond;
    }

    @Override
    public int getTotalRepeatTime() {
        return this.mTotalRepeatTime;
    }

    @Override
    public int getEsptouchResultOneLen() {
        return this.mEsptouchResultOneLen;
    }

    @Override
    public int getEsptouchResultMacLen() {
        return this.mEsptouchResultMacLen;
    }

    @Override
    public int getEsptouchResultIpLen() {
        return this.mEsptouchResultIpLen;
    }

    @Override
    public int getEsptouchResultTotalLen() {
        return this.mEsptouchResultTotalLen;
    }

    @Override
    public int getPortListening() {
        return this.mPortListening;
    }

    @Override
    public String getTargetHostname() {
        int count = EsptouchTaskParameter.__getNextDatagramCount();
        return "234." + count + "." + count + "." + count;
    }

    @Override
    public int getTargetPort() {
        return this.mTargetPort;
    }

    @Override
    public int getWaitUdpReceivingMillisecond() {
        return this.mWaitUdpReceivingMilliseond;
    }

    @Override
    public int getWaitUdpSendingMillisecond() {
        return this.mWaitUdpSendingMillisecond;
    }

    @Override
    public int getWaitUdpTotalMillisecond() {
        return this.mWaitUdpReceivingMilliseond + this.mWaitUdpSendingMillisecond;
    }

    @Override
    public int getThresholdSucBroadcastCount() {
        return this.mThresholdSucBroadcastCount;
    }

    @Override
    public void setWaitUdpTotalMillisecond(int waitUdpTotalMillisecond) {
        if ((long)waitUdpTotalMillisecond < (long)this.mWaitUdpReceivingMilliseond + this.getTimeoutTotalCodeMillisecond()) {
            throw new IllegalArgumentException("waitUdpTotalMillisecod is invalid, it is less than mWaitUdpReceivingMilliseond + getTimeoutTotalCodeMillisecond()");
        }
        this.mWaitUdpSendingMillisecond = waitUdpTotalMillisecond - this.mWaitUdpReceivingMilliseond;
    }

    @Override
    public int getExpectTaskResultCount() {
        return this.mExpectTaskResultCount;
    }

    @Override
    public void setExpectTaskResultCount(int expectTaskResultCount) {
        this.mExpectTaskResultCount = expectTaskResultCount;
    }
}

