/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.iot.esptouch.util;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class EspNetUtil {
    public static InetAddress getLocalInetAddress(Context context) {
        WifiManager wm = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wm.getConnectionInfo();
        int localAddrInt = wifiInfo.getIpAddress();
        String localAddrStr = EspNetUtil.__formatString(localAddrInt);
        InetAddress localInetAddr = null;
        try {
            localInetAddr = InetAddress.getByName(localAddrStr);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return localInetAddr;
    }

    private static String __formatString(int value) {
        String strValue = "";
        byte[] ary = EspNetUtil.__intToByteArray(value);
        for (int i = ary.length - 1; i >= 0; --i) {
            strValue = strValue + (ary[i] & 0xFF);
            if (i <= 0) continue;
            strValue = strValue + ".";
        }
        return strValue;
    }

    private static byte[] __intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static InetAddress parseInetAddr(byte[] inetAddrBytes, int offset, int count) {
        InetAddress inetAddress = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(Integer.toString(inetAddrBytes[offset + i] & 0xFF));
            if (i == count - 1) continue;
            sb.append('.');
        }
        try {
            inetAddress = InetAddress.getByName(sb.toString());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return inetAddress;
    }

    public static byte[] parseBssid2bytes(String bssid) {
        String[] bssidSplits = bssid.split(":");
        if (bssidSplits.length < 8) {
            return new byte[0];
        }
        byte[] result = new byte[bssidSplits.length];
        for (int i = 0; i < bssidSplits.length; ++i) {
            result[i] = (byte)Integer.parseInt(bssidSplits[i], 16);
        }
        return result;
    }
}

