/*
 * Decompiled with CFR 0.152.
 */
package com.tuanpm.RCTSmartconfig;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.espressif.iot.esptouch.EsptouchTask;
import com.espressif.iot.esptouch.IEsptouchResult;
import com.espressif.iot.esptouch.IEsptouchTask;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import java.util.List;

public class RCTSmartconfigModule
extends ReactContextBaseJavaModule {
    private static final String TAG = "RCTSmartconfigModule";
    private final ReactApplicationContext _reactContext;
    private IEsptouchTask mEsptouchTask;

    public RCTSmartconfigModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this._reactContext = reactContext;
    }

    public String getName() {
        return "Smartconfig";
    }

    @ReactMethod
    public void stop() {
        if (this.mEsptouchTask != null) {
            Log.d((String)TAG, (String)"cancel task");
            this.mEsptouchTask.interrupt();
        }
    }

    @ReactMethod
    public void start(ReadableMap options, final Promise promise) {
        String ssid = options.getString("ssid");
        String pass = options.getString("password");
        Boolean hidden = false;
        Log.d((String)TAG, (String)("ssid " + ssid + ":pass " + pass));
        this.stop();
        new EsptouchAsyncTask(new TaskListener(){

            @Override
            public void onFinished(List<IEsptouchResult> result) {
                WritableArray ret = Arguments.createArray();
                Boolean resolved = false;
                for (IEsptouchResult resultInList : result) {
                    if (resultInList.isCancelled() || resultInList.getBssid() == null) continue;
                    WritableMap map = Arguments.createMap();
                    map.putString("bssid", resultInList.getBssid());
                    map.putString("ipv4", resultInList.getInetAddress().getHostAddress());
                    ret.pushMap((ReadableMap)map);
                    resolved = true;
                    if (resultInList.isSuc()) continue;
                    break;
                }
                if (resolved.booleanValue()) {
                    Log.d((String)RCTSmartconfigModule.TAG, (String)"Success run smartconfig");
                    promise.resolve((Object)ret);
                } else {
                    Log.d((String)RCTSmartconfigModule.TAG, (String)"Error run smartconfig");
                    promise.reject("new IllegalViewOperationException()");
                }
            }
        }).execute(new String[]{ssid, new String(""), pass, "YES", "1"});
    }

    private class EsptouchAsyncTask
    extends AsyncTask<String, Void, List<IEsptouchResult>> {
        private final TaskListener taskListener;
        private final Object mLock = new Object();

        public EsptouchAsyncTask(TaskListener listener) {
            this.taskListener = listener;
        }

        protected void onPreExecute() {
            Log.d((String)RCTSmartconfigModule.TAG, (String)"Begin task");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<IEsptouchResult> doInBackground(String ... params) {
            Log.d((String)RCTSmartconfigModule.TAG, (String)"doing task");
            int taskResultCount = -1;
            Object object = this.mLock;
            synchronized (object) {
                String apSsid = params[0];
                String apBssid = params[1];
                String apPassword = params[2];
                String isSsidHiddenStr = params[3];
                String taskResultCountStr = params[4];
                boolean isSsidHidden = false;
                if (isSsidHiddenStr.equals("YES")) {
                    isSsidHidden = true;
                }
                taskResultCount = Integer.parseInt(taskResultCountStr);
                RCTSmartconfigModule.this.mEsptouchTask = new EsptouchTask(apSsid, apBssid, apPassword, isSsidHidden, (Context)RCTSmartconfigModule.this.getCurrentActivity());
            }
            List<IEsptouchResult> resultList = RCTSmartconfigModule.this.mEsptouchTask.executeForResults(taskResultCount);
            return resultList;
        }

        protected void onPostExecute(List<IEsptouchResult> result) {
            IEsptouchResult firstResult = result.get(0);
            if (!firstResult.isCancelled() && this.taskListener != null) {
                this.taskListener.onFinished(result);
            }
        }
    }

    public static interface TaskListener {
        public void onFinished(List<IEsptouchResult> var1);
    }
}

