/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.iot.esptouch.protocol;

import com.espressif.iot.esptouch.protocol.DataCode;
import com.espressif.iot.esptouch.task.ICodeData;
import com.espressif.iot.esptouch.util.ByteUtil;
import com.espressif.iot.esptouch.util.CRC8;
import com.espressif.iot.esptouch.util.EspNetUtil;
import java.net.InetAddress;

public class DatumCode
implements ICodeData {
    private static final int EXTRA_LEN = 40;
    private static final int EXTRA_HEAD_LEN = 5;
    private final DataCode[] mDataCodes;

    public DatumCode(String apSsid, String apBssid, String apPassword, InetAddress ipAddress, boolean isSsidHiden) {
        int i;
        int i2;
        char totalXor = '\u0000';
        char apPwdLen = (char)ByteUtil.getBytesByString(apPassword).length;
        CRC8 crc = new CRC8();
        crc.update(ByteUtil.getBytesByString(apSsid));
        char apSsidCrc = (char)crc.getValue();
        crc.reset();
        crc.update(EspNetUtil.parseBssid2bytes(apBssid));
        char apBssidCrc = (char)crc.getValue();
        char apSsidLen = (char)ByteUtil.getBytesByString(apSsid).length;
        String[] ipAddrStrs = ipAddress.getHostAddress().split("\\.");
        int ipLen = ipAddrStrs.length;
        char[] ipAddrChars = new char[ipLen];
        for (int i3 = 0; i3 < ipLen; ++i3) {
            ipAddrChars[i3] = (char)Integer.parseInt(ipAddrStrs[i3]);
        }
        char _totalLen = (char)(5 + ipLen + apPwdLen + apSsidLen);
        char totalLen = isSsidHiden ? (char)(5 + ipLen + apPwdLen + apSsidLen) : (char)(5 + ipLen + apPwdLen);
        this.mDataCodes = new DataCode[totalLen];
        this.mDataCodes[0] = new DataCode(_totalLen, 0);
        totalXor = (char)(totalXor ^ _totalLen);
        this.mDataCodes[1] = new DataCode(apPwdLen, 1);
        totalXor = (char)(totalXor ^ apPwdLen);
        this.mDataCodes[2] = new DataCode(apSsidCrc, 2);
        totalXor = (char)(totalXor ^ apSsidCrc);
        this.mDataCodes[3] = new DataCode(apBssidCrc, 3);
        totalXor = (char)(totalXor ^ apBssidCrc);
        this.mDataCodes[4] = null;
        for (int i4 = 0; i4 < ipLen; ++i4) {
            this.mDataCodes[i4 + 5] = new DataCode(ipAddrChars[i4], i4 + 5);
            totalXor = (char)(totalXor ^ ipAddrChars[i4]);
        }
        byte[] apPwdBytes = ByteUtil.getBytesByString(apPassword);
        char[] apPwdChars = new char[apPwdBytes.length];
        for (i2 = 0; i2 < apPwdBytes.length; ++i2) {
            apPwdChars[i2] = ByteUtil.convertByte2Uint8(apPwdBytes[i2]);
        }
        for (i2 = 0; i2 < apPwdChars.length; ++i2) {
            this.mDataCodes[i2 + 5 + ipLen] = new DataCode(apPwdChars[i2], i2 + 5 + ipLen);
            totalXor = (char)(totalXor ^ apPwdChars[i2]);
        }
        byte[] apSsidBytes = ByteUtil.getBytesByString(apSsid);
        char[] apSsidChars = new char[apSsidBytes.length];
        for (i = 0; i < apSsidBytes.length; ++i) {
            apSsidChars[i] = ByteUtil.convertByte2Uint8(apSsidBytes[i]);
            totalXor = (char)(totalXor ^ apSsidChars[i]);
        }
        if (isSsidHiden) {
            for (i = 0; i < apSsidChars.length; ++i) {
                this.mDataCodes[i + 5 + ipLen + apPwdLen] = new DataCode(apSsidChars[i], i + 5 + ipLen + apPwdLen);
            }
        }
        this.mDataCodes[4] = new DataCode(totalXor, 4);
    }

    @Override
    public byte[] getBytes() {
        byte[] datumCode = new byte[this.mDataCodes.length * 6];
        for (int i = 0; i < this.mDataCodes.length; ++i) {
            System.arraycopy(this.mDataCodes[i].getBytes(), 0, datumCode, i * 6, 6);
        }
        return datumCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        byte[] dataBytes = this.getBytes();
        for (int i = 0; i < dataBytes.length; ++i) {
            String hexString = ByteUtil.convertByte2HexString(dataBytes[i]);
            sb.append("0x");
            if (hexString.length() == 1) {
                sb.append("0");
            }
            sb.append(hexString).append(" ");
        }
        return sb.toString();
    }

    @Override
    public char[] getU8s() {
        byte[] dataBytes = this.getBytes();
        int len = dataBytes.length / 2;
        char[] dataU8s = new char[len];
        for (int i = 0; i < len; ++i) {
            byte high = dataBytes[i * 2];
            byte low = dataBytes[i * 2 + 1];
            dataU8s[i] = (char)(ByteUtil.combine2bytesToU16(high, low) + 40);
        }
        return dataU8s;
    }
}

