/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativesmartconfigswjava;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import esptouch.EsptouchTask;
import esptouch.IEsptouchResult;
import esptouch.IEsptouchTask;
import java.util.List;

public class SmartconfigSwjavaModule
extends ReactContextBaseJavaModule {
    private static final String TAG = "SmartconfigSwjavaModule";
    private final ReactApplicationContext _reactContext;
    private IEsptouchTask mEsptouchTask;
    private Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            String data = (String)message.obj;
            SmartconfigSwjavaModule.this.sendToRN("onFoundDevice", data);
        }
    };

    public SmartconfigSwjavaModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this._reactContext = reactContext;
    }

    public String getName() {
        return "SmartconfigSwjava";
    }

    @ReactMethod
    public void addListener(String eventName) {
    }

    @ReactMethod
    public void removeListeners(Integer count) {
    }

    @ReactMethod
    public void stop() {
        if (this.mEsptouchTask != null) {
            Log.d((String)TAG, (String)"cancel task");
            this.mEsptouchTask.interrupt();
        }
    }

    @ReactMethod
    public void start(String ssid, String bssid, String pass, int timeout, int taskCount, Promise promise) {
        Log.d((String)TAG, (String)("ssid " + ssid + ":pass " + pass));
        this.stop();
        new EsptouchAsyncTask(result -> this.onFinishScan()).execute(new String[]{ssid, bssid, pass, Integer.toString(taskCount), Integer.toString(timeout)});
    }

    private void sendToRN(String eventName, String data) {
        String eventSendToRN = "SmartConfig";
        Log.d((String)TAG, (String)("send to RN " + eventName + " " + data));
        WritableMap payload = Arguments.createMap();
        payload.putString("eventName", eventName);
        payload.putString("data", data);
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this._reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventSendToRN, (Object)payload);
    }

    private void onFoundDevice(String data) {
        Message message = this.handler.obtainMessage(0, (Object)data);
        message.sendToTarget();
    }

    private void onFinishScan() {
        this.sendToRN("onFinishScan", "");
    }

    private class EsptouchAsyncTask
    extends AsyncTask<String, Void, List<IEsptouchResult>> {
        private final TaskListener taskListener;
        private final Object mLock = new Object();

        public EsptouchAsyncTask(TaskListener listener) {
            this.taskListener = listener;
        }

        protected void onPreExecute() {
            Log.d((String)SmartconfigSwjavaModule.TAG, (String)"Begin task");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<IEsptouchResult> doInBackground(String ... params) {
            Log.d((String)SmartconfigSwjavaModule.TAG, (String)"doing task");
            int taskCount = -1;
            int timeout = 60000;
            Object object = this.mLock;
            synchronized (object) {
                String apSsid = params[0];
                String apBssid = params[1];
                String apPassword = params[2];
                Log.d((String)SmartconfigSwjavaModule.TAG, (String)(apSsid + " | " + apBssid + " | " + apPassword));
                String taskCountStr = params[3];
                String timeoutStr = params[4];
                taskCount = Integer.parseInt(taskCountStr);
                timeout = Integer.parseInt(timeoutStr);
                SmartconfigSwjavaModule.this.mEsptouchTask = new EsptouchTask(apSsid, apBssid, apPassword, (Context)SmartconfigSwjavaModule.this._reactContext);
                SmartconfigSwjavaModule.this.mEsptouchTask.setPackageBroadcast(false);
                SmartconfigSwjavaModule.this.mEsptouchTask.setEsptouchListener(result -> {
                    String ip = result.getInetAddress().getHostAddress();
                    String bssid = result.getBssid();
                    String data = "{\"ip\":\"" + ip + "\", \"bssid\":\"" + bssid + "\"}";
                    SmartconfigSwjavaModule.this.onFoundDevice(data);
                });
            }
            List<IEsptouchResult> resultList = SmartconfigSwjavaModule.this.mEsptouchTask.executeForResults(taskCount);
            return resultList;
        }

        protected void onPostExecute(List<IEsptouchResult> result) {
            IEsptouchResult firstResult = result.get(0);
            if (!firstResult.isCancelled() && this.taskListener != null) {
                this.taskListener.onFinished(result);
            }
        }
    }

    public static interface TaskListener {
        public void onFinished(List<IEsptouchResult> var1);
    }
}

