/*
 * Decompiled with CFR 0.152.
 */
package esptouch;

import android.content.Context;
import android.text.TextUtils;
import esptouch.IEsptouchListener;
import esptouch.IEsptouchResult;
import esptouch.IEsptouchTask;
import esptouch.protocol.TouchData;
import esptouch.task.EsptouchTaskParameter;
import esptouch.task.__EsptouchTask;
import esptouch.util.EspAES;
import esptouch.util.TouchNetUtil;
import java.util.List;

public class EsptouchTask
implements IEsptouchTask {
    private __EsptouchTask _mEsptouchTask;
    private EsptouchTaskParameter _mParameter;

    public EsptouchTask(String apSsid, String apBssid, String apPassword, Context context) {
        this(apSsid, apBssid, apPassword, null, context);
    }

    public EsptouchTask(byte[] apSsid, byte[] apBssid, byte[] apPassword, Context context) {
        this(apSsid, apBssid, apPassword, null, context);
    }

    private EsptouchTask(String apSsid, String apBssid, String apPassword, EspAES espAES, Context context) {
        if (TextUtils.isEmpty((CharSequence)apSsid)) {
            throw new NullPointerException("SSID can't be empty");
        }
        if (TextUtils.isEmpty((CharSequence)apBssid)) {
            throw new NullPointerException("BSSID can't be empty");
        }
        if (apPassword == null) {
            apPassword = "";
        }
        TouchData ssid = new TouchData(apSsid);
        TouchData bssid = new TouchData(TouchNetUtil.parseBssid2bytes(apBssid));
        TouchData password = new TouchData(apPassword);
        this.init(context, ssid, bssid, password, espAES);
    }

    private EsptouchTask(byte[] apSsid, byte[] apBssid, byte[] apPassword, EspAES espAES, Context context) {
        if (apSsid == null || apSsid.length == 0) {
            throw new NullPointerException("SSID can't be empty");
        }
        if (apBssid == null || apBssid.length == 0) {
            throw new NullPointerException("BSSID can't be empty");
        }
        if (apPassword == null) {
            apPassword = new byte[]{};
        }
        TouchData ssid = new TouchData(apSsid);
        TouchData bssid = new TouchData(apBssid);
        TouchData password = new TouchData(apPassword);
        this.init(context, ssid, bssid, password, espAES);
    }

    private void init(Context context, TouchData ssid, TouchData bssid, TouchData password, EspAES aes) {
        this._mParameter = new EsptouchTaskParameter();
        this._mEsptouchTask = new __EsptouchTask(context, ssid, bssid, password, aes, this._mParameter, true);
    }

    @Override
    public void interrupt() {
        this._mEsptouchTask.interrupt();
    }

    @Override
    public IEsptouchResult executeForResult() throws RuntimeException {
        return this._mEsptouchTask.executeForResult();
    }

    @Override
    public boolean isCancelled() {
        return this._mEsptouchTask.isCancelled();
    }

    @Override
    public List<IEsptouchResult> executeForResults(int expectTaskResultCount) throws RuntimeException {
        if (expectTaskResultCount <= 0) {
            expectTaskResultCount = Integer.MAX_VALUE;
        }
        return this._mEsptouchTask.executeForResults(expectTaskResultCount);
    }

    @Override
    public void setEsptouchListener(IEsptouchListener esptouchListener) {
        this._mEsptouchTask.setEsptouchListener(esptouchListener);
    }

    @Override
    public void setPackageBroadcast(boolean broadcast) {
        this._mParameter.setBroadcast(broadcast);
    }
}

