/*
 * Decompiled with CFR 0.152.
 */
package esptouch.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EspAES {
    private static final String TRANSFORMATION_DEFAULT = "AES/ECB/PKCS5Padding";
    private final byte[] mKey;
    private final byte[] mIV;
    private final String mTransformation;
    private Cipher mEncryptCipher;
    private Cipher mDecryptCipher;

    public EspAES(byte[] key) {
        this(key, null, TRANSFORMATION_DEFAULT);
    }

    public EspAES(byte[] key, String transformation) {
        this(key, null, transformation);
    }

    public EspAES(byte[] key, byte[] iv) {
        this(key, iv, TRANSFORMATION_DEFAULT);
    }

    public EspAES(byte[] key, byte[] iv, String transformation) {
        this.mKey = key;
        this.mIV = iv;
        this.mTransformation = transformation;
        this.mEncryptCipher = this.createEncryptCipher();
        this.mDecryptCipher = this.createDecryptCipher();
    }

    private Cipher createEncryptCipher() {
        try {
            Cipher cipher = Cipher.getInstance(this.mTransformation);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.mKey, "AES");
            if (this.mIV == null) {
                cipher.init(1, secretKeySpec);
            } else {
                IvParameterSpec parameterSpec = new IvParameterSpec(this.mIV);
                cipher.init(1, (Key)secretKeySpec, parameterSpec);
            }
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Cipher createDecryptCipher() {
        try {
            Cipher cipher = Cipher.getInstance(this.mTransformation);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.mKey, "AES");
            if (this.mIV == null) {
                cipher.init(2, secretKeySpec);
            } else {
                IvParameterSpec parameterSpec = new IvParameterSpec(this.mIV);
                cipher.init(2, (Key)secretKeySpec, parameterSpec);
            }
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] encrypt(byte[] content) {
        try {
            return this.mEncryptCipher.doFinal(content);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decrypt(byte[] content) {
        try {
            return this.mDecryptCipher.doFinal(content);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            e.printStackTrace();
            return null;
        }
    }
}

