/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;

class DataSourceDataContentHandler
implements DataContentHandler {
    private DataSource ds = null;
    private ActivationDataFlavor[] transferFlavors = null;
    private DataContentHandler dch = null;

    public DataSourceDataContentHandler(DataContentHandler dch, DataSource ds) {
        this.ds = ds;
        this.dch = dch;
    }

    public ActivationDataFlavor[] getTransferDataFlavors() {
        if (this.transferFlavors == null) {
            if (this.dch != null) {
                this.transferFlavors = this.dch.getTransferDataFlavors();
            } else {
                this.transferFlavors = new ActivationDataFlavor[1];
                this.transferFlavors[0] = new ActivationDataFlavor(this.ds.getContentType(), this.ds.getContentType());
            }
        }
        return this.transferFlavors;
    }

    public Object getTransferData(ActivationDataFlavor df, DataSource ds) throws IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(df, ds);
        }
        if (df.equals(this.getTransferDataFlavors()[0])) {
            return ds.getInputStream();
        }
        throw new IOException("Unsupported DataFlavor: " + df);
    }

    public Object getContent(DataSource ds) throws IOException {
        if (this.dch != null) {
            return this.dch.getContent(ds);
        }
        return ds.getInputStream();
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (this.dch == null) {
            throw new UnsupportedDataTypeException("no DCH for content type " + this.ds.getContentType());
        }
        this.dch.writeTo(obj, mimeType, os);
    }
}

