/*
 * Decompiled with CFR 0.152.
 */
package com.rntensorflowlite.imagerecognition;

import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.rntensorflowlite.imagerecognition.TFLiteImageRecognizer;
import java.util.HashMap;
import java.util.Map;

public class RNTFLiteImageRecognizerModule
extends ReactContextBaseJavaModule {
    private Map<Integer, TFLiteImageRecognizer> imageRecognizers = new HashMap<Integer, TFLiteImageRecognizer>();
    private final ReactApplicationContext reactContext;

    public RNTFLiteImageRecognizerModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "RNTFLiteImageRecognition";
    }

    @ReactMethod
    public void createImageRecognizer(ReadableMap data, Promise promise) {
        try {
            String modelPath = data.getString("model");
            String labelPath = data.getString("labels");
            TFLiteImageRecognizer ImageRecognizer = TFLiteImageRecognizer.create((ReactContext)this.reactContext, modelPath, labelPath);
            this.imageRecognizers.put(1, ImageRecognizer);
            promise.resolve((Object)true);
        }
        catch (Exception e) {
            promise.reject((Throwable)e);
        }
    }

    @ReactMethod
    public void recognize(ReadableMap data, Promise promise) {
        try {
            String image = data.getString("image");
            Integer inputShape = data.hasKey("inputShape") ? data.getInt("inputShape") : 224;
            TFLiteImageRecognizer ImageRecognizer = this.imageRecognizers.get(1);
            WritableArray result = ImageRecognizer.recognizeImage(image, inputShape);
            promise.resolve((Object)result);
        }
        catch (Exception e) {
            promise.reject((Throwable)e);
        }
    }

    @ReactMethod
    public void close(Promise promise) {
        try {
            this.imageRecognizers.remove(1);
            promise.resolve((Object)true);
        }
        catch (Exception e) {
            promise.reject((Throwable)e);
        }
    }
}

