/*
 * Decompiled with CFR 0.152.
 */
package com.rntensorflowlite.imagerecognition;

import android.annotation.SuppressLint;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.rntensorflowlite.Classifier;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.tensorflow.lite.Interpreter;

public class TFLiteImageRecognizer
implements Classifier {
    private TFLiteImageRecognizer ImageRecognizer;
    private ReactContext reactContext;
    private static final int MAX_RESULTS = 3;
    private static final int BATCH_SIZE = 1;
    private static final int PIXEL_SIZE = 3;
    private static final float THRESHOLD = 0.1f;
    long initialTime;
    long finalTime;
    private Interpreter classifier;
    private int inputShape;
    private List<String> labelList;

    public static TFLiteImageRecognizer create(ReactContext reactContext, String modelPath, String labelPath) throws IOException {
        TFLiteImageRecognizer imageRecognizer = new TFLiteImageRecognizer();
        imageRecognizer.reactContext = reactContext;
        imageRecognizer.classifier = new Interpreter(imageRecognizer.loadModelFile(reactContext.getAssets(), modelPath));
        imageRecognizer.labelList = imageRecognizer.loadLabelList(reactContext.getAssets(), labelPath);
        return imageRecognizer;
    }

    private MappedByteBuffer loadModelFile(AssetManager assetManager, String modelPath) throws IOException {
        AssetFileDescriptor fileDescriptor = assetManager.openFd(modelPath);
        FileInputStream inputStream = new FileInputStream(fileDescriptor.getFileDescriptor());
        FileChannel fileChannel = inputStream.getChannel();
        long startOffset = fileDescriptor.getStartOffset();
        long declaredLength = fileDescriptor.getDeclaredLength();
        return fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
    }

    @Override
    public WritableArray recognizeImage(String image, Integer inputShape) {
        this.inputShape = inputShape;
        Bitmap bitmap = this.convertToBitmap(this.loadResource(image));
        ByteBuffer byteBuffer = this.convertBitmapToByteBuffer(bitmap);
        float[][] result = new float[1][this.labelList.size()];
        this.initialTime = System.currentTimeMillis();
        this.classifier.run((Object)byteBuffer, (Object)result);
        this.finalTime = System.currentTimeMillis() - this.initialTime;
        return this.getSortedResult(result);
    }

    public Boolean hasFilePrefix(String resource) {
        if (resource.startsWith("file://")) {
            return true;
        }
        return false;
    }

    private byte[] loadResource(String resource) {
        try {
            InputStream inputStream = this.reactContext.getAssets().open(this.hasFilePrefix(resource) != false ? resource.substring(7) : resource);
            return this.inputStreamToByteArray(inputStream);
        }
        catch (Exception e) {
            try {
                FileInputStream inputStream = new FileInputStream(this.hasFilePrefix(resource) != false ? resource.substring(7) : resource);
                return this.inputStreamToByteArray(inputStream);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    private byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        try {
            byte[] b = new byte[inputStream.available()];
            inputStream.read(b);
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Bitmap convertToBitmap(byte[] image) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
    }

    private ByteBuffer convertBitmapToByteBuffer(Bitmap bitmapRaw) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1 * this.inputShape * this.inputShape * 3 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        int[] intValues = new int[this.inputShape * this.inputShape];
        Bitmap scaledBitmap = Bitmap.createBitmap((int)this.inputShape, (int)this.inputShape, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Matrix matrix = this.createMatrix(bitmapRaw.getWidth(), bitmapRaw.getHeight(), this.inputShape, this.inputShape);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.drawBitmap(bitmapRaw, matrix, null);
        scaledBitmap.getPixels(intValues, 0, scaledBitmap.getWidth(), 0, 0, scaledBitmap.getWidth(), scaledBitmap.getHeight());
        int pixel = 0;
        for (int i = 0; i < this.inputShape; ++i) {
            for (int j = 0; j < this.inputShape; ++j) {
                int val = intValues[pixel++];
                byteBuffer.putFloat((float)(val >> 16 & 0xFF) / 255.0f);
                byteBuffer.putFloat((float)(val >> 8 & 0xFF) / 255.0f);
                byteBuffer.putFloat((float)(val & 0xFF) / 255.0f);
            }
        }
        return byteBuffer;
    }

    private List<String> loadLabelList(AssetManager assetManager, String labelPath) throws IOException {
        String line;
        ArrayList<String> labelList = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(assetManager.open(labelPath)));
        while ((line = reader.readLine()) != null) {
            labelList.add(line);
        }
        reader.close();
        return labelList;
    }

    @SuppressLint(value={"DefaultLocale"})
    private WritableArray getSortedResult(float[][] labelProbArray) {
        ArrayList<WritableNativeMap> results = new ArrayList<WritableNativeMap>();
        for (int i = 0; i < this.labelList.size(); ++i) {
            float confidence = labelProbArray[0][i] * 100.0f / 127.0f;
            if (!(confidence > 0.1f)) continue;
            WritableNativeMap entry = new WritableNativeMap();
            entry.putString("id", String.valueOf(i));
            entry.putString("name", this.labelList.size() > i ? this.labelList.get(i) : "unknown");
            entry.putDouble("confidence", (double)confidence);
            entry.putString("inference", String.valueOf(this.finalTime));
            results.add(entry);
        }
        Collections.sort(results, new Comparator<ReadableMap>(){

            @Override
            public int compare(ReadableMap first, ReadableMap second) {
                return Double.compare(second.getDouble("confidence"), first.getDouble("confidence"));
            }
        });
        WritableNativeArray recognitions = new WritableNativeArray();
        int recognitionsSize = Math.min(results.size(), 3);
        for (int i = 0; i < recognitionsSize; ++i) {
            recognitions.pushMap((WritableMap)results.get(i));
        }
        return recognitions;
    }

    private Matrix createMatrix(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
        Matrix matrix = new Matrix();
        if (srcWidth != dstWidth || srcHeight != dstHeight) {
            float scaleFactorX = (float)dstWidth / (float)srcWidth;
            float scaleFactorY = (float)dstHeight / (float)srcHeight;
            float scaleFactor = Math.max(scaleFactorX, scaleFactorY);
            matrix.postScale(scaleFactor, scaleFactor);
        }
        matrix.invert(new Matrix());
        return matrix;
    }

    @Override
    public void close() {
        this.classifier.close();
        this.classifier = null;
    }
}

