/*
 * Decompiled with CFR 0.152.
 */
package com.reactlibrary;

import android.app.Activity;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.github.florent37.viewtooltip.ViewTooltip;

public class RNTooltipsModule
extends ReactContextBaseJavaModule {
    private final ReactApplicationContext reactContext;
    private ViewTooltip tooltip;

    public RNTooltipsModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "RNTooltips";
    }

    @ReactMethod
    public void Show(int targetId, int parentId, ReadableMap props, final Callback onHide) {
        Activity activity = this.getCurrentActivity();
        ViewGroup target = (ViewGroup)activity.findViewById(targetId);
        if (target == null) {
            return;
        }
        String text = props.getString("text");
        int position = props.getInt("position");
        int align = props.getInt("align");
        boolean autoHide = props.getBoolean("autoHide");
        int duration = props.getInt("duration");
        boolean clickToHide = props.getBoolean("clickToHide");
        int corner = props.getInt("corner");
        String tintColor = props.getString("tintColor");
        String textColor = props.getString("textColor");
        int textSize = props.getInt("textSize");
        int gravity = props.getInt("gravity");
        boolean arrow = props.getBoolean("arrow");
        this.tooltip = ViewTooltip.on((View)target);
        this.tooltip = this.tooltip.text(text);
        if (!arrow) {
            this.tooltip.arrowHeight(0);
            this.tooltip.arrowWidth(0);
        }
        if (position == 1) {
            this.tooltip = this.tooltip.position(ViewTooltip.Position.LEFT);
        } else if (position == 2) {
            this.tooltip = this.tooltip.position(ViewTooltip.Position.RIGHT);
        } else if (position == 3) {
            this.tooltip = this.tooltip.position(ViewTooltip.Position.TOP);
        } else if (position == 4) {
            this.tooltip = this.tooltip.position(ViewTooltip.Position.BOTTOM);
        }
        if (align == 1) {
            this.tooltip = this.tooltip.align(ViewTooltip.ALIGN.START);
        } else if (align == 2) {
            this.tooltip = this.tooltip.align(ViewTooltip.ALIGN.CENTER);
        } else if (align == 3) {
            this.tooltip = this.tooltip.align(ViewTooltip.ALIGN.END);
        }
        this.tooltip = this.tooltip.autoHide(autoHide, (long)duration);
        this.tooltip = this.tooltip.clickToHide(clickToHide);
        this.tooltip = this.tooltip.corner(corner);
        this.tooltip = this.tooltip.color(Color.parseColor((String)tintColor));
        this.tooltip = this.tooltip.textColor(Color.parseColor((String)textColor));
        this.tooltip = this.tooltip.textSize(2, (float)textSize);
        this.tooltip = this.tooltip.setTextGravity(gravity);
        this.tooltip.onHide(new ViewTooltip.ListenerHide(){

            public void onHide(View view) {
                onHide.invoke(new Object[0]);
            }
        });
        this.tooltip.show();
    }

    @ReactMethod
    public void Dismiss(int view) {
        if (this.tooltip == null) {
            return;
        }
        this.tooltip.close();
        this.tooltip = null;
    }
}

