/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.ReactShadowNode;

class ShadowNodeRegistry {
    private final SparseArray<ReactShadowNode> mTagsToCSSNodes = new SparseArray();
    private final SparseBooleanArray mRootTags = new SparseBooleanArray();

    public void addRootNode(ReactShadowNode node) {
        int tag = node.getReactTag();
        this.mTagsToCSSNodes.put(tag, (Object)node);
        this.mRootTags.put(tag, true);
    }

    public void removeRootNode(int tag) {
        if (!this.mRootTags.get(tag)) {
            throw new IllegalViewOperationException("View with tag " + tag + " is not registered as a root view");
        }
        this.mTagsToCSSNodes.remove(tag);
        this.mRootTags.delete(tag);
    }

    public void addNode(ReactShadowNode node) {
        this.mTagsToCSSNodes.put(node.getReactTag(), (Object)node);
    }

    public void removeNode(int tag) {
        if (this.mRootTags.get(tag)) {
            throw new IllegalViewOperationException("Trying to remove root node " + tag + " without using removeRootNode!");
        }
        this.mTagsToCSSNodes.remove(tag);
    }

    public ReactShadowNode getNode(int tag) {
        return (ReactShadowNode)this.mTagsToCSSNodes.get(tag);
    }

    public boolean isRootNode(int tag) {
        return this.mRootTags.get(tag);
    }

    public int getRootNodeCount() {
        return this.mRootTags.size();
    }

    public int getRootTag(int index) {
        return this.mRootTags.keyAt(index);
    }
}

