/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.scroll.OnScrollDispatchHelper;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.view.ReactClippingViewGroup;
import com.facebook.react.views.view.ReactClippingViewGroupHelper;
import javax.annotation.Nullable;

public class ReactHorizontalScrollView
extends HorizontalScrollView
implements ReactClippingViewGroup {
    private final OnScrollDispatchHelper mOnScrollDispatchHelper = new OnScrollDispatchHelper();
    @Nullable
    private Rect mClippingRect;
    private boolean mDoneFlinging;
    private boolean mDragging;
    private boolean mFlinging;
    private boolean mRemoveClippedSubviews;
    private boolean mScrollEnabled = true;
    private boolean mSendMomentumEvents;

    public ReactHorizontalScrollView(Context context) {
        super(context);
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews && this.mClippingRect == null) {
            this.mClippingRect = new Rect();
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        this.updateClippingRect();
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    public void setSendMomentumEvents(boolean sendMomentumEvents) {
        this.mSendMomentumEvents = sendMomentumEvents;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.scrollTo(this.getScrollX(), this.getScrollY());
    }

    protected void onScrollChanged(int x, int y, int oldX, int oldY) {
        super.onScrollChanged(x, y, oldX, oldY);
        if (this.mOnScrollDispatchHelper.onScrollChanged(x, y)) {
            if (this.mRemoveClippedSubviews) {
                this.updateClippingRect();
            }
            if (this.mFlinging) {
                this.mDoneFlinging = false;
            }
            ReactScrollViewHelper.emitScrollEvent((ViewGroup)this);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            ReactScrollViewHelper.emitScrollBeginDragEvent((ViewGroup)this);
            this.mDragging = true;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        if (action == 1 && this.mDragging) {
            ReactScrollViewHelper.emitScrollEndDragEvent((ViewGroup)this);
            this.mDragging = false;
        }
        return super.onTouchEvent(ev);
    }

    public void fling(int velocityX) {
        super.fling(velocityX);
        if (this.mSendMomentumEvents) {
            this.mFlinging = true;
            ReactScrollViewHelper.emitScrollMomentumBeginEvent((ViewGroup)this);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (ReactHorizontalScrollView.this.mDoneFlinging) {
                        ReactHorizontalScrollView.this.mFlinging = false;
                        ReactScrollViewHelper.emitScrollMomentumEndEvent((ViewGroup)ReactHorizontalScrollView.this);
                    } else {
                        ReactHorizontalScrollView.this.mDoneFlinging = true;
                        ReactHorizontalScrollView.this.postOnAnimationDelayed(this, 20L);
                    }
                }
            };
            this.postOnAnimationDelayed(r, 20L);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    @Override
    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
        View contentView = this.getChildAt(0);
        if (contentView instanceof ReactClippingViewGroup) {
            ((ReactClippingViewGroup)contentView).updateClippingRect();
        }
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set((Rect)Assertions.assertNotNull((Object)this.mClippingRect));
    }
}

