/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactBridge;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@DoNotStrip
public class Inspector {
    private final HybridData mHybridData;

    public static boolean isSupported() {
        try {
            Inspector.instance().getPagesNative();
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public static List<Page> getPages() {
        try {
            return Arrays.asList(Inspector.instance().getPagesNative());
        }
        catch (UnsatisfiedLinkError e) {
            FLog.e((String)"ReactNative", (String)"Inspector doesn't work in open source yet", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static LocalConnection connect(int pageId, RemoteConnection remote) {
        try {
            return Inspector.instance().connectNative(pageId, remote);
        }
        catch (UnsatisfiedLinkError e) {
            FLog.e((String)"ReactNative", (String)"Inspector doesn't work in open source yet", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static native Inspector instance();

    private native Page[] getPagesNative();

    private native LocalConnection connectNative(int var1, RemoteConnection var2);

    private Inspector(HybridData hybridData) {
        this.mHybridData = hybridData;
    }

    static {
        ReactBridge.staticInit();
    }

    @DoNotStrip
    public static class LocalConnection {
        private final HybridData mHybridData;

        public native void sendMessage(String var1);

        public native void disconnect();

        private LocalConnection(HybridData hybridData) {
            this.mHybridData = hybridData;
        }
    }

    @DoNotStrip
    public static interface RemoteConnection {
        public void onMessage(String var1);

        public void onDisconnect();
    }

    @DoNotStrip
    public static class Page {
        private final int mId;
        private final String mTitle;

        public int getId() {
            return this.mId;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String toString() {
            return "Page{mId=" + this.mId + ", mTitle='" + this.mTitle + '\'' + '}';
        }

        @DoNotStrip
        private Page(int id, String title) {
            this.mId = id;
            this.mTitle = title;
        }
    }
}

