/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.facebook.infer.annotation.Assertions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ShakeDetector
implements SensorEventListener {
    private static final int MAX_SAMPLES = 40;
    private static final long MIN_TIME_BETWEEN_SAMPLES_NS = TimeUnit.NANOSECONDS.convert(20L, TimeUnit.MILLISECONDS);
    private static final long VISIBLE_TIME_RANGE_NS = TimeUnit.NANOSECONDS.convert(250L, TimeUnit.MILLISECONDS);
    private static final int MAGNITUDE_THRESHOLD = 25;
    private static final int PERCENT_OVER_THRESHOLD_FOR_SHAKE = 60;
    private static final float SHAKING_WINDOW_NS = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
    private final ShakeListener mShakeListener;
    @Nullable
    private SensorManager mSensorManager;
    private long mLastTimestamp;
    private int mCurrentIndex;
    private int mNumShakes;
    private long mLastShakeTimestamp;
    @Nullable
    private double[] mMagnitudes;
    @Nullable
    private long[] mTimestamps;
    private int mMinNumShakes;

    public ShakeDetector(ShakeListener listener) {
        this(listener, 1);
    }

    public ShakeDetector(ShakeListener listener, int minNumShakes) {
        this.mShakeListener = listener;
        this.mMinNumShakes = minNumShakes;
    }

    public void start(SensorManager manager) {
        Assertions.assertNotNull((Object)manager);
        Sensor accelerometer = manager.getDefaultSensor(1);
        if (accelerometer != null) {
            this.mSensorManager = manager;
            this.mLastTimestamp = -1L;
            this.mCurrentIndex = 0;
            this.mMagnitudes = new double[40];
            this.mTimestamps = new long[40];
            this.mSensorManager.registerListener((SensorEventListener)this, accelerometer, 2);
            this.mNumShakes = 0;
            this.mLastShakeTimestamp = 0L;
        }
    }

    public void stop() {
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            this.mSensorManager = null;
        }
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.timestamp - this.mLastTimestamp < MIN_TIME_BETWEEN_SAMPLES_NS) {
            return;
        }
        Assertions.assertNotNull((Object)this.mTimestamps);
        Assertions.assertNotNull((Object)this.mMagnitudes);
        float ax = sensorEvent.values[0];
        float ay = sensorEvent.values[1];
        float az = sensorEvent.values[2];
        this.mLastTimestamp = sensorEvent.timestamp;
        this.mTimestamps[this.mCurrentIndex] = sensorEvent.timestamp;
        this.mMagnitudes[this.mCurrentIndex] = Math.sqrt(ax * ax + ay * ay + az * az);
        this.maybeDispatchShake(sensorEvent.timestamp);
        this.mCurrentIndex = (this.mCurrentIndex + 1) % 40;
    }

    public void onAccuracyChanged(Sensor sensor, int i) {
    }

    private void maybeDispatchShake(long currentTimestamp) {
        Assertions.assertNotNull((Object)this.mTimestamps);
        Assertions.assertNotNull((Object)this.mMagnitudes);
        int numOverThreshold = 0;
        int total = 0;
        for (int i = 0; i < 40; ++i) {
            int index = (this.mCurrentIndex - i + 40) % 40;
            if (currentTimestamp - this.mTimestamps[index] >= VISIBLE_TIME_RANGE_NS) continue;
            ++total;
            if (!(this.mMagnitudes[index] >= 25.0)) continue;
            ++numOverThreshold;
        }
        if ((double)numOverThreshold / (double)total > 0.6) {
            if (currentTimestamp - this.mLastShakeTimestamp >= VISIBLE_TIME_RANGE_NS) {
                ++this.mNumShakes;
            }
            this.mLastShakeTimestamp = currentTimestamp;
            if (this.mNumShakes >= this.mMinNumShakes) {
                this.mNumShakes = 0;
                this.mLastShakeTimestamp = 0L;
                this.mShakeListener.onShake();
            }
        }
        if ((float)(currentTimestamp - this.mLastShakeTimestamp) > SHAKING_WINDOW_NS) {
            this.mNumShakes = 0;
            this.mLastShakeTimestamp = 0L;
        }
    }

    public static interface ShakeListener {
        public void onShake();
    }
}

