/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Rect;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.flat.AttachDetachListener;
import com.facebook.react.flat.DrawBackgroundColor;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.DrawView;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.OnLayoutEvent;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.annotations.ReactProp;
import javax.annotation.Nullable;

class FlatShadowNode
extends LayoutShadowNode {
    static final FlatShadowNode[] EMPTY_ARRAY = new FlatShadowNode[0];
    private static final String PROP_OPACITY = "opacity";
    private static final String PROP_RENDER_TO_HARDWARE_TEXTURE = "renderToHardwareTextureAndroid";
    private static final String PROP_ACCESSIBILITY_LABEL = "accessibilityLabel";
    private static final String PROP_ACCESSIBILITY_COMPONENT_TYPE = "accessibilityComponentType";
    private static final String PROP_ACCESSIBILITY_LIVE_REGION = "accessibilityLiveRegion";
    private static final String PROP_IMPORTANT_FOR_ACCESSIBILITY = "importantForAccessibility";
    private static final String PROP_TEST_ID = "testID";
    private static final String PROP_TRANSFORM = "transform";
    protected static final String PROP_REMOVE_CLIPPED_SUBVIEWS = "removeClippedSubviews";
    protected static final String PROP_HORIZONTAL = "horizontal";
    private static final Rect LOGICAL_OFFSET_EMPTY = new Rect();
    private static final DrawView EMPTY_DRAW_VIEW = new DrawView(0);
    private DrawCommand[] mDrawCommands = DrawCommand.EMPTY_ARRAY;
    private AttachDetachListener[] mAttachDetachListeners = AttachDetachListener.EMPTY_ARRAY;
    private NodeRegion[] mNodeRegions = NodeRegion.EMPTY_ARRAY;
    private FlatShadowNode[] mNativeChildren = EMPTY_ARRAY;
    private NodeRegion mNodeRegion = NodeRegion.EMPTY;
    private int mNativeParentTag;
    private int mViewLeft;
    private int mViewTop;
    private int mViewRight;
    private int mViewBottom;
    private boolean mBackingViewIsCreated;
    @Nullable
    private DrawView mDrawView;
    @Nullable
    private DrawBackgroundColor mDrawBackground;
    private boolean mIsUpdated = true;
    private boolean mForceMountChildrenToView;
    private float mClipLeft;
    private float mClipTop;
    private float mClipRight;
    private float mClipBottom;
    private boolean mOverflowsContainer;
    private Rect mLogicalOffset = LOGICAL_OFFSET_EMPTY;
    private int mLayoutX;
    private int mLayoutY;
    private int mLayoutWidth;
    private int mLayoutHeight;
    float mClipRadius;
    boolean mClipToBounds = false;

    FlatShadowNode() {
    }

    void handleUpdateProperties(ReactStylesDiffMap styles) {
        if (!this.mountsToView() && (styles.hasKey(PROP_OPACITY) || styles.hasKey(PROP_RENDER_TO_HARDWARE_TEXTURE) || styles.hasKey(PROP_TEST_ID) || styles.hasKey(PROP_ACCESSIBILITY_LABEL) || styles.hasKey(PROP_ACCESSIBILITY_COMPONENT_TYPE) || styles.hasKey(PROP_ACCESSIBILITY_LIVE_REGION) || styles.hasKey(PROP_TRANSFORM) || styles.hasKey(PROP_IMPORTANT_FOR_ACCESSIBILITY) || styles.hasKey(PROP_REMOVE_CLIPPED_SUBVIEWS))) {
            this.forceMountToView();
        }
    }

    final void forceMountChildrenToView() {
        if (this.mForceMountChildrenToView) {
            return;
        }
        this.mForceMountChildrenToView = true;
        int childCount = this.getChildCount();
        for (int i = 0; i != childCount; ++i) {
            ReactShadowNode child = this.getChildAt(i);
            if (!(child instanceof FlatShadowNode)) continue;
            ((FlatShadowNode)child).forceMountToView();
        }
    }

    protected void collectState(StateBuilder stateBuilder, float left, float top, float right, float bottom, float clipLeft, float clipTop, float clipRight, float clipBottom) {
        if (this.mDrawBackground != null) {
            this.mDrawBackground = (DrawBackgroundColor)this.mDrawBackground.updateBoundsAndFreeze(left, top, right, bottom, clipLeft, clipTop, clipRight, clipBottom);
            stateBuilder.addDrawCommand(this.mDrawBackground);
        }
    }

    boolean doesDraw() {
        return this.mDrawView != null || this.mDrawBackground != null;
    }

    @ReactProp(name="backgroundColor")
    public void setBackgroundColor(int backgroundColor) {
        this.mDrawBackground = backgroundColor == 0 ? null : new DrawBackgroundColor(backgroundColor);
        this.invalidate();
    }

    @Override
    public void setOverflow(String overflow) {
        super.setOverflow(overflow);
        this.mClipToBounds = "hidden".equals(overflow);
        if (this.mClipToBounds) {
            this.mOverflowsContainer = false;
            if (this.mClipRadius > 0.5f) {
                this.forceMountToView();
            }
        } else {
            this.updateOverflowsContainer();
        }
        this.invalidate();
    }

    public final boolean clipToBounds() {
        return this.mClipToBounds;
    }

    @Override
    public final int getScreenX() {
        return this.mViewLeft;
    }

    @Override
    public final int getScreenY() {
        return this.mViewTop;
    }

    @Override
    public final int getScreenWidth() {
        if (this.mountsToView()) {
            return this.mViewRight - this.mViewLeft;
        }
        return Math.round(this.mNodeRegion.getRight() - this.mNodeRegion.getLeft());
    }

    @Override
    public final int getScreenHeight() {
        if (this.mountsToView()) {
            return this.mViewBottom - this.mViewTop;
        }
        return Math.round(this.mNodeRegion.getBottom() - this.mNodeRegion.getTop());
    }

    @Override
    public void addChildAt(ReactShadowNode child, int i) {
        super.addChildAt(child, i);
        if (this.mForceMountChildrenToView && child instanceof FlatShadowNode) {
            ((FlatShadowNode)child).forceMountToView();
        }
    }

    protected final void invalidate() {
        FlatShadowNode node = this;
        while (true) {
            ReactShadowNode parent;
            if (node.mountsToView()) {
                if (node.mIsUpdated) {
                    return;
                }
                node.mIsUpdated = true;
            }
            if ((parent = node.getParent()) == null) {
                return;
            }
            node = (FlatShadowNode)parent;
        }
    }

    @Override
    public void markUpdated() {
        super.markUpdated();
        this.mIsUpdated = true;
        this.invalidate();
    }

    final boolean isUpdated() {
        return this.mIsUpdated;
    }

    final void resetUpdated() {
        this.mIsUpdated = false;
    }

    final boolean clipBoundsChanged(float clipLeft, float clipTop, float clipRight, float clipBottom) {
        return this.mClipLeft != clipLeft || this.mClipTop != clipTop || this.mClipRight != clipRight || this.mClipBottom != clipBottom;
    }

    final void setClipBounds(float clipLeft, float clipTop, float clipRight, float clipBottom) {
        this.mClipLeft = clipLeft;
        this.mClipTop = clipTop;
        this.mClipRight = clipRight;
        this.mClipBottom = clipBottom;
    }

    final DrawCommand[] getDrawCommands() {
        return this.mDrawCommands;
    }

    final void setDrawCommands(DrawCommand[] drawCommands) {
        this.mDrawCommands = drawCommands;
    }

    final void setAttachDetachListeners(AttachDetachListener[] listeners) {
        this.mAttachDetachListeners = listeners;
    }

    final AttachDetachListener[] getAttachDetachListeners() {
        return this.mAttachDetachListeners;
    }

    final FlatShadowNode[] getNativeChildren() {
        return this.mNativeChildren;
    }

    final void setNativeChildren(FlatShadowNode[] nativeChildren) {
        this.mNativeChildren = nativeChildren;
    }

    final int getNativeParentTag() {
        return this.mNativeParentTag;
    }

    final void setNativeParentTag(int nativeParentTag) {
        this.mNativeParentTag = nativeParentTag;
    }

    final NodeRegion[] getNodeRegions() {
        return this.mNodeRegions;
    }

    final void setNodeRegions(NodeRegion[] nodeRegion) {
        this.mNodeRegions = nodeRegion;
        this.updateOverflowsContainer();
    }

    final void updateOverflowsContainer() {
        boolean overflowsContainer = false;
        int width = (int)(this.mNodeRegion.getRight() - this.mNodeRegion.getLeft());
        int height = (int)(this.mNodeRegion.getBottom() - this.mNodeRegion.getTop());
        float leftBound = 0.0f;
        float rightBound = width;
        float topBound = 0.0f;
        float bottomBound = height;
        Rect logicalOffset = null;
        if (!this.mClipToBounds && height > 0 && width > 0) {
            for (NodeRegion region : this.mNodeRegions) {
                if (region.getLeft() < leftBound) {
                    leftBound = region.getLeft();
                    overflowsContainer = true;
                }
                if (region.getRight() > rightBound) {
                    rightBound = region.getRight();
                    overflowsContainer = true;
                }
                if (region.getTop() < topBound) {
                    topBound = region.getTop();
                    overflowsContainer = true;
                }
                if (!(region.getBottom() > bottomBound)) continue;
                bottomBound = region.getBottom();
                overflowsContainer = true;
            }
            if (overflowsContainer) {
                logicalOffset = new Rect((int)leftBound, (int)topBound, (int)(rightBound - (float)width), (int)(bottomBound - (float)height));
            }
        }
        if (!overflowsContainer && this.mNodeRegion != NodeRegion.EMPTY) {
            int children = this.getChildCount();
            for (int i = 0; i < children; ++i) {
                ReactShadowNode node = this.getChildAt(i);
                if (!(node instanceof FlatShadowNode) || !((FlatShadowNode)node).mOverflowsContainer) continue;
                Rect childLogicalOffset = ((FlatShadowNode)node).mLogicalOffset;
                if (logicalOffset == null) {
                    logicalOffset = new Rect();
                }
                logicalOffset.union(childLogicalOffset);
                overflowsContainer = true;
            }
        }
        if (this.mOverflowsContainer != overflowsContainer) {
            this.mOverflowsContainer = overflowsContainer;
            this.mLogicalOffset = logicalOffset == null ? LOGICAL_OFFSET_EMPTY : logicalOffset;
        }
    }

    void updateNodeRegion(float left, float top, float right, float bottom, boolean isVirtual) {
        if (!this.mNodeRegion.matches(left, top, right, bottom, isVirtual)) {
            this.setNodeRegion(new NodeRegion(left, top, right, bottom, this.getReactTag(), isVirtual));
        }
    }

    protected final void setNodeRegion(NodeRegion nodeRegion) {
        this.mNodeRegion = nodeRegion;
        this.updateOverflowsContainer();
    }

    final NodeRegion getNodeRegion() {
        return this.mNodeRegion;
    }

    final void setViewBounds(int left, int top, int right, int bottom) {
        this.mViewLeft = left;
        this.mViewTop = top;
        this.mViewRight = right;
        this.mViewBottom = bottom;
    }

    final int getViewLeft() {
        return this.mViewLeft;
    }

    final int getViewTop() {
        return this.mViewTop;
    }

    final int getViewRight() {
        return this.mViewRight;
    }

    final int getViewBottom() {
        return this.mViewBottom;
    }

    final void forceMountToView() {
        if (this.isVirtual()) {
            return;
        }
        if (this.mDrawView == null) {
            this.mDrawView = EMPTY_DRAW_VIEW;
            this.invalidate();
            this.mNodeRegion = NodeRegion.EMPTY;
        }
    }

    final DrawView collectDrawView(float left, float top, float right, float bottom, float clipLeft, float clipTop, float clipRight, float clipBottom) {
        Assertions.assumeNotNull((Object)this.mDrawView);
        if (this.mDrawView == EMPTY_DRAW_VIEW) {
            this.mDrawView = new DrawView(this.getReactTag());
        }
        float clipRadius = this.mClipToBounds ? this.mClipRadius : 0.0f;
        this.mDrawView = this.mDrawView.collectDrawView(left, top, right, bottom, left + (float)this.mLogicalOffset.left, top + (float)this.mLogicalOffset.top, right + (float)this.mLogicalOffset.right, bottom + (float)this.mLogicalOffset.bottom, clipLeft, clipTop, clipRight, clipBottom, clipRadius);
        return this.mDrawView;
    }

    @Nullable
    final OnLayoutEvent obtainLayoutEvent(int x, int y, int width, int height) {
        if (this.mLayoutX == x && this.mLayoutY == y && this.mLayoutWidth == width && this.mLayoutHeight == height) {
            return null;
        }
        this.mLayoutX = x;
        this.mLayoutY = y;
        this.mLayoutWidth = width;
        this.mLayoutHeight = height;
        return OnLayoutEvent.obtain(this.getReactTag(), x, y, width, height);
    }

    final boolean mountsToView() {
        return this.mDrawView != null;
    }

    final boolean isBackingViewCreated() {
        return this.mBackingViewIsCreated;
    }

    final void signalBackingViewIsCreated() {
        this.mBackingViewIsCreated = true;
    }

    public boolean clipsSubviews() {
        return false;
    }

    public boolean isHorizontal() {
        return false;
    }
}

