/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.flat.AttachDetachListener;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.FlatNativeViewHierarchyManager;
import com.facebook.react.flat.FlatViewGroup;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NoSuchNativeViewException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.UIViewOperationQueue;
import java.util.ArrayList;
import javax.annotation.Nullable;

final class FlatUIViewOperationQueue
extends UIViewOperationQueue {
    private static final int[] MEASURE_BUFFER = new int[4];
    private final FlatNativeViewHierarchyManager mNativeViewHierarchyManager;
    private final ProcessLayoutRequests mProcessLayoutRequests = new ProcessLayoutRequests();

    public FlatUIViewOperationQueue(ReactApplicationContext reactContext, FlatNativeViewHierarchyManager nativeViewHierarchyManager) {
        super(reactContext, nativeViewHierarchyManager);
        this.mNativeViewHierarchyManager = nativeViewHierarchyManager;
    }

    public void enqueueUpdateMountState(int reactTag, @Nullable DrawCommand[] drawCommands, @Nullable AttachDetachListener[] listeners, @Nullable NodeRegion[] nodeRegions) {
        this.enqueueUIOperation(new UpdateMountState(reactTag, drawCommands, listeners, nodeRegions));
    }

    public void enqueueUpdateClippingMountState(int reactTag, @Nullable DrawCommand[] drawCommands, SparseIntArray drawViewIndexMap, float[] commandMaxBot, float[] commandMinTop, @Nullable AttachDetachListener[] listeners, @Nullable NodeRegion[] nodeRegions, float[] regionMaxBot, float[] regionMinTop, boolean willMountViews) {
        this.enqueueUIOperation(new UpdateClippingMountState(reactTag, drawCommands, drawViewIndexMap, commandMaxBot, commandMinTop, listeners, nodeRegions, regionMaxBot, regionMinTop, willMountViews));
    }

    public void enqueueUpdateViewGroup(int reactTag, int[] viewsToAdd, int[] viewsToDetach) {
        this.enqueueUIOperation(new UpdateViewGroup(reactTag, viewsToAdd, viewsToDetach));
    }

    public UpdateViewBounds createUpdateViewBounds(int reactTag, int left, int top, int right, int bottom) {
        return new UpdateViewBounds(reactTag, left, top, right, bottom);
    }

    public ViewManagerCommand createViewManagerCommand(int reactTag, int command, @Nullable ReadableArray args) {
        return new ViewManagerCommand(reactTag, command, args);
    }

    void enqueueFlatUIOperation(UIViewOperationQueue.UIOperation operation) {
        this.enqueueUIOperation(operation);
    }

    public void enqueueSetPadding(int reactTag, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.enqueueUIOperation(new SetPadding(reactTag, paddingLeft, paddingTop, paddingRight, paddingBottom));
    }

    public void enqueueDropViews(ArrayList<Integer> viewsToDrop, ArrayList<Integer> parentsOfViewsToDrop) {
        this.enqueueUIOperation(new DropViews(viewsToDrop, parentsOfViewsToDrop));
    }

    public void enqueueMeasureVirtualView(int reactTag, float scaledX, float scaledY, float scaledWidth, float scaledHeight, boolean relativeToWindow, Callback callback) {
        this.enqueueUIOperation(new MeasureVirtualView(reactTag, scaledX, scaledY, scaledWidth, scaledHeight, relativeToWindow, callback));
    }

    public void enqueueProcessLayoutRequests() {
        this.enqueueUIOperation(this.mProcessLayoutRequests);
    }

    public DetachAllChildrenFromViews enqueueDetachAllChildrenFromViews() {
        DetachAllChildrenFromViews op = new DetachAllChildrenFromViews();
        this.enqueueUIOperation(op);
        return op;
    }

    @Override
    public void enqueueFindTargetForTouch(int reactTag, float targetX, float targetY, Callback callback) {
        this.enqueueUIOperation(new FindTargetForTouchOperation(reactTag, targetX, targetY, callback));
    }

    public final class ViewManagerCommand
    implements UIViewOperationQueue.UIOperation {
        private final int mReactTag;
        private final int mCommand;
        @Nullable
        private final ReadableArray mArgs;

        public ViewManagerCommand(int reactTag, @Nullable int command, ReadableArray args) {
            this.mReactTag = reactTag;
            this.mCommand = command;
            this.mArgs = args;
        }

        @Override
        public void execute() {
            FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.dispatchCommand(this.mReactTag, this.mCommand, this.mArgs);
        }
    }

    private final class FindTargetForTouchOperation
    implements UIViewOperationQueue.UIOperation {
        private final int mReactTag;
        private final float mTargetX;
        private final float mTargetY;
        private final Callback mCallback;
        private final int[] NATIVE_VIEW_BUFFER = new int[1];

        private FindTargetForTouchOperation(int reactTag, float targetX, float targetY, Callback callback) {
            this.mReactTag = reactTag;
            this.mTargetX = targetX;
            this.mTargetY = targetY;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            boolean isNativeView;
            try {
                FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, MEASURE_BUFFER);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float containerX = MEASURE_BUFFER[0];
            float containerY = MEASURE_BUFFER[1];
            View view = FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.getView(this.mReactTag);
            int touchTargetReactTag = TouchTargetHelper.findTargetTagForTouch(this.mTargetX, this.mTargetY, (ViewGroup)view, this.NATIVE_VIEW_BUFFER);
            try {
                FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.NATIVE_VIEW_BUFFER[0], MEASURE_BUFFER);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            NodeRegion region = NodeRegion.EMPTY;
            boolean bl = isNativeView = this.NATIVE_VIEW_BUFFER[0] == touchTargetReactTag;
            if (!isNativeView && (view = FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.getView(this.NATIVE_VIEW_BUFFER[0])) instanceof FlatViewGroup) {
                region = ((FlatViewGroup)view).getNodeRegionForTag(this.mReactTag);
            }
            int resultTag = region == NodeRegion.EMPTY ? touchTargetReactTag : region.mTag;
            float x = PixelUtil.toDIPFromPixel(region.getLeft() + (float)MEASURE_BUFFER[0] - containerX);
            float y = PixelUtil.toDIPFromPixel(region.getTop() + (float)MEASURE_BUFFER[1] - containerY);
            float width = PixelUtil.toDIPFromPixel(isNativeView ? (float)MEASURE_BUFFER[2] : region.getRight() - region.getLeft());
            float height = PixelUtil.toDIPFromPixel(isNativeView ? (float)MEASURE_BUFFER[3] : region.getBottom() - region.getTop());
            this.mCallback.invoke(resultTag, Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
    }

    public final class DetachAllChildrenFromViews
    implements UIViewOperationQueue.UIOperation {
        @Nullable
        private int[] mViewsToDetachAllChildrenFrom;

        public void setViewsToDetachAllChildrenFrom(int[] viewsToDetachAllChildrenFrom) {
            this.mViewsToDetachAllChildrenFrom = viewsToDetachAllChildrenFrom;
        }

        @Override
        public void execute() {
            FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.detachAllChildrenFromViews(this.mViewsToDetachAllChildrenFrom);
        }
    }

    private final class MeasureVirtualView
    implements UIViewOperationQueue.UIOperation {
        private final int mReactTag;
        private final float mScaledX;
        private final float mScaledY;
        private final float mScaledWidth;
        private final float mScaledHeight;
        private final Callback mCallback;
        private final boolean mRelativeToWindow;

        private MeasureVirtualView(int reactTag, float scaledX, float scaledY, float scaledWidth, float scaledHeight, boolean relativeToWindow, Callback callback) {
            this.mReactTag = reactTag;
            this.mScaledX = scaledX;
            this.mScaledY = scaledY;
            this.mScaledWidth = scaledWidth;
            this.mScaledHeight = scaledHeight;
            this.mCallback = callback;
            this.mRelativeToWindow = relativeToWindow;
        }

        @Override
        public void execute() {
            try {
                if (this.mRelativeToWindow) {
                    FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.measureInWindow(this.mReactTag, MEASURE_BUFFER);
                } else {
                    FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, MEASURE_BUFFER);
                }
            }
            catch (NoSuchNativeViewException noSuchNativeViewException) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float nativeViewX = MEASURE_BUFFER[0];
            float nativeViewY = MEASURE_BUFFER[1];
            float nativeViewWidth = MEASURE_BUFFER[2];
            float nativeViewHeight = MEASURE_BUFFER[3];
            float x = PixelUtil.toDIPFromPixel(this.mScaledX * nativeViewWidth + nativeViewX);
            float y = PixelUtil.toDIPFromPixel(this.mScaledY * nativeViewHeight + nativeViewY);
            float width = PixelUtil.toDIPFromPixel(this.mScaledWidth * nativeViewWidth);
            float height = PixelUtil.toDIPFromPixel(this.mScaledHeight * nativeViewHeight);
            if (this.mRelativeToWindow) {
                this.mCallback.invoke(Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
            } else {
                this.mCallback.invoke(0, 0, Float.valueOf(width), Float.valueOf(height), Float.valueOf(x), Float.valueOf(y));
            }
        }
    }

    private final class DropViews
    implements UIViewOperationQueue.UIOperation {
        private final SparseIntArray mViewsToDrop;

        private DropViews(ArrayList<Integer> viewsToDrop, ArrayList<Integer> parentsForViewsToDrop) {
            SparseIntArray sparseIntArray = new SparseIntArray();
            int count = viewsToDrop.size();
            for (int i = 0; i < count; ++i) {
                sparseIntArray.put(viewsToDrop.get(i).intValue(), parentsForViewsToDrop.get(i).intValue());
            }
            this.mViewsToDrop = sparseIntArray;
        }

        @Override
        public void execute() {
            FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.dropViews(this.mViewsToDrop);
        }
    }

    private final class SetPadding
    implements UIViewOperationQueue.UIOperation {
        private final int mReactTag;
        private final int mPaddingLeft;
        private final int mPaddingTop;
        private final int mPaddingRight;
        private final int mPaddingBottom;

        private SetPadding(int reactTag, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
            this.mReactTag = reactTag;
            this.mPaddingLeft = paddingLeft;
            this.mPaddingTop = paddingTop;
            this.mPaddingRight = paddingRight;
            this.mPaddingBottom = paddingBottom;
        }

        @Override
        public void execute() {
            FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.setPadding(this.mReactTag, this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
        }
    }

    public final class UpdateViewBounds
    implements UIViewOperationQueue.UIOperation {
        private final int mReactTag;
        private final int mLeft;
        private final int mTop;
        private final int mRight;
        private final int mBottom;

        private UpdateViewBounds(int reactTag, int left, int top, int right, int bottom) {
            this.mReactTag = reactTag;
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
        }

        @Override
        public void execute() {
            FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.updateViewBounds(this.mReactTag, this.mLeft, this.mTop, this.mRight, this.mBottom);
        }
    }

    private final class UpdateViewGroup
    implements UIViewOperationQueue.UIOperation {
        private final int mReactTag;
        private final int[] mViewsToAdd;
        private final int[] mViewsToDetach;

        private UpdateViewGroup(int reactTag, int[] viewsToAdd, int[] viewsToDetach) {
            this.mReactTag = reactTag;
            this.mViewsToAdd = viewsToAdd;
            this.mViewsToDetach = viewsToDetach;
        }

        @Override
        public void execute() {
            FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.updateViewGroup(this.mReactTag, this.mViewsToAdd, this.mViewsToDetach);
        }
    }

    private final class UpdateClippingMountState
    implements UIViewOperationQueue.UIOperation {
        private final int mReactTag;
        @Nullable
        private final DrawCommand[] mDrawCommands;
        private final SparseIntArray mDrawViewIndexMap;
        private final float[] mCommandMaxBot;
        private final float[] mCommandMinTop;
        @Nullable
        private final AttachDetachListener[] mAttachDetachListeners;
        @Nullable
        private final NodeRegion[] mNodeRegions;
        private final float[] mRegionMaxBot;
        private final float[] mRegionMinTop;
        private final boolean mWillMountViews;

        private UpdateClippingMountState(@Nullable int reactTag, DrawCommand[] drawCommands, SparseIntArray drawViewIndexMap, float[] commandMaxBot, @Nullable float[] commandMinTop, @Nullable AttachDetachListener[] listeners, NodeRegion[] nodeRegions, float[] regionMaxBot, float[] regionMinTop, boolean willMountViews) {
            this.mReactTag = reactTag;
            this.mDrawCommands = drawCommands;
            this.mDrawViewIndexMap = drawViewIndexMap;
            this.mCommandMaxBot = commandMaxBot;
            this.mCommandMinTop = commandMinTop;
            this.mAttachDetachListeners = listeners;
            this.mNodeRegions = nodeRegions;
            this.mRegionMaxBot = regionMaxBot;
            this.mRegionMinTop = regionMinTop;
            this.mWillMountViews = willMountViews;
        }

        @Override
        public void execute() {
            FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.updateClippingMountState(this.mReactTag, this.mDrawCommands, this.mDrawViewIndexMap, this.mCommandMaxBot, this.mCommandMinTop, this.mAttachDetachListeners, this.mNodeRegions, this.mRegionMaxBot, this.mRegionMinTop, this.mWillMountViews);
        }
    }

    private final class UpdateMountState
    implements UIViewOperationQueue.UIOperation {
        private final int mReactTag;
        @Nullable
        private final DrawCommand[] mDrawCommands;
        @Nullable
        private final AttachDetachListener[] mAttachDetachListeners;
        @Nullable
        private final NodeRegion[] mNodeRegions;

        private UpdateMountState(@Nullable int reactTag, @Nullable DrawCommand[] drawCommands, @Nullable AttachDetachListener[] listeners, NodeRegion[] nodeRegions) {
            this.mReactTag = reactTag;
            this.mDrawCommands = drawCommands;
            this.mAttachDetachListeners = listeners;
            this.mNodeRegions = nodeRegions;
        }

        @Override
        public void execute() {
            FlatUIViewOperationQueue.this.mNativeViewHierarchyManager.updateMountState(this.mReactTag, this.mDrawCommands, this.mAttachDetachListeners, this.mNodeRegions);
        }
    }

    private final class ProcessLayoutRequests
    implements UIViewOperationQueue.UIOperation {
        private ProcessLayoutRequests() {
        }

        @Override
        public void execute() {
            FlatViewGroup.processLayoutRequests();
        }
    }
}

