/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.systeminfo;

import android.os.Build;
import java.util.Locale;

public class AndroidInfoHelpers {
    public static final String EMULATOR_LOCALHOST = "10.0.2.2";
    public static final String GENYMOTION_LOCALHOST = "10.0.3.2";
    public static final String DEVICE_LOCALHOST = "localhost";
    private static final int DEBUG_SERVER_HOST_PORT = 8081;
    private static final int INSPECTOR_PROXY_PORT = 8081;

    private static boolean isRunningOnGenymotion() {
        return Build.FINGERPRINT.contains("vbox");
    }

    private static boolean isRunningOnStockEmulator() {
        return Build.FINGERPRINT.contains("generic");
    }

    public static String getServerHost() {
        return AndroidInfoHelpers.getServerIpAddress(8081);
    }

    public static String getInspectorProxyHost() {
        return AndroidInfoHelpers.getServerIpAddress(8081);
    }

    public static String getFriendlyDeviceName() {
        if (AndroidInfoHelpers.isRunningOnGenymotion()) {
            return Build.MODEL;
        }
        return Build.MODEL + " - " + Build.VERSION.RELEASE + " - API " + Build.VERSION.SDK_INT;
    }

    private static String getServerIpAddress(int port) {
        String ipAddress = AndroidInfoHelpers.isRunningOnGenymotion() ? GENYMOTION_LOCALHOST : (AndroidInfoHelpers.isRunningOnStockEmulator() ? EMULATOR_LOCALHOST : DEVICE_LOCALHOST);
        return String.format(Locale.US, "%s:%d", ipAddress, port);
    }
}

