/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.websocket;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

@ReactModule(name="WebSocketModule", hasConstants=false)
public class WebSocketModule
extends ReactContextBaseJavaModule {
    private final Map<Integer, WebSocket> mWebSocketConnections = new HashMap<Integer, WebSocket>();
    private ReactContext mReactContext;
    private ForwardingCookieHandler mCookieHandler;

    public WebSocketModule(ReactApplicationContext context) {
        super(context);
        this.mReactContext = context;
        this.mCookieHandler = new ForwardingCookieHandler(context);
    }

    private void sendEvent(String eventName, WritableMap params) {
        this.mReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(eventName, params);
    }

    @Override
    public String getName() {
        return "WebSocketModule";
    }

    @ReactMethod
    public void connect(String url, @Nullable ReadableArray protocols, @Nullable ReadableMap headers, final int id) {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        Request.Builder builder = new Request.Builder().tag((Object)id).url(url);
        String cookie = this.getCookie(url);
        if (cookie != null) {
            builder.addHeader("Cookie", cookie);
        }
        if (headers != null) {
            ReadableMapKeySetIterator iterator = headers.keySetIterator();
            if (!headers.hasKey("origin")) {
                builder.addHeader("origin", WebSocketModule.getDefaultOrigin(url));
            }
            while (iterator.hasNextKey()) {
                String key = iterator.nextKey();
                if (ReadableType.String.equals((Object)headers.getType(key))) {
                    builder.addHeader(key, headers.getString(key));
                    continue;
                }
                FLog.w((String)"ReactNative", (String)("Ignoring: requested " + key + ", value not a string"));
            }
        } else {
            builder.addHeader("origin", WebSocketModule.getDefaultOrigin(url));
        }
        if (protocols != null && protocols.size() > 0) {
            StringBuilder protocolsValue = new StringBuilder("");
            for (int i = 0; i < protocols.size(); ++i) {
                String v = protocols.getString(i).trim();
                if (v.isEmpty() || v.contains(",")) continue;
                protocolsValue.append(v);
                protocolsValue.append(",");
            }
            if (protocolsValue.length() > 0) {
                protocolsValue.replace(protocolsValue.length() - 1, protocolsValue.length(), "");
                builder.addHeader("Sec-WebSocket-Protocol", protocolsValue.toString());
            }
        }
        client.newWebSocket(builder.build(), new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                WebSocketModule.this.mWebSocketConnections.put(id, webSocket);
                WritableMap params = Arguments.createMap();
                params.putInt("id", id);
                WebSocketModule.this.sendEvent("websocketOpen", params);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id);
                params.putInt("code", code);
                params.putString("reason", reason);
                WebSocketModule.this.sendEvent("websocketClosed", params);
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                WebSocketModule.this.notifyWebSocketFailed(id, t.getMessage());
            }

            public void onMessage(WebSocket webSocket, String text) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id);
                params.putString("data", text);
                params.putString("type", "text");
                WebSocketModule.this.sendEvent("websocketMessage", params);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                String text = bytes.base64();
                WritableMap params = Arguments.createMap();
                params.putInt("id", id);
                params.putString("data", text);
                params.putString("type", "binary");
                WebSocketModule.this.sendEvent("websocketMessage", params);
            }
        });
        client.dispatcher().executorService().shutdown();
    }

    @ReactMethod
    public void close(int code, String reason, int id) {
        WebSocket client = this.mWebSocketConnections.get(id);
        if (client == null) {
            return;
        }
        try {
            client.close(code, reason);
            this.mWebSocketConnections.remove(id);
        }
        catch (Exception e) {
            FLog.e((String)"ReactNative", (String)("Could not close WebSocket connection for id " + id), (Throwable)e);
        }
    }

    @ReactMethod
    public void send(String message, int id) {
        WebSocket client = this.mWebSocketConnections.get(id);
        if (client == null) {
            throw new RuntimeException("Cannot send a message. Unknown WebSocket id " + id);
        }
        try {
            client.send(message);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id, e.getMessage());
        }
    }

    @ReactMethod
    public void sendBinary(String base64String, int id) {
        WebSocket client = this.mWebSocketConnections.get(id);
        if (client == null) {
            throw new RuntimeException("Cannot send a message. Unknown WebSocket id " + id);
        }
        try {
            client.send(ByteString.decodeBase64((String)base64String));
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id, e.getMessage());
        }
    }

    @ReactMethod
    public void ping(int id) {
        WebSocket client = this.mWebSocketConnections.get(id);
        if (client == null) {
            throw new RuntimeException("Cannot send a message. Unknown WebSocket id " + id);
        }
        try {
            client.send(ByteString.EMPTY);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id, e.getMessage());
        }
    }

    private void notifyWebSocketFailed(int id, String message) {
        WritableMap params = Arguments.createMap();
        params.putInt("id", id);
        params.putString("message", message);
        this.sendEvent("websocketFailed", params);
    }

    private static String getDefaultOrigin(String uri) {
        try {
            String scheme = "";
            URI requestURI = new URI(uri);
            if (requestURI.getScheme().equals("wss")) {
                scheme = scheme + "https";
            } else if (requestURI.getScheme().equals("ws")) {
                scheme = scheme + "http";
            } else if (requestURI.getScheme().equals("http") || requestURI.getScheme().equals("https")) {
                scheme = scheme + requestURI.getScheme();
            }
            String defaultOrigin = requestURI.getPort() != -1 ? String.format("%s://%s:%s", scheme, requestURI.getHost(), requestURI.getPort()) : String.format("%s://%s/", scheme, requestURI.getHost());
            return defaultOrigin;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to set " + uri + " as default origin header");
        }
    }

    private String getCookie(String uri) {
        try {
            URI origin = new URI(WebSocketModule.getDefaultOrigin(uri));
            Map<String, List<String>> cookieMap = this.mCookieHandler.get(origin, new HashMap<String, List<String>>());
            List<String> cookieList = cookieMap.get("Cookie");
            if (cookieList == null || cookieList.isEmpty()) {
                return null;
            }
            return cookieList.get(0);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException("Unable to get cookie from " + uri);
        }
    }
}

