/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import com.facebook.react.animation.Animation;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.PerformanceCounter;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModuleConstantsHelper;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.YogaNodePool;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="UIManager")
public class UIManagerModule
extends ReactContextBaseJavaModule
implements OnBatchCompleteListener,
LifecycleEventListener,
PerformanceCounter {
    protected static final String NAME = "UIManager";
    private static final int ROOT_VIEW_TAG_INCREMENT = 10;
    private static final boolean DEBUG = false;
    private final EventDispatcher mEventDispatcher;
    private final Map<String, Object> mModuleConstants;
    private final UIImplementation mUIImplementation;
    private final MemoryTrimCallback mMemoryTrimCallback = new MemoryTrimCallback();
    private int mNextRootViewTag = 1;
    private int mBatchId = 0;

    public UIManagerModule(ReactApplicationContext reactContext, List<ViewManager> viewManagerList, UIImplementationProvider uiImplementationProvider, boolean lazyViewManagersEnabled) {
        super(reactContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.mEventDispatcher = new EventDispatcher(reactContext);
        this.mModuleConstants = UIManagerModule.createConstants(viewManagerList, lazyViewManagersEnabled);
        this.mUIImplementation = uiImplementationProvider.createUIImplementation(reactContext, viewManagerList, this.mEventDispatcher);
        reactContext.addLifecycleEventListener(this);
    }

    public UIImplementation getUIImplementation() {
        return this.mUIImplementation;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getConstants() {
        return this.mModuleConstants;
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().registerComponentCallbacks((ComponentCallbacks)this.mMemoryTrimCallback);
    }

    @Override
    public void onHostResume() {
        this.mUIImplementation.onHostResume();
    }

    @Override
    public void onHostPause() {
        this.mUIImplementation.onHostPause();
    }

    @Override
    public void onHostDestroy() {
        this.mUIImplementation.onHostDestroy();
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.mEventDispatcher.onCatalystInstanceDestroyed();
        this.getReactApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this.mMemoryTrimCallback);
        YogaNodePool.get().clear();
        ViewManagerPropertyUpdater.clear();
    }

    private static Map<String, Object> createConstants(List<ViewManager> viewManagerList, boolean lazyViewManagersEnabled) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_START);
        Systrace.beginSection(0L, "CreateUIManagerConstants");
        try {
            Map<String, Object> map = UIManagerModuleConstantsHelper.createConstants(viewManagerList, lazyViewManagersEnabled);
            return map;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_CONSTANTS_END);
        }
    }

    @Override
    public Map<String, Double> getPerformanceCounters() {
        HashMap<String, Double> perfMap = new HashMap<String, Double>();
        perfMap.put("LayoutCount", this.mUIImplementation.getLayoutCount());
        perfMap.put("LayoutTimer", this.mUIImplementation.getLayoutTimer());
        return perfMap;
    }

    public int addRootView(SizeMonitoringFrameLayout rootView) {
        int height;
        int width;
        Systrace.beginSection(0L, "UIManagerModule.addRootView");
        final int tag = this.mNextRootViewTag;
        this.mNextRootViewTag += 10;
        if (rootView.getLayoutParams() != null && rootView.getLayoutParams().width > 0 && rootView.getLayoutParams().height > 0) {
            width = rootView.getLayoutParams().width;
            height = rootView.getLayoutParams().height;
        } else {
            width = rootView.getWidth();
            height = rootView.getHeight();
        }
        final ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        ThemedReactContext themedRootContext = new ThemedReactContext(reactApplicationContext, rootView.getContext());
        this.mUIImplementation.registerRootView(rootView, tag, width, height, themedRootContext);
        rootView.setOnSizeChangedListener(new SizeMonitoringFrameLayout.OnSizeChangedListener(){

            @Override
            public void onSizeChanged(final int width, final int height, int oldW, int oldH) {
                reactApplicationContext.runUIBackgroundRunnable(new GuardedRunnable(reactApplicationContext){

                    @Override
                    public void runGuarded() {
                        UIManagerModule.this.updateNodeSize(tag, width, height);
                    }
                });
            }
        });
        Systrace.endSection(0L);
        return tag;
    }

    @ReactMethod
    public void removeRootView(int rootViewTag) {
        this.mUIImplementation.removeRootView(rootViewTag);
    }

    public void updateNodeSize(int nodeViewTag, int newWidth, int newHeight) {
        this.getReactApplicationContext().assertOnUIBackgroundOrNativeModulesThread();
        this.mUIImplementation.updateNodeSize(nodeViewTag, newWidth, newHeight);
    }

    @ReactMethod
    public void createView(int tag, String className, int rootViewTag, ReadableMap props) {
        this.mUIImplementation.createView(tag, className, rootViewTag, props);
    }

    @ReactMethod
    public void updateView(int tag, String className, ReadableMap props) {
        this.mUIImplementation.updateView(tag, className, props);
    }

    @ReactMethod
    public void manageChildren(int viewTag, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices, @Nullable ReadableArray removeFrom) {
        this.mUIImplementation.manageChildren(viewTag, moveFrom, moveTo, addChildTags, addAtIndices, removeFrom);
    }

    @ReactMethod
    public void setChildren(int viewTag, ReadableArray childrenTags) {
        this.mUIImplementation.setChildren(viewTag, childrenTags);
    }

    @ReactMethod
    public void replaceExistingNonRootView(int oldTag, int newTag) {
        this.mUIImplementation.replaceExistingNonRootView(oldTag, newTag);
    }

    @ReactMethod
    public void removeSubviewsFromContainerWithID(int containerTag) {
        this.mUIImplementation.removeSubviewsFromContainerWithID(containerTag);
    }

    @ReactMethod
    public void measure(int reactTag, Callback callback) {
        this.mUIImplementation.measure(reactTag, callback);
    }

    @ReactMethod
    public void measureInWindow(int reactTag, Callback callback) {
        this.mUIImplementation.measureInWindow(reactTag, callback);
    }

    @ReactMethod
    public void measureLayout(int tag, int ancestorTag, Callback errorCallback, Callback successCallback) {
        this.mUIImplementation.measureLayout(tag, ancestorTag, errorCallback, successCallback);
    }

    @ReactMethod
    public void measureLayoutRelativeToParent(int tag, Callback errorCallback, Callback successCallback) {
        this.mUIImplementation.measureLayoutRelativeToParent(tag, errorCallback, successCallback);
    }

    @ReactMethod
    public void findSubviewIn(int reactTag, ReadableArray point, Callback callback) {
        this.mUIImplementation.findSubviewIn(reactTag, Math.round(PixelUtil.toPixelFromDIP(point.getDouble(0))), Math.round(PixelUtil.toPixelFromDIP(point.getDouble(1))), callback);
    }

    @ReactMethod
    public void viewIsDescendantOf(int reactTag, int ancestorReactTag, Callback callback) {
        this.mUIImplementation.viewIsDescendantOf(reactTag, ancestorReactTag, callback);
    }

    public void registerAnimation(Animation animation) {
        this.mUIImplementation.registerAnimation(animation);
    }

    public void addAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.mUIImplementation.addAnimation(reactTag, animationID, onSuccess);
    }

    public void removeAnimation(int reactTag, int animationID) {
        this.mUIImplementation.removeAnimation(reactTag, animationID);
    }

    @ReactMethod
    public void setJSResponder(int reactTag, boolean blockNativeResponder) {
        this.mUIImplementation.setJSResponder(reactTag, blockNativeResponder);
    }

    @ReactMethod
    public void clearJSResponder() {
        this.mUIImplementation.clearJSResponder();
    }

    @ReactMethod
    public void dispatchViewManagerCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        this.mUIImplementation.dispatchViewManagerCommand(reactTag, commandId, commandArgs);
    }

    @ReactMethod
    public void showPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.mUIImplementation.showPopupMenu(reactTag, items, error, success);
    }

    @ReactMethod
    public void setLayoutAnimationEnabledExperimental(boolean enabled) {
        this.mUIImplementation.setLayoutAnimationEnabledExperimental(enabled);
    }

    @ReactMethod
    public void configureNextLayoutAnimation(ReadableMap config, Callback success, Callback error) {
        this.mUIImplementation.configureNextLayoutAnimation(config, success, error);
    }

    @Override
    public void onBatchComplete() {
        int batchId = this.mBatchId++;
        SystraceMessage.beginSection(0L, "onBatchCompleteUI").arg("BatchId", batchId).flush();
        try {
            this.mUIImplementation.dispatchViewUpdates(batchId);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mUIImplementation.setViewHierarchyUpdateDebugListener(listener);
    }

    public EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    @ReactMethod
    public void sendAccessibilityEvent(int tag, int eventType) {
        this.mUIImplementation.sendAccessibilityEvent(tag, eventType);
    }

    public void addUIBlock(UIBlock block) {
        this.mUIImplementation.addUIBlock(block);
    }

    public int resolveRootTagFromReactTag(int reactTag) {
        return this.mUIImplementation.resolveRootTagFromReactTag(reactTag);
    }

    private class MemoryTrimCallback
    implements ComponentCallbacks2 {
        private MemoryTrimCallback() {
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                YogaNodePool.get().clear();
            }
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }
    }
}

