/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.Spacing;
import com.facebook.react.views.view.ColorUtil;
import com.facebook.yoga.YogaConstants;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;

public class ReactViewBackgroundDrawable
extends Drawable {
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final int DEFAULT_BORDER_RGB = 0;
    private static final int DEFAULT_BORDER_ALPHA = 255;
    private static final int ALL_BITS_SET = -1;
    private static final int ALL_BITS_UNSET = 0;
    @Nullable
    private Spacing mBorderWidth;
    @Nullable
    private Spacing mBorderRGB;
    @Nullable
    private Spacing mBorderAlpha;
    @Nullable
    private BorderStyle mBorderStyle;
    @Nullable
    private PathEffect mPathEffectForBorderStyle;
    @Nullable
    private Path mPathForBorderRadius;
    @Nullable
    private Path mPathForBorderRadiusOutline;
    @Nullable
    private Path mPathForBorder;
    @Nullable
    private RectF mTempRectForBorderRadius;
    @Nullable
    private RectF mTempRectForBorderRadiusOutline;
    private boolean mNeedUpdatePathForBorderRadius = false;
    private float mBorderRadius = Float.NaN;
    private final Paint mPaint = new Paint(1);
    private int mColor = 0;
    private int mAlpha = 255;
    @Nullable
    private float[] mBorderCornerRadii;

    public void draw(Canvas canvas) {
        boolean roundedBorders;
        this.updatePathEffect();
        boolean bl = roundedBorders = this.mBorderCornerRadii != null || !YogaConstants.isUndefined(this.mBorderRadius) && this.mBorderRadius > 0.0f;
        if (!roundedBorders) {
            this.drawRectangularBackgroundWithBorders(canvas);
        } else {
            this.drawRoundedBackgroundWithBorders(canvas);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mNeedUpdatePathForBorderRadius = true;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return ColorUtil.getOpacityFromColor(ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    public void getOutline(Outline outline) {
        if (Build.VERSION.SDK_INT < 21) {
            super.getOutline(outline);
            return;
        }
        if (!YogaConstants.isUndefined(this.mBorderRadius) && this.mBorderRadius > 0.0f || this.mBorderCornerRadii != null) {
            this.updatePath();
            outline.setConvexPath(this.mPathForBorderRadiusOutline);
        } else {
            outline.setRect(this.getBounds());
        }
    }

    public void setBorderWidth(int position, float width) {
        if (this.mBorderWidth == null) {
            this.mBorderWidth = new Spacing();
        }
        if (!FloatUtil.floatsEqual(this.mBorderWidth.getRaw(position), width)) {
            this.mBorderWidth.set(position, width);
            if (position == 8) {
                this.mNeedUpdatePathForBorderRadius = true;
            }
            this.invalidateSelf();
        }
    }

    public void setBorderColor(int position, float rgb, float alpha) {
        this.setBorderRGB(position, rgb);
        this.setBorderAlpha(position, alpha);
    }

    private void setBorderRGB(int position, float rgb) {
        if (this.mBorderRGB == null) {
            this.mBorderRGB = new Spacing(0.0f);
        }
        if (!FloatUtil.floatsEqual(this.mBorderRGB.getRaw(position), rgb)) {
            this.mBorderRGB.set(position, rgb);
            this.invalidateSelf();
        }
    }

    private void setBorderAlpha(int position, float alpha) {
        if (this.mBorderAlpha == null) {
            this.mBorderAlpha = new Spacing(255.0f);
        }
        if (!FloatUtil.floatsEqual(this.mBorderAlpha.getRaw(position), alpha)) {
            this.mBorderAlpha.set(position, alpha);
            this.invalidateSelf();
        }
    }

    public void setBorderStyle(@Nullable String style2) {
        BorderStyle borderStyle;
        BorderStyle borderStyle2 = borderStyle = style2 == null ? null : BorderStyle.valueOf(style2.toUpperCase(Locale.US));
        if (this.mBorderStyle != borderStyle) {
            this.mBorderStyle = borderStyle;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setRadius(float radius) {
        if (!FloatUtil.floatsEqual(this.mBorderRadius, radius)) {
            this.mBorderRadius = radius;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setRadius(float radius, int position) {
        if (this.mBorderCornerRadii == null) {
            this.mBorderCornerRadii = new float[4];
            Arrays.fill(this.mBorderCornerRadii, Float.NaN);
        }
        if (!FloatUtil.floatsEqual(this.mBorderCornerRadii[position], radius)) {
            this.mBorderCornerRadii[position] = radius;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    @VisibleForTesting
    public int getColor() {
        return this.mColor;
    }

    private void drawRoundedBackgroundWithBorders(Canvas canvas) {
        float fullBorderWidth;
        this.updatePath();
        int useColor = ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha);
        if (Color.alpha((int)useColor) != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawPath(this.mPathForBorderRadius, this.mPaint);
        }
        if ((fullBorderWidth = this.getFullBorderWidth()) > 0.0f) {
            int borderColor = this.getFullBorderColor();
            this.mPaint.setColor(ColorUtil.multiplyColorAlpha(borderColor, this.mAlpha));
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(fullBorderWidth);
            canvas.drawPath(this.mPathForBorderRadius, this.mPaint);
        }
    }

    private void updatePath() {
        if (!this.mNeedUpdatePathForBorderRadius) {
            return;
        }
        this.mNeedUpdatePathForBorderRadius = false;
        if (this.mPathForBorderRadius == null) {
            this.mPathForBorderRadius = new Path();
            this.mTempRectForBorderRadius = new RectF();
            this.mPathForBorderRadiusOutline = new Path();
            this.mTempRectForBorderRadiusOutline = new RectF();
        }
        this.mPathForBorderRadius.reset();
        this.mPathForBorderRadiusOutline.reset();
        this.mTempRectForBorderRadius.set(this.getBounds());
        this.mTempRectForBorderRadiusOutline.set(this.getBounds());
        float fullBorderWidth = this.getFullBorderWidth();
        if (fullBorderWidth > 0.0f) {
            this.mTempRectForBorderRadius.inset(fullBorderWidth * 0.5f, fullBorderWidth * 0.5f);
        }
        float defaultBorderRadius = !YogaConstants.isUndefined(this.mBorderRadius) ? this.mBorderRadius : 0.0f;
        float topLeftRadius = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[0]) ? this.mBorderCornerRadii[0] : defaultBorderRadius;
        float topRightRadius = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[1]) ? this.mBorderCornerRadii[1] : defaultBorderRadius;
        float bottomRightRadius = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[2]) ? this.mBorderCornerRadii[2] : defaultBorderRadius;
        float bottomLeftRadius = this.mBorderCornerRadii != null && !YogaConstants.isUndefined(this.mBorderCornerRadii[3]) ? this.mBorderCornerRadii[3] : defaultBorderRadius;
        this.mPathForBorderRadius.addRoundRect(this.mTempRectForBorderRadius, new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius}, Path.Direction.CW);
        float extraRadiusForOutline = 0.0f;
        if (this.mBorderWidth != null) {
            extraRadiusForOutline = this.mBorderWidth.get(8) / 2.0f;
        }
        this.mPathForBorderRadiusOutline.addRoundRect(this.mTempRectForBorderRadiusOutline, new float[]{topLeftRadius + extraRadiusForOutline, topLeftRadius + extraRadiusForOutline, topRightRadius + extraRadiusForOutline, topRightRadius + extraRadiusForOutline, bottomRightRadius + extraRadiusForOutline, bottomRightRadius + extraRadiusForOutline, bottomLeftRadius + extraRadiusForOutline, bottomLeftRadius + extraRadiusForOutline}, Path.Direction.CW);
    }

    private void updatePathEffect() {
        this.mPathEffectForBorderStyle = this.mBorderStyle != null ? this.mBorderStyle.getPathEffect(this.getFullBorderWidth()) : null;
        this.mPaint.setPathEffect(this.mPathEffectForBorderStyle);
    }

    private float getFullBorderWidth() {
        return this.mBorderWidth != null && !YogaConstants.isUndefined(this.mBorderWidth.getRaw(8)) ? this.mBorderWidth.getRaw(8) : 0.0f;
    }

    private int getFullBorderColor() {
        float rgb = this.mBorderRGB != null && !YogaConstants.isUndefined(this.mBorderRGB.getRaw(8)) ? this.mBorderRGB.getRaw(8) : 0.0f;
        float alpha = this.mBorderAlpha != null && !YogaConstants.isUndefined(this.mBorderAlpha.getRaw(8)) ? this.mBorderAlpha.getRaw(8) : 255.0f;
        return ReactViewBackgroundDrawable.colorFromAlphaAndRGBComponents(alpha, rgb);
    }

    private static int fastBorderCompatibleColorOrZero(int borderLeft, int borderTop, int borderRight, int borderBottom, int colorLeft, int colorTop, int colorRight, int colorBottom) {
        int andSmear = (borderLeft > 0 ? colorLeft : -1) & (borderTop > 0 ? colorTop : -1) & (borderRight > 0 ? colorRight : -1) & (borderBottom > 0 ? colorBottom : -1);
        int orSmear = (borderLeft > 0 ? colorLeft : 0) | (borderTop > 0 ? colorTop : 0) | (borderRight > 0 ? colorRight : 0) | (borderBottom > 0 ? colorBottom : 0);
        return andSmear == orSmear ? andSmear : 0;
    }

    private void drawRectangularBackgroundWithBorders(Canvas canvas) {
        int useColor = ColorUtil.multiplyColorAlpha(this.mColor, this.mAlpha);
        if (Color.alpha((int)useColor) != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(this.getBounds(), this.mPaint);
        }
        if (this.getBorderWidth(0) > 0 || this.getBorderWidth(1) > 0 || this.getBorderWidth(2) > 0 || this.getBorderWidth(3) > 0) {
            Rect bounds = this.getBounds();
            int borderLeft = this.getBorderWidth(0);
            int borderTop = this.getBorderWidth(1);
            int borderRight = this.getBorderWidth(2);
            int borderBottom = this.getBorderWidth(3);
            int colorLeft = this.getBorderColor(0);
            int colorTop = this.getBorderColor(1);
            int colorRight = this.getBorderColor(2);
            int colorBottom = this.getBorderColor(3);
            int left = bounds.left;
            int top = bounds.top;
            int fastBorderColor = ReactViewBackgroundDrawable.fastBorderCompatibleColorOrZero(borderLeft, borderTop, borderRight, borderBottom, colorLeft, colorTop, colorRight, colorBottom);
            if (fastBorderColor != 0) {
                if (Color.alpha((int)fastBorderColor) != 0) {
                    int right = bounds.right;
                    int bottom = bounds.bottom;
                    this.mPaint.setColor(fastBorderColor);
                    if (borderLeft > 0) {
                        int leftInset = left + borderLeft;
                        canvas.drawRect((float)left, (float)top, (float)leftInset, (float)(bottom - borderBottom), this.mPaint);
                    }
                    if (borderTop > 0) {
                        int topInset = top + borderTop;
                        canvas.drawRect((float)(left + borderLeft), (float)top, (float)right, (float)topInset, this.mPaint);
                    }
                    if (borderRight > 0) {
                        int rightInset = right - borderRight;
                        canvas.drawRect((float)rightInset, (float)(top + borderTop), (float)right, (float)bottom, this.mPaint);
                    }
                    if (borderBottom > 0) {
                        int bottomInset = bottom - borderBottom;
                        canvas.drawRect((float)left, (float)bottomInset, (float)(right - borderRight), (float)bottom, this.mPaint);
                    }
                }
            } else {
                if (this.mPathForBorder == null) {
                    this.mPathForBorder = new Path();
                }
                this.mPaint.setAntiAlias(false);
                int width = bounds.width();
                int height = bounds.height();
                if (borderLeft > 0 && colorLeft != 0) {
                    this.mPaint.setColor(colorLeft);
                    this.mPathForBorder.reset();
                    this.mPathForBorder.moveTo((float)left, (float)top);
                    this.mPathForBorder.lineTo((float)(left + borderLeft), (float)(top + borderTop));
                    this.mPathForBorder.lineTo((float)(left + borderLeft), (float)(top + height - borderBottom));
                    this.mPathForBorder.lineTo((float)left, (float)(top + height));
                    this.mPathForBorder.lineTo((float)left, (float)top);
                    canvas.drawPath(this.mPathForBorder, this.mPaint);
                }
                if (borderTop > 0 && colorTop != 0) {
                    this.mPaint.setColor(colorTop);
                    this.mPathForBorder.reset();
                    this.mPathForBorder.moveTo((float)left, (float)top);
                    this.mPathForBorder.lineTo((float)(left + borderLeft), (float)(top + borderTop));
                    this.mPathForBorder.lineTo((float)(left + width - borderRight), (float)(top + borderTop));
                    this.mPathForBorder.lineTo((float)(left + width), (float)top);
                    this.mPathForBorder.lineTo((float)left, (float)top);
                    canvas.drawPath(this.mPathForBorder, this.mPaint);
                }
                if (borderRight > 0 && colorRight != 0) {
                    this.mPaint.setColor(colorRight);
                    this.mPathForBorder.reset();
                    this.mPathForBorder.moveTo((float)(left + width), (float)top);
                    this.mPathForBorder.lineTo((float)(left + width), (float)(top + height));
                    this.mPathForBorder.lineTo((float)(left + width - borderRight), (float)(top + height - borderBottom));
                    this.mPathForBorder.lineTo((float)(left + width - borderRight), (float)(top + borderTop));
                    this.mPathForBorder.lineTo((float)(left + width), (float)top);
                    canvas.drawPath(this.mPathForBorder, this.mPaint);
                }
                if (borderBottom > 0 && colorBottom != 0) {
                    this.mPaint.setColor(colorBottom);
                    this.mPathForBorder.reset();
                    this.mPathForBorder.moveTo((float)left, (float)(top + height));
                    this.mPathForBorder.lineTo((float)(left + width), (float)(top + height));
                    this.mPathForBorder.lineTo((float)(left + width - borderRight), (float)(top + height - borderBottom));
                    this.mPathForBorder.lineTo((float)(left + borderLeft), (float)(top + height - borderBottom));
                    this.mPathForBorder.lineTo((float)left, (float)(top + height));
                    canvas.drawPath(this.mPathForBorder, this.mPaint);
                }
                this.mPaint.setAntiAlias(true);
            }
        }
    }

    private int getBorderWidth(int position) {
        return this.mBorderWidth != null ? Math.round(this.mBorderWidth.get(position)) : 0;
    }

    private static int colorFromAlphaAndRGBComponents(float alpha, float rgb) {
        int rgbComponent = 0xFFFFFF & (int)rgb;
        int alphaComponent = 0xFF000000 & (int)alpha << 24;
        return rgbComponent | alphaComponent;
    }

    private int getBorderColor(int position) {
        float rgb = this.mBorderRGB != null ? this.mBorderRGB.get(position) : 0.0f;
        float alpha = this.mBorderAlpha != null ? this.mBorderAlpha.get(position) : 255.0f;
        return ReactViewBackgroundDrawable.colorFromAlphaAndRGBComponents(alpha, rgb);
    }

    private static enum BorderStyle {
        SOLID,
        DASHED,
        DOTTED;


        @Nullable
        public PathEffect getPathEffect(float borderWidth) {
            switch (this) {
                case SOLID: {
                    return null;
                }
                case DASHED: {
                    return new DashPathEffect(new float[]{borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f}, 0.0f);
                }
                case DOTTED: {
                    return new DashPathEffect(new float[]{borderWidth, borderWidth, borderWidth, borderWidth}, 0.0f);
                }
            }
            return null;
        }
    }
}

