/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.content.Context;
import com.facebook.soloader.SysUtil;
import com.facebook.soloader.UnpackingSoSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public final class ExoSoSource
extends UnpackingSoSource {
    public ExoSoSource(Context context, String name) {
        super(context, name);
    }

    @Override
    protected UnpackingSoSource.Unpacker makeUnpacker() throws IOException {
        return new ExoUnpacker();
    }

    private static final class FileDso
    extends UnpackingSoSource.Dso {
        final File backingFile;

        FileDso(String name, String hash, File backingFile) {
            super(name, hash);
            this.backingFile = backingFile;
        }
    }

    private final class ExoUnpacker
    extends UnpackingSoSource.Unpacker {
        private final FileDso[] mDsos;

        ExoUnpacker() throws IOException {
            Context context = ExoSoSource.this.mContext;
            File exoDir = new File("/data/local/tmp/exopackage/" + context.getPackageName() + "/native-libs/");
            ArrayList<FileDso> providedLibraries = new ArrayList<FileDso>();
            for (String abi : SysUtil.getSupportedAbis()) {
                File metadataFileName;
                File abiDir = new File(exoDir, abi);
                if (!abiDir.isDirectory() || !(metadataFileName = new File(abiDir, "metadata.txt")).isFile()) continue;
                try (FileReader fr = new FileReader(metadataFileName);
                     BufferedReader br = new BufferedReader(fr);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.length() == 0) continue;
                        int sep = line.indexOf(32);
                        if (sep == -1) {
                            throw new RuntimeException("illegal line in exopackage metadata: [" + line + "]");
                        }
                        String soName = line.substring(0, sep) + ".so";
                        int nrAlreadyProvided = providedLibraries.size();
                        boolean found = false;
                        for (int i = 0; i < nrAlreadyProvided; ++i) {
                            if (!((FileDso)providedLibraries.get((int)i)).name.equals(soName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        String backingFileBaseName = line.substring(sep + 1);
                        providedLibraries.add(new FileDso(soName, backingFileBaseName, new File(abiDir, backingFileBaseName)));
                    }
                }
            }
            this.mDsos = providedLibraries.toArray(new FileDso[providedLibraries.size()]);
        }

        @Override
        protected UnpackingSoSource.DsoManifest getDsoManifest() throws IOException {
            return new UnpackingSoSource.DsoManifest(this.mDsos);
        }

        @Override
        protected UnpackingSoSource.InputDsoIterator openDsoIterator() throws IOException {
            return new FileBackedInputDsoIterator();
        }

        private final class FileBackedInputDsoIterator
        extends UnpackingSoSource.InputDsoIterator {
            private int mCurrentDso;

            private FileBackedInputDsoIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.mCurrentDso < ExoUnpacker.this.mDsos.length;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UnpackingSoSource.InputDso next() throws IOException {
                FileDso fileDso = ExoUnpacker.this.mDsos[this.mCurrentDso++];
                try (FileInputStream dsoFile = new FileInputStream(fileDso.backingFile);){
                    UnpackingSoSource.InputDso ret = new UnpackingSoSource.InputDso(fileDso, dsoFile);
                    dsoFile = null;
                    UnpackingSoSource.InputDso inputDso = ret;
                    return inputDso;
                }
            }
        }
    }
}

