/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.reprint.core;

import android.content.Context;
import android.os.Build;
import android.support.v4.os.CancellationSignal;
import com.github.ajalt.library.R;
import com.github.ajalt.reprint.core.AuthenticationFailureReason;
import com.github.ajalt.reprint.core.AuthenticationListener;
import com.github.ajalt.reprint.core.Reprint;
import com.github.ajalt.reprint.core.ReprintModule;
import com.github.ajalt.reprint.module.marshmallow.MarshmallowReprintModule;
import java.lang.reflect.Constructor;

enum ReprintInternal {
    INSTANCE;

    public static final Reprint.Logger NULL_LOGGER;
    private static final String REPRINT_SPASS_MODULE = "com.github.ajalt.reprint.module.spass.SpassReprintModule";
    private CancellationSignal cancellationSignal;
    private ReprintModule module;
    private Context context;

    public ReprintInternal initialize(Context context, Reprint.Logger logger) {
        this.context = context.getApplicationContext();
        if (this.module != null || Build.VERSION.SDK_INT < 17) {
            return this;
        }
        if (logger == null) {
            logger = NULL_LOGGER;
        }
        try {
            Class<?> spassModuleClass = Class.forName(REPRINT_SPASS_MODULE);
            Constructor<?> constructor = spassModuleClass.getConstructor(Context.class, Reprint.Logger.class);
            ReprintModule module = (ReprintModule)constructor.newInstance(context, logger);
            this.registerModule(module);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.registerModule(new MarshmallowReprintModule(context, logger));
        }
        return this;
    }

    public ReprintInternal registerModule(ReprintModule module) {
        if (module == null || this.module != null && module.tag() == this.module.tag()) {
            return this;
        }
        if (module.isHardwarePresent()) {
            this.module = module;
        }
        return this;
    }

    public boolean isHardwarePresent() {
        return this.module != null && this.module.isHardwarePresent();
    }

    public boolean hasFingerprintRegistered() {
        return this.module != null && this.module.hasFingerprintRegistered();
    }

    public void authenticate(AuthenticationListener listener, boolean restartOnNonFatal, int restartCount) {
        if (this.module == null || !this.module.isHardwarePresent()) {
            listener.onFailure(AuthenticationFailureReason.NO_HARDWARE, true, this.getString(R.string.fingerprint_error_hw_not_available), 0, 0);
            return;
        }
        if (!this.module.hasFingerprintRegistered()) {
            listener.onFailure(AuthenticationFailureReason.NO_FINGERPRINTS_REGISTERED, true, this.getString(R.string.fingerprint_not_recognized), 0, 0);
            return;
        }
        this.cancellationSignal = new CancellationSignal();
        if (restartOnNonFatal) {
            this.module.authenticate(this.cancellationSignal, this.restartingListener(listener, restartCount), true);
        } else {
            this.module.authenticate(this.cancellationSignal, listener, false);
        }
    }

    public void cancelAuthentication() {
        if (this.cancellationSignal != null) {
            this.cancellationSignal.cancel();
            this.cancellationSignal = null;
        }
    }

    private String getString(int resid) {
        return this.context == null ? null : this.context.getString(resid);
    }

    private AuthenticationListener restartingListener(final AuthenticationListener originalListener, final int restartCount) {
        return new AuthenticationListener(){

            @Override
            public void onSuccess(int moduleTag) {
                originalListener.onSuccess(moduleTag);
            }

            @Override
            public void onFailure(AuthenticationFailureReason failureReason, boolean fatal, CharSequence errorMessage, int moduleTag, int errorCode) {
                if (ReprintInternal.this.module != null && ReprintInternal.this.cancellationSignal != null && failureReason == AuthenticationFailureReason.TIMEOUT && restartCount > 0) {
                    ReprintInternal.this.module.authenticate(ReprintInternal.this.cancellationSignal, ReprintInternal.this.restartingListener(originalListener, restartCount - 1), true);
                } else {
                    originalListener.onFailure(failureReason, fatal, errorMessage, moduleTag, errorCode);
                }
            }
        };
    }

    static {
        NULL_LOGGER = new Reprint.Logger(){

            @Override
            public void log(String message) {
            }

            @Override
            public void logException(Throwable throwable, String message) {
            }
        };
    }
}

