/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.reprint.module.marshmallow;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.CancellationSignal;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.github.ajalt.library.R;
import com.github.ajalt.reprint.core.AuthenticationFailureReason;
import com.github.ajalt.reprint.core.AuthenticationListener;
import com.github.ajalt.reprint.core.Reprint;
import com.github.ajalt.reprint.core.ReprintModule;

@TargetApi(value=23)
@RequiresApi(value=23)
public class MarshmallowReprintModule
implements ReprintModule {
    public static final int TAG = 1;
    public static final int FINGERPRINT_ERROR_HW_UNAVAILABLE = 1;
    public static final int FINGERPRINT_ERROR_UNABLE_TO_PROCESS = 2;
    public static final int FINGERPRINT_ERROR_TIMEOUT = 3;
    public static final int FINGERPRINT_ERROR_NO_SPACE = 4;
    public static final int FINGERPRINT_ERROR_CANCELED = 5;
    public static final int FINGERPRINT_ERROR_LOCKOUT = 7;
    public static final int FINGERPRINT_ACQUIRED_GOOD = 0;
    public static final int FINGERPRINT_ACQUIRED_PARTIAL = 1;
    public static final int FINGERPRINT_ACQUIRED_INSUFFICIENT = 2;
    public static final int FINGERPRINT_ACQUIRED_IMAGER_DIRTY = 3;
    public static final int FINGERPRINT_ACQUIRED_TOO_SLOW = 4;
    public static final int FINGERPRINT_ACQUIRED_TOO_FAST = 5;
    public static final int FINGERPRINT_AUTHENTICATION_FAILED = 1001;
    private final Context context;
    private final Reprint.Logger logger;

    public MarshmallowReprintModule(Context context, Reprint.Logger logger) {
        this.context = context.getApplicationContext();
        this.logger = logger;
    }

    private FingerprintManager fingerprintManager() {
        try {
            return (FingerprintManager)this.context.getSystemService(FingerprintManager.class);
        }
        catch (Exception e) {
            this.logger.logException(e, "Could not get fingerprint system service on API that should support it.");
        }
        catch (NoClassDefFoundError e) {
            this.logger.log("FingerprintManager not available on this device");
        }
        return null;
    }

    @Override
    public int tag() {
        return 1;
    }

    @Override
    public boolean isHardwarePresent() {
        FingerprintManager fingerprintManager = this.fingerprintManager();
        if (fingerprintManager == null) {
            return false;
        }
        try {
            return fingerprintManager.isHardwareDetected();
        }
        catch (NullPointerException | SecurityException e) {
            this.logger.logException(e, "MarshmallowReprintModule: isHardwareDetected failed unexpectedly");
            return false;
        }
    }

    @Override
    public boolean hasFingerprintRegistered() throws SecurityException {
        FingerprintManager fingerprintManager = this.fingerprintManager();
        return fingerprintManager != null && fingerprintManager.hasEnrolledFingerprints();
    }

    @Override
    public void authenticate(android.support.v4.os.CancellationSignal cancellationSignal, AuthenticationListener listener, boolean restartOnNonFatal) throws SecurityException {
        FingerprintManager fingerprintManager = this.fingerprintManager();
        if (fingerprintManager == null) {
            listener.onFailure(AuthenticationFailureReason.UNKNOWN, true, this.context.getString(R.string.fingerprint_error_unable_to_process), 1, 5);
            return;
        }
        FingerprintManager.AuthenticationCallback callback = this.getAuthenticationCallback(cancellationSignal, listener, restartOnNonFatal);
        CancellationSignal signalObject = cancellationSignal == null ? null : (CancellationSignal)cancellationSignal.getCancellationSignalObject();
        try {
            fingerprintManager.authenticate(null, signalObject, 0, callback, null);
        }
        catch (NullPointerException e) {
            this.logger.logException(e, "MarshmallowReprintModule: authenticate failed unexpectedly");
            listener.onFailure(AuthenticationFailureReason.UNKNOWN, true, this.context.getString(R.string.fingerprint_error_unable_to_process), 1, 5);
        }
    }

    @NonNull
    private FingerprintManager.AuthenticationCallback getAuthenticationCallback(final android.support.v4.os.CancellationSignal cancellationSignal, final AuthenticationListener listener, final boolean restartOnNonFatal) {
        return new FingerprintManager.AuthenticationCallback(){

            public void onAuthenticationError(int errMsgId, CharSequence errString) {
                AuthenticationFailureReason failureReason = AuthenticationFailureReason.UNKNOWN;
                switch (errMsgId) {
                    case 1: {
                        failureReason = AuthenticationFailureReason.HARDWARE_UNAVAILABLE;
                        break;
                    }
                    case 2: 
                    case 4: {
                        failureReason = AuthenticationFailureReason.SENSOR_FAILED;
                        break;
                    }
                    case 3: {
                        failureReason = AuthenticationFailureReason.TIMEOUT;
                        break;
                    }
                    case 7: {
                        failureReason = AuthenticationFailureReason.LOCKED_OUT;
                        break;
                    }
                    case 5: {
                        return;
                    }
                }
                listener.onFailure(failureReason, true, errString, 1, errMsgId);
            }

            public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
                if (!restartOnNonFatal) {
                    cancellationSignal.cancel();
                }
                listener.onFailure(AuthenticationFailureReason.SENSOR_FAILED, false, helpString, 1, helpMsgId);
            }

            public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
                listener.onSuccess(1);
            }

            public void onAuthenticationFailed() {
                listener.onFailure(AuthenticationFailureReason.AUTHENTICATION_FAILED, false, MarshmallowReprintModule.this.context.getString(R.string.fingerprint_not_recognized), 1, 1001);
            }
        };
    }
}

