/*
 * Decompiled with CFR 0.152.
 */
package co.eleken.react_native_touch_id_android;

import android.app.Activity;
import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.github.ajalt.reprint.core.AuthenticationFailureReason;
import com.github.ajalt.reprint.core.AuthenticationListener;
import com.github.ajalt.reprint.core.Reprint;

public class FingerprintModule
extends ReactContextBaseJavaModule {
    private WritableMap response;
    private final ReactApplicationContext mReactContext;

    FingerprintModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mReactContext = reactContext;
    }

    public String getName() {
        return "Fingerprint";
    }

    @ReactMethod
    public void requestTouch(final Promise promise) {
        this.response = Arguments.createMap();
        if (!this.isSensorAvailable()) {
            this.sendResponse("failed", "Finger sensor is not available", promise);
            return;
        }
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity == null) {
            this.sendResponse("failed", "Can't find current Activity", promise);
            return;
        }
        Reprint.authenticate((AuthenticationListener)new AuthenticationListener(){

            public void onSuccess(int moduleTag) {
                FingerprintModule.this.sendResponse("ok", null, promise);
            }

            public void onFailure(AuthenticationFailureReason failureReason, boolean fatal, final CharSequence errorMessage, int moduleTag, int errorCode) {
                if (Build.VERSION.SDK_INT >= 19) {
                    if (failureReason == AuthenticationFailureReason.LOCKED_OUT) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FingerprintModule.this.sendResponse("failed", "LOCKED_OUT", promise);
                                }
                                catch (Exception e) {
                                    Log.d((String)"exceptionLog", (String)errorMessage.toString());
                                }
                            }
                        });
                        t.start();
                    } else {
                        FingerprintModule.this.sendResponse("failed", errorMessage.toString(), promise);
                    }
                }
            }
        });
    }

    @ReactMethod
    public void dismiss() {
        Reprint.cancelAuthentication();
    }

    @ReactMethod
    public void isSensorAvailable(Promise promise) {
        this.response = Arguments.createMap();
        if (Build.VERSION.SDK_INT >= 23) {
            if (ActivityCompat.checkSelfPermission((Context)this.mReactContext, (String)"android.permission.USE_FINGERPRINT") != 0) {
                this.sendResponse("failed", "You haven't allow this app to use your fingerprint sensor", promise);
                return;
            }
            if (this.mReactContext.getPackageManager().hasSystemFeature("android.hardware.fingerprint") || ((FingerprintManager)this.mReactContext.getSystemService("fingerprint")).isHardwareDetected()) {
                if (((FingerprintManager)this.mReactContext.getSystemService("fingerprint")).hasEnrolledFingerprints()) {
                    this.sendResponse("ok", null, promise);
                } else {
                    this.sendResponse("failed", "You have fingerprint sensor, but you should set it enabled in your settings to use with this app", promise);
                }
            } else {
                this.sendResponse("failed", "You don't have appropriate hardware", promise);
            }
        }
    }

    private boolean isSensorAvailable() {
        if (ActivityCompat.checkSelfPermission((Context)this.mReactContext, (String)"android.permission.USE_FINGERPRINT") != 0) {
            return false;
        }
        return Build.VERSION.SDK_INT >= 23 && (this.mReactContext.getPackageManager().hasSystemFeature("android.hardware.fingerprint") || ((FingerprintManager)this.mReactContext.getSystemService("fingerprint")).isHardwareDetected());
    }

    private void sendResponse(String status, String message, Promise promise) {
        Reprint.cancelAuthentication();
        this.response = Arguments.createMap();
        this.response.putString("status", status);
        this.response.putString("error", message);
        promise.resolve((Object)this.response);
    }
}

