/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.cxxbridge.CatalystInstanceImpl;
import com.facebook.react.cxxbridge.CxxModuleWrapper;
import com.facebook.react.cxxbridge.JavaModuleWrapper;
import com.facebook.react.cxxbridge.ModuleHolder;
import com.facebook.react.cxxbridge.UiThreadUtil;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NativeModuleRegistry {
    private final Map<Class<? extends NativeModule>, ModuleHolder> mModules;
    private final ArrayList<OnBatchCompleteListener> mBatchCompleteListenerModules;

    public NativeModuleRegistry(Map<Class<? extends NativeModule>, ModuleHolder> modules, ArrayList<OnBatchCompleteListener> batchCompleteListenerModules) {
        this.mModules = modules;
        this.mBatchCompleteListenerModules = batchCompleteListenerModules;
    }

    Collection<JavaModuleWrapper> getJavaModules(CatalystInstanceImpl catalystInstanceImpl) {
        ArrayList<JavaModuleWrapper> javaModules = new ArrayList<JavaModuleWrapper>();
        for (Map.Entry<Class<? extends NativeModule>, ModuleHolder> entry : this.mModules.entrySet()) {
            Class<? extends NativeModule> type = entry.getKey();
            if (CxxModuleWrapper.class.isAssignableFrom(type)) continue;
            javaModules.add(new JavaModuleWrapper(catalystInstanceImpl, entry.getValue()));
        }
        return javaModules;
    }

    Collection<CxxModuleWrapper> getCxxModules() {
        ArrayList<CxxModuleWrapper> cxxModules = new ArrayList<CxxModuleWrapper>();
        for (Map.Entry<Class<? extends NativeModule>, ModuleHolder> entry : this.mModules.entrySet()) {
            Class<? extends NativeModule> type = entry.getKey();
            if (!CxxModuleWrapper.class.isAssignableFrom(type)) continue;
            cxxModules.add((CxxModuleWrapper)entry.getValue().getModule());
        }
        return cxxModules;
    }

    void notifyCatalystInstanceDestroy() {
        UiThreadUtil.assertOnUiThread();
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyCatalystInstanceDestroy");
        try {
            for (ModuleHolder module : this.mModules.values()) {
                module.destroy();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    void notifyCatalystInstanceInitialized() {
        UiThreadUtil.assertOnUiThread();
        ReactMarker.logMarker("NativeModule_start");
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyCatalystInstanceInitialized");
        try {
            for (ModuleHolder module : this.mModules.values()) {
                module.initialize();
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("NativeModule_end");
        }
    }

    public void onBatchComplete() {
        for (int i = 0; i < this.mBatchCompleteListenerModules.size(); ++i) {
            this.mBatchCompleteListenerModules.get(i).onBatchComplete();
        }
    }

    public <T extends NativeModule> boolean hasModule(Class<T> moduleInterface) {
        return this.mModules.containsKey(moduleInterface);
    }

    public <T extends NativeModule> T getModule(Class<T> moduleInterface) {
        return (T)((ModuleHolder)Assertions.assertNotNull((Object)this.mModules.get(moduleInterface))).getModule();
    }

    public List<NativeModule> getAllModules() {
        ArrayList<NativeModule> modules = new ArrayList<NativeModule>();
        for (ModuleHolder module : this.mModules.values()) {
            modules.add(module.getModule());
        }
        return modules;
    }
}

