/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CallbackImpl;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromArray;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.NativeArgumentsParseException;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.PromiseImpl;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class BaseJavaModule
implements NativeModule {
    public static final String METHOD_TYPE_ASYNC = "async";
    public static final String METHOD_TYPE_PROMISE = "promise";
    public static final String METHOD_TYPE_SYNC = "sync";
    private static final ArgumentExtractor<Boolean> ARGUMENT_EXTRACTOR_BOOLEAN = new ArgumentExtractor<Boolean>(){

        @Override
        public Boolean extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getBoolean(atIndex);
        }
    };
    private static final ArgumentExtractor<Double> ARGUMENT_EXTRACTOR_DOUBLE = new ArgumentExtractor<Double>(){

        @Override
        public Double extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getDouble(atIndex);
        }
    };
    private static final ArgumentExtractor<Float> ARGUMENT_EXTRACTOR_FLOAT = new ArgumentExtractor<Float>(){

        @Override
        public Float extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return Float.valueOf((float)jsArguments.getDouble(atIndex));
        }
    };
    private static final ArgumentExtractor<Integer> ARGUMENT_EXTRACTOR_INTEGER = new ArgumentExtractor<Integer>(){

        @Override
        public Integer extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return (int)jsArguments.getDouble(atIndex);
        }
    };
    private static final ArgumentExtractor<String> ARGUMENT_EXTRACTOR_STRING = new ArgumentExtractor<String>(){

        @Override
        public String extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getString(atIndex);
        }
    };
    private static final ArgumentExtractor<ReadableNativeArray> ARGUMENT_EXTRACTOR_ARRAY = new ArgumentExtractor<ReadableNativeArray>(){

        @Override
        public ReadableNativeArray extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getArray(atIndex);
        }
    };
    private static final ArgumentExtractor<Dynamic> ARGUMENT_EXTRACTOR_DYNAMIC = new ArgumentExtractor<Dynamic>(){

        @Override
        public Dynamic extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return DynamicFromArray.create(jsArguments, atIndex);
        }
    };
    private static final ArgumentExtractor<ReadableMap> ARGUMENT_EXTRACTOR_MAP = new ArgumentExtractor<ReadableMap>(){

        @Override
        public ReadableMap extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getMap(atIndex);
        }
    };
    private static final ArgumentExtractor<Callback> ARGUMENT_EXTRACTOR_CALLBACK = new ArgumentExtractor<Callback>(){

        @Override
        @Nullable
        public Callback extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            if (jsArguments.isNull(atIndex)) {
                return null;
            }
            int id = (int)jsArguments.getDouble(atIndex);
            return new CallbackImpl(jsInstance, executorToken, id);
        }
    };
    private static final ArgumentExtractor<Promise> ARGUMENT_EXTRACTOR_PROMISE = new ArgumentExtractor<Promise>(){

        @Override
        public int getJSArgumentsNeeded() {
            return 2;
        }

        @Override
        public Promise extractArgument(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            Callback resolve = (Callback)ARGUMENT_EXTRACTOR_CALLBACK.extractArgument(jsInstance, executorToken, jsArguments, atIndex);
            Callback reject = (Callback)ARGUMENT_EXTRACTOR_CALLBACK.extractArgument(jsInstance, executorToken, jsArguments, atIndex + 1);
            return new PromiseImpl(resolve, reject);
        }
    };
    @Nullable
    private Map<String, NativeModule.NativeMethod> mMethods;

    private void findMethods() {
        if (this.mMethods == null) {
            Method[] targetMethods;
            Systrace.beginSection(0L, "findMethods");
            this.mMethods = new HashMap<String, NativeModule.NativeMethod>();
            for (Method targetMethod : targetMethods = this.getClass().getDeclaredMethods()) {
                ReactMethod annotation = targetMethod.getAnnotation(ReactMethod.class);
                if (annotation == null) continue;
                String methodName = targetMethod.getName();
                if (this.mMethods.containsKey(methodName)) {
                    throw new IllegalArgumentException("Java Module " + this.getName() + " method name already registered: " + methodName);
                }
                this.mMethods.put(methodName, new JavaMethod(targetMethod, annotation.isBlockingSynchronousMethod()));
            }
            Systrace.endSection(0L);
        }
    }

    @Override
    public final Map<String, NativeModule.NativeMethod> getMethods() {
        this.findMethods();
        return (Map)Assertions.assertNotNull(this.mMethods);
    }

    @Nullable
    public Map<String, Object> getConstants() {
        return null;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canOverrideExistingModule() {
        return false;
    }

    @Override
    public void onCatalystInstanceDestroy() {
    }

    @Override
    public boolean supportsWebWorkers() {
        return false;
    }

    private static char paramTypeToChar(Class paramClass) {
        char tryCommon = BaseJavaModule.commonTypeToChar(paramClass);
        if (tryCommon != '\u0000') {
            return tryCommon;
        }
        if (paramClass == ExecutorToken.class) {
            return 'T';
        }
        if (paramClass == Callback.class) {
            return 'X';
        }
        if (paramClass == Promise.class) {
            return 'P';
        }
        if (paramClass == ReadableMap.class) {
            return 'M';
        }
        if (paramClass == ReadableArray.class) {
            return 'A';
        }
        if (paramClass == Dynamic.class) {
            return 'Y';
        }
        throw new RuntimeException("Got unknown param class: " + paramClass.getSimpleName());
    }

    private static char returnTypeToChar(Class returnClass) {
        char tryCommon = BaseJavaModule.commonTypeToChar(returnClass);
        if (tryCommon != '\u0000') {
            return tryCommon;
        }
        if (returnClass == Void.TYPE) {
            return 'v';
        }
        if (returnClass == WritableMap.class) {
            return 'M';
        }
        if (returnClass == WritableArray.class) {
            return 'A';
        }
        throw new RuntimeException("Got unknown return class: " + returnClass.getSimpleName());
    }

    private static char commonTypeToChar(Class typeClass) {
        if (typeClass == Boolean.TYPE) {
            return 'z';
        }
        if (typeClass == Boolean.class) {
            return 'Z';
        }
        if (typeClass == Integer.TYPE) {
            return 'i';
        }
        if (typeClass == Integer.class) {
            return 'I';
        }
        if (typeClass == Double.TYPE) {
            return 'd';
        }
        if (typeClass == Double.class) {
            return 'D';
        }
        if (typeClass == Float.TYPE) {
            return 'f';
        }
        if (typeClass == Float.class) {
            return 'F';
        }
        if (typeClass == String.class) {
            return 'S';
        }
        return '\u0000';
    }

    public class JavaMethod
    implements NativeModule.NativeMethod {
        private final Method mMethod;
        private final Class[] mParameterTypes;
        private final int mParamLength;
        private boolean mArgumentsProcessed = false;
        @Nullable
        private ArgumentExtractor[] mArgumentExtractors;
        @Nullable
        private String mSignature;
        @Nullable
        private Object[] mArguments;
        private String mType = "async";
        @Nullable
        private int mJSArgumentsNeeded;
        private String mTraceName;

        public JavaMethod(Method method, boolean isSync) {
            this.mMethod = method;
            this.mMethod.setAccessible(true);
            Systrace.beginSection(0L, "callGetParameterTypes");
            this.mParameterTypes = this.mMethod.getParameterTypes();
            Systrace.endSection(0L);
            this.mParamLength = this.mParameterTypes.length;
            if (isSync) {
                this.mType = BaseJavaModule.METHOD_TYPE_SYNC;
            } else if (this.mParamLength > 0 && this.mParameterTypes[this.mParamLength - 1] == Promise.class) {
                this.mType = BaseJavaModule.METHOD_TYPE_PROMISE;
            }
            this.mTraceName = BaseJavaModule.this.getName() + "." + this.mMethod.getName();
        }

        private void processArguments() {
            if (this.mArgumentsProcessed) {
                return;
            }
            this.mArgumentsProcessed = true;
            this.mArgumentExtractors = this.buildArgumentExtractors(this.mParameterTypes);
            this.mSignature = this.buildSignature(this.mMethod, this.mParameterTypes, this.mType.equals(BaseJavaModule.METHOD_TYPE_SYNC));
            this.mArguments = new Object[this.mParameterTypes.length];
            this.mJSArgumentsNeeded = this.calculateJSArgumentsNeeded();
        }

        public Method getMethod() {
            return this.mMethod;
        }

        public String getSignature() {
            if (!this.mArgumentsProcessed) {
                this.processArguments();
            }
            return (String)Assertions.assertNotNull((Object)this.mSignature);
        }

        private String buildSignature(Method method, Class[] paramTypes, boolean isSync) {
            StringBuilder builder = new StringBuilder(paramTypes.length + 2);
            if (isSync) {
                builder.append(BaseJavaModule.returnTypeToChar(method.getReturnType()));
                builder.append('.');
            } else {
                builder.append("v.");
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                Class paramClass = paramTypes[i];
                if (paramClass == ExecutorToken.class) {
                    if (!BaseJavaModule.this.supportsWebWorkers()) {
                        throw new RuntimeException("Module " + BaseJavaModule.this + " doesn't support web workers, but " + this.mMethod.getName() + " takes an ExecutorToken.");
                    }
                } else if (paramClass == Promise.class) {
                    Assertions.assertCondition((i == paramTypes.length - 1 ? 1 : 0) != 0, (String)"Promise must be used as last parameter only");
                    if (!isSync) {
                        this.mType = BaseJavaModule.METHOD_TYPE_PROMISE;
                    }
                }
                builder.append(BaseJavaModule.paramTypeToChar(paramClass));
            }
            if (BaseJavaModule.this.supportsWebWorkers() && builder.charAt(2) != 'T') {
                throw new RuntimeException("Module " + BaseJavaModule.this + " supports web workers, but " + this.mMethod.getName() + "does not take an ExecutorToken as its first parameter.");
            }
            return builder.toString();
        }

        private ArgumentExtractor[] buildArgumentExtractors(Class[] paramTypes) {
            int executorTokenOffset = 0;
            if (BaseJavaModule.this.supportsWebWorkers()) {
                if (paramTypes[0] != ExecutorToken.class) {
                    throw new RuntimeException("Module " + BaseJavaModule.this + " supports web workers, but " + this.mMethod.getName() + "does not take an ExecutorToken as its first parameter.");
                }
                executorTokenOffset = 1;
            }
            ArgumentExtractor[] argumentExtractors = new ArgumentExtractor[paramTypes.length - executorTokenOffset];
            for (int i = 0; i < paramTypes.length - executorTokenOffset; i += argumentExtractors[i].getJSArgumentsNeeded()) {
                int paramIndex = i + executorTokenOffset;
                Class argumentClass = paramTypes[paramIndex];
                if (argumentClass == Boolean.class || argumentClass == Boolean.TYPE) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_BOOLEAN;
                    continue;
                }
                if (argumentClass == Integer.class || argumentClass == Integer.TYPE) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_INTEGER;
                    continue;
                }
                if (argumentClass == Double.class || argumentClass == Double.TYPE) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_DOUBLE;
                    continue;
                }
                if (argumentClass == Float.class || argumentClass == Float.TYPE) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_FLOAT;
                    continue;
                }
                if (argumentClass == String.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_STRING;
                    continue;
                }
                if (argumentClass == Callback.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_CALLBACK;
                    continue;
                }
                if (argumentClass == Promise.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_PROMISE;
                    Assertions.assertCondition((paramIndex == paramTypes.length - 1 ? 1 : 0) != 0, (String)"Promise must be used as last parameter only");
                    this.mType = BaseJavaModule.METHOD_TYPE_PROMISE;
                    continue;
                }
                if (argumentClass == ReadableMap.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_MAP;
                    continue;
                }
                if (argumentClass == ReadableArray.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_ARRAY;
                    continue;
                }
                if (argumentClass == Dynamic.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_DYNAMIC;
                    continue;
                }
                throw new RuntimeException("Got unknown argument class: " + argumentClass.getSimpleName());
            }
            return argumentExtractors;
        }

        private int calculateJSArgumentsNeeded() {
            int n = 0;
            for (ArgumentExtractor extractor : this.mArgumentExtractors) {
                n += extractor.getJSArgumentsNeeded();
            }
            return n;
        }

        private String getAffectedRange(int startIndex, int jsArgumentsNeeded) {
            return jsArgumentsNeeded > 1 ? "" + startIndex + "-" + (startIndex + jsArgumentsNeeded - 1) : "" + startIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(JSInstance jsInstance, ExecutorToken executorToken, ReadableNativeArray parameters) {
            SystraceMessage.beginSection(0L, "callJavaModuleMethod").arg("method", this.mTraceName).flush();
            try {
                if (!this.mArgumentsProcessed) {
                    this.processArguments();
                }
                if (this.mArguments == null || this.mArgumentExtractors == null) {
                    throw new Error("processArguments failed");
                }
                if (this.mJSArgumentsNeeded != parameters.size()) {
                    throw new NativeArgumentsParseException(BaseJavaModule.this.getName() + "." + this.mMethod.getName() + " got " + parameters.size() + " arguments, expected " + this.mJSArgumentsNeeded);
                }
                int i = 0;
                int jsArgumentsConsumed = 0;
                int executorTokenOffset = 0;
                if (BaseJavaModule.this.supportsWebWorkers()) {
                    this.mArguments[0] = executorToken;
                    executorTokenOffset = 1;
                }
                try {
                    while (i < this.mArgumentExtractors.length) {
                        this.mArguments[i + executorTokenOffset] = this.mArgumentExtractors[i].extractArgument(jsInstance, executorToken, parameters, jsArgumentsConsumed);
                        jsArgumentsConsumed += this.mArgumentExtractors[i].getJSArgumentsNeeded();
                        ++i;
                    }
                }
                catch (UnexpectedNativeTypeException e) {
                    throw new NativeArgumentsParseException(e.getMessage() + " (constructing arguments for " + BaseJavaModule.this.getName() + "." + this.mMethod.getName() + " at argument index " + this.getAffectedRange(jsArgumentsConsumed, this.mArgumentExtractors[i].getJSArgumentsNeeded()) + ")", e);
                }
                try {
                    this.mMethod.invoke((Object)BaseJavaModule.this, this.mArguments);
                }
                catch (IllegalArgumentException ie) {
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.mMethod.getName(), ie);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.mMethod.getName(), iae);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ite.getCause();
                    }
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.mMethod.getName(), ite);
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }

        @Override
        public String getType() {
            return this.mType;
        }
    }

    private static abstract class ArgumentExtractor<T> {
        private ArgumentExtractor() {
        }

        public int getJSArgumentsNeeded() {
            return 1;
        }

        @Nullable
        public abstract T extractArgument(JSInstance var1, ExecutorToken var2, ReadableNativeArray var3, int var4);
    }
}

