/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.common.logging.FLog;
import com.facebook.react.cxxbridge.CatalystInstanceImpl;
import com.facebook.react.cxxbridge.JSBundleLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public final class FallbackJSBundleLoader
extends JSBundleLoader {
    static final String RECOVERABLE = "facebook::react::Recoverable";
    static final String TAG = "FallbackJSBundleLoader";
    private Stack<JSBundleLoader> mLoaders;
    private final ArrayList<Exception> mRecoveredErrors = new ArrayList();

    public FallbackJSBundleLoader(List<JSBundleLoader> loaders) {
        this.mLoaders = new Stack();
        ListIterator<JSBundleLoader> it = loaders.listIterator(loaders.size());
        while (it.hasPrevious()) {
            this.mLoaders.push(it.previous());
        }
    }

    @Override
    public String loadScript(CatalystInstanceImpl instance) {
        while (true) {
            try {
                return this.getDelegateLoader().loadScript(instance);
            }
            catch (Exception e) {
                if (!e.getMessage().startsWith(RECOVERABLE)) {
                    throw e;
                }
                this.mLoaders.pop();
                this.mRecoveredErrors.add(e);
                FLog.wtf((String)TAG, (String)"Falling back from recoverable error", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private JSBundleLoader getDelegateLoader() {
        RuntimeException fallbackException;
        if (!this.mLoaders.empty()) {
            return this.mLoaders.peek();
        }
        Throwable tail = fallbackException = new RuntimeException("No fallback options available");
        for (Exception e : this.mRecoveredErrors) {
            tail.initCause(e);
            while (tail.getCause() != null) {
                tail = tail.getCause();
            }
        }
        throw fallbackException;
    }
}

