/*
 * Decompiled with CFR 0.152.
 */
package com.cpming.rn.unionpay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.chinaums.pppay.unify.UnifyPayPlugin;
import com.chinaums.pppay.unify.UnifyPayRequest;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.unionpay.UPPayAssistEx;
import com.unionpay.UPQuerySEPayInfoCallback;
import com.unionpay.UPSEInfoResp;
import javax.annotation.Nonnull;
import org.json.JSONException;
import org.json.JSONObject;

public class RCTUnionpayModule
extends ReactContextBaseJavaModule
implements ActivityEventListener {
    private final String TAG = "RCTUnionpayModule";
    private ReactApplicationContext reactContext;

    public RCTUnionpayModule(@Nonnull ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
        this.reactContext.addActivityEventListener((ActivityEventListener)this);
    }

    @Nonnull
    public String getName() {
        return "UnionPayModule";
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        if (data == null) {
            return;
        }
        WritableMap response = Arguments.createMap();
        String msg = "";
        String str = data.getExtras().getString("pay_result");
        if (str.equalsIgnoreCase("success")) {
            if (data.hasExtra("result_data")) {
                String result = data.getExtras().getString("result_data");
                try {
                    JSONObject resultJson = new JSONObject(result);
                    String sign = resultJson.getString("sign");
                    String dataOrg = resultJson.getString("data");
                    response.putString("sign", sign);
                    response.putString("data", dataOrg);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            msg = "\u652f\u4ed8\u6210\u529f\uff01";
        } else if (str.equalsIgnoreCase("fail")) {
            msg = "\u652f\u4ed8\u5931\u8d25\uff01";
        } else if (str.equalsIgnoreCase("cancel")) {
            msg = "\u7528\u6237\u53d6\u6d88\u4e86\u652f\u4ed8";
        }
        response.putString("pay_result", str);
        response.putString("msg", msg);
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("UnionPayResponse", (Object)response);
    }

    public void onNewIntent(Intent intent) {
    }

    @ReactMethod
    public void startPay(String tn, String mode) {
        UPPayAssistEx.startPay((Context)this.getCurrentActivity(), null, null, (String)tn, (String)mode);
    }

    @ReactMethod
    private void payAliPayMiniPro(String appPayRequest) {
        UnifyPayRequest msg = new UnifyPayRequest();
        msg.payChannel = "04";
        msg.payData = appPayRequest;
        UnifyPayPlugin.getInstance((Context)this.getCurrentActivity()).sendPayRequest(msg);
    }

    @ReactMethod
    public void startSEPay(String tn, String mode, String seType) {
        UPPayAssistEx.startSEPay((Context)this.getCurrentActivity(), null, null, (String)tn, (String)mode, (String)seType);
    }

    @ReactMethod
    public void getSEPayInfo(final Promise promise) {
        UPPayAssistEx.getSEPayInfo((Context)this.reactContext, (UPQuerySEPayInfoCallback)new UPQuerySEPayInfoCallback(){

            public void onResult(String SEName, String seType, int cardNumbers, Bundle reserved) {
                WritableMap response = Arguments.createMap();
                response.putString("SEName", SEName);
                response.putString("seType", seType);
                response.putInt("cardNumbers", cardNumbers);
                response.putMap("reserved", (ReadableMap)Arguments.fromBundle((Bundle)reserved));
                promise.resolve((Object)response);
            }

            public void onError(String SEName, String seType, String errorCode, String errorDesc) {
                if (errorDesc == null) {
                    if (errorCode.equals(UPSEInfoResp.ERROR_NOT_SUPPORT)) {
                        errorDesc = "\u786c\u4ef6\u4e0d\u652f\u6301 XXpay";
                    } else if (errorCode.equals(UPSEInfoResp.ERROR_NOT_READY)) {
                        errorDesc = "\u672a\u5f00\u901a XXpay";
                    } else if (errorCode.equals(UPSEInfoResp.ERROR_NONE)) {
                        errorDesc = "\u53ef\u7528\u5361\u6570\u4e3a0";
                    } else if (errorCode.equals(UPSEInfoResp.ERROR_TSM_UNINSTALLED)) {
                        errorDesc = "\u68c0\u6d4b\u672a\u5b89\u88c5 TSM \u63a7\u4ef6";
                    } else if (errorCode.equals(UPSEInfoResp.ERROR_TIMEOUT)) {
                        errorDesc = "\u63a5\u53e3\u8d85\u65f6";
                    }
                }
                WritableMap response = Arguments.createMap();
                response.putString("SEName", SEName);
                response.putString("seType", seType);
                response.putString("errorCode", errorCode);
                response.putString("errorDesc", errorDesc);
                promise.reject(errorCode, errorDesc, response);
            }
        });
    }

    @ReactMethod
    public void checkWalletInstalled(Promise promise) {
        boolean res = UPPayAssistEx.checkWalletInstalled((Context)this.getCurrentActivity());
        promise.resolve((Object)res);
    }
}

