/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.CoreModulesPackage;
import com.facebook.react.LifecycleState;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.CatalystInstanceImpl;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSCJavaScriptExecutor;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptModulesConfig;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ProxyJavaScriptExecutor;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.bridge.queue.CatalystQueueConfigurationSpec;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.devsupport.ReactInstanceDevCommandsHandler;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.AppRegistry;
import com.facebook.react.uimanager.ReactNative;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.soloader.SoLoader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class ReactInstanceManagerImpl
extends ReactInstanceManager {
    private final List<ReactRootView> mAttachedRootViews = new ArrayList<ReactRootView>();
    private LifecycleState mLifecycleState;
    private boolean mIsContextInitAsyncTaskRunning;
    @Nullable
    private ReactContextInitParams mPendingReactContextInitParams;
    @Nullable
    private String mJSBundleFile;
    @Nullable
    private final String mJSMainModuleName;
    private final List<ReactPackage> mPackages;
    private final DevSupportManager mDevSupportManager;
    private final boolean mUseDeveloperSupport;
    @Nullable
    private final NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    @Nullable
    private volatile ReactContext mCurrentReactContext;
    private final Context mApplicationContext;
    @Nullable
    private DefaultHardwareBackBtnHandler mDefaultBackButtonImpl;
    private String mSourceUrl;
    @Nullable
    private Activity mCurrentActivity;
    private volatile boolean mHasStartedCreatingInitialContext = false;
    private final ReactInstanceDevCommandsHandler mDevInterface = new ReactInstanceDevCommandsHandler(){

        @Override
        public void onReloadWithJSDebugger(JavaJSExecutor jsExecutor) {
            ReactInstanceManagerImpl.this.onReloadWithJSDebugger(jsExecutor);
        }

        @Override
        public void onJSBundleLoadedFromServer() {
            ReactInstanceManagerImpl.this.onJSBundleLoadedFromServer();
        }

        @Override
        public void toggleElementInspector() {
            ReactInstanceManagerImpl.this.toggleElementInspector();
        }
    };
    private final DefaultHardwareBackBtnHandler mBackBtnHandler = new DefaultHardwareBackBtnHandler(){

        @Override
        public void invokeDefaultOnBackPressed() {
            ReactInstanceManagerImpl.this.invokeDefaultOnBackPressed();
        }
    };

    ReactInstanceManagerImpl(Context applicationContext, @Nullable String jsBundleFile, @Nullable String jsMainModuleName, List<ReactPackage> packages, boolean useDeveloperSupport, @Nullable NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener, LifecycleState initialLifecycleState) {
        ReactInstanceManagerImpl.initializeSoLoaderIfNecessary(applicationContext);
        this.mApplicationContext = applicationContext;
        this.mJSBundleFile = jsBundleFile;
        this.mJSMainModuleName = jsMainModuleName;
        this.mPackages = packages;
        this.mUseDeveloperSupport = useDeveloperSupport;
        this.mDevSupportManager = new DevSupportManager(applicationContext, this.mDevInterface, this.mJSMainModuleName, useDeveloperSupport);
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        this.mLifecycleState = initialLifecycleState;
    }

    @Override
    public DevSupportManager getDevSupportManager() {
        return this.mDevSupportManager;
    }

    private static void initializeSoLoaderIfNecessary(Context applicationContext) {
        SoLoader.init(applicationContext, false);
    }

    @Override
    public void createReactContextInBackground() {
        Assertions.assertCondition((!this.mHasStartedCreatingInitialContext ? 1 : 0) != 0, (String)"createReactContextInBackground should only be called when creating the react application for the first time. When reloading JS, e.g. from a new file, explicitlyuse recreateReactContextInBackground");
        this.mHasStartedCreatingInitialContext = true;
        this.recreateReactContextInBackgroundInner();
    }

    public void recreateReactContextInBackground() {
        Assertions.assertCondition((boolean)this.mHasStartedCreatingInitialContext, (String)"recreateReactContextInBackground should only be called after the initial createReactContextInBackground call.");
        this.recreateReactContextInBackgroundInner();
    }

    private void recreateReactContextInBackgroundInner() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport && this.mJSMainModuleName != null) {
            if (this.mDevSupportManager.hasUpToDateJSBundleInCache()) {
                this.onJSBundleLoadedFromServer();
            } else if (this.mJSBundleFile == null) {
                this.mDevSupportManager.handleReloadJS();
            } else {
                this.mDevSupportManager.isPackagerRunning(new DevServerHelper.PackagerStatusCallback(){

                    @Override
                    public void onPackagerStatusFetched(final boolean packagerIsRunning) {
                        UiThreadUtil.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (packagerIsRunning) {
                                    ReactInstanceManagerImpl.this.mDevSupportManager.handleReloadJS();
                                } else {
                                    ReactInstanceManagerImpl.this.recreateReactContextInBackgroundFromBundleFile();
                                }
                            }
                        });
                    }
                });
            }
            return;
        }
        this.recreateReactContextInBackgroundFromBundleFile();
    }

    private void recreateReactContextInBackgroundFromBundleFile() {
        this.recreateReactContextInBackground(new JSCJavaScriptExecutor(), JSBundleLoader.createFileLoader(this.mApplicationContext, this.mJSBundleFile));
    }

    @Override
    public boolean hasStartedCreatingInitialContext() {
        return this.mHasStartedCreatingInitialContext;
    }

    @Override
    public void onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = this.mCurrentReactContext;
        if (this.mCurrentReactContext == null) {
            FLog.w((String)"React", (String)"Instance detached from instance manager");
            this.invokeDefaultOnBackPressed();
        } else {
            DeviceEventManagerModule deviceEventManagerModule = ((ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)))).getNativeModule(DeviceEventManagerModule.class);
            deviceEventManagerModule.emitHardwareBackPressed();
        }
    }

    private void invokeDefaultOnBackPressed() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDefaultBackButtonImpl != null) {
            this.mDefaultBackButtonImpl.invokeDefaultOnBackPressed();
        }
    }

    private void toggleElementInspector() {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("toggleElementInspector", null);
        }
    }

    @Override
    public void onPause() {
        UiThreadUtil.assertOnUiThread();
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
        this.mDefaultBackButtonImpl = null;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.mCurrentActivity = null;
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onPause();
        }
    }

    @Override
    public void onResume(Activity activity, DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        UiThreadUtil.assertOnUiThread();
        this.mLifecycleState = LifecycleState.RESUMED;
        this.mDefaultBackButtonImpl = defaultBackButtonImpl;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(true);
        }
        this.mCurrentActivity = activity;
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onResume(activity);
        }
    }

    @Override
    public void onDestroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onDestroy();
            this.mCurrentReactContext = null;
            this.mHasStartedCreatingInitialContext = false;
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void showDevOptionsDialog() {
        UiThreadUtil.assertOnUiThread();
        this.mDevSupportManager.showDevOptionsDialog();
    }

    @Override
    public String getSourceUrl() {
        return (String)Assertions.assertNotNull((Object)this.mSourceUrl);
    }

    @Override
    public void attachMeasuredRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        this.mAttachedRootViews.add(rootView);
        if (!this.mIsContextInitAsyncTaskRunning && this.mCurrentReactContext != null) {
            this.attachMeasuredRootViewToInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    @Override
    public void detachRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        if (this.mAttachedRootViews.remove(rootView) && this.mCurrentReactContext != null && this.mCurrentReactContext.hasActiveCatalystInstance()) {
            this.detachViewFromInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    @Override
    public List<ViewManager> createAllViewManagers(ReactApplicationContext catalystApplicationContext) {
        ArrayList<ViewManager> allViewManagers = new ArrayList<ViewManager>();
        for (ReactPackage reactPackage : this.mPackages) {
            allViewManagers.addAll(reactPackage.createViewManagers(catalystApplicationContext));
        }
        return allViewManagers;
    }

    @Override
    @Nullable
    @VisibleForTesting
    public ReactContext getCurrentReactContext() {
        return this.mCurrentReactContext;
    }

    private void onReloadWithJSDebugger(JavaJSExecutor jsExecutor) {
        this.recreateReactContextInBackground(new ProxyJavaScriptExecutor(jsExecutor), JSBundleLoader.createRemoteDebuggerBundleLoader(this.mDevSupportManager.getJSBundleURLForRemoteDebugging()));
    }

    private void onJSBundleLoadedFromServer() {
        this.recreateReactContextInBackground(new JSCJavaScriptExecutor(), JSBundleLoader.createCachedBundleFromNetworkLoader(this.mDevSupportManager.getSourceUrl(), this.mDevSupportManager.getDownloadedJSBundleFile()));
    }

    private void recreateReactContextInBackground(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        UiThreadUtil.assertOnUiThread();
        ReactContextInitParams initParams = new ReactContextInitParams(jsExecutor, jsBundleLoader);
        if (!this.mIsContextInitAsyncTaskRunning) {
            ReactContextInitAsyncTask initTask = new ReactContextInitAsyncTask();
            initTask.execute(new ReactContextInitParams[]{initParams});
            this.mIsContextInitAsyncTaskRunning = true;
        } else {
            this.mPendingReactContextInitParams = initParams;
        }
    }

    private void setupReactContext(ReactApplicationContext reactContext) {
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((this.mCurrentReactContext == null ? 1 : 0) != 0);
        this.mCurrentReactContext = (ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)));
        CatalystInstance catalystInstance = (CatalystInstance)Assertions.assertNotNull((Object)reactContext.getCatalystInstance());
        catalystInstance.initialize();
        this.mDevSupportManager.onNewReactContextCreated(reactContext);
        this.moveReactContextToCurrentLifecycleState(reactContext);
        for (ReactRootView rootView : this.mAttachedRootViews) {
            this.attachMeasuredRootViewToInstance(rootView, catalystInstance);
        }
    }

    private void attachMeasuredRootViewToInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        UiThreadUtil.assertOnUiThread();
        rootView.removeAllViews();
        rootView.setId(-1);
        UIManagerModule uiManagerModule = catalystInstance.getNativeModule(UIManagerModule.class);
        int rootTag = uiManagerModule.addMeasuredRootView(rootView);
        Bundle launchOptions = rootView.getLaunchOptions();
        WritableMap initialProps = launchOptions != null ? Arguments.fromBundle(launchOptions) : Arguments.createMap();
        String jsAppModuleName = rootView.getJSModuleName();
        WritableNativeMap appParams = new WritableNativeMap();
        appParams.putDouble("rootTag", rootTag);
        appParams.putMap("initialProps", initialProps);
        catalystInstance.getJSModule(AppRegistry.class).runApplication(jsAppModuleName, appParams);
    }

    private void detachViewFromInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        UiThreadUtil.assertOnUiThread();
        catalystInstance.getJSModule(ReactNative.class).unmountComponentAtNodeAndRemoveContainer(rootView.getId());
    }

    private void tearDownReactContext(ReactContext reactContext) {
        UiThreadUtil.assertOnUiThread();
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onPause();
        }
        for (ReactRootView rootView : this.mAttachedRootViews) {
            this.detachViewFromInstance(rootView, reactContext.getCatalystInstance());
        }
        reactContext.onDestroy();
        this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
    }

    private ReactApplicationContext createReactContext(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        FLog.i((String)"React", (String)"Creating react context.");
        this.mSourceUrl = jsBundleLoader.getSourceUrl();
        NativeModuleRegistry.Builder nativeRegistryBuilder = new NativeModuleRegistry.Builder();
        JavaScriptModulesConfig.Builder jsModulesBuilder = new JavaScriptModulesConfig.Builder();
        ReactApplicationContext reactContext = new ReactApplicationContext(this.mApplicationContext);
        if (this.mUseDeveloperSupport) {
            reactContext.setNativeModuleCallExceptionHandler(this.mDevSupportManager);
        }
        CoreModulesPackage coreModulesPackage = new CoreModulesPackage(this, this.mBackBtnHandler);
        this.processPackage(coreModulesPackage, reactContext, nativeRegistryBuilder, jsModulesBuilder);
        for (ReactPackage reactPackage : this.mPackages) {
            this.processPackage(reactPackage, reactContext, nativeRegistryBuilder, jsModulesBuilder);
        }
        CatalystInstanceImpl.Builder catalystInstanceBuilder = new CatalystInstanceImpl.Builder().setCatalystQueueConfigurationSpec(CatalystQueueConfigurationSpec.createDefault()).setJSExecutor(jsExecutor).setRegistry(nativeRegistryBuilder.build()).setJSModulesConfig(jsModulesBuilder.build()).setJSBundleLoader(jsBundleLoader).setNativeModuleCallExceptionHandler(this.mDevSupportManager);
        CatalystInstanceImpl catalystInstance = catalystInstanceBuilder.build();
        if (this.mBridgeIdleDebugListener != null) {
            catalystInstance.addBridgeIdleDebugListener(this.mBridgeIdleDebugListener);
        }
        reactContext.initializeWithInstance(catalystInstance);
        catalystInstance.runJSBundle();
        return reactContext;
    }

    private void processPackage(ReactPackage reactPackage, ReactApplicationContext reactContext, NativeModuleRegistry.Builder nativeRegistryBuilder, JavaScriptModulesConfig.Builder jsModulesBuilder) {
        for (NativeModule nativeModule : reactPackage.createNativeModules(reactContext)) {
            nativeRegistryBuilder.add(nativeModule);
        }
        for (Class clazz : reactPackage.createJSModules()) {
            jsModulesBuilder.add(clazz);
        }
    }

    private void moveReactContextToCurrentLifecycleState(ReactApplicationContext reactContext) {
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onResume(this.mCurrentActivity);
        }
    }

    private final class ReactContextInitAsyncTask
    extends AsyncTask<ReactContextInitParams, Void, ReactApplicationContext> {
        private ReactContextInitAsyncTask() {
        }

        protected void onPreExecute() {
            if (ReactInstanceManagerImpl.this.mCurrentReactContext != null) {
                ReactInstanceManagerImpl.this.tearDownReactContext(ReactInstanceManagerImpl.this.mCurrentReactContext);
                ReactInstanceManagerImpl.this.mCurrentReactContext = null;
            }
        }

        protected ReactApplicationContext doInBackground(ReactContextInitParams ... params) {
            Assertions.assertCondition((params != null && params.length > 0 && params[0] != null ? 1 : 0) != 0);
            return ReactInstanceManagerImpl.this.createReactContext(params[0].getJsExecutor(), params[0].getJsBundleLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(ReactApplicationContext reactContext) {
            try {
                ReactInstanceManagerImpl.this.setupReactContext(reactContext);
            }
            finally {
                ReactInstanceManagerImpl.this.mIsContextInitAsyncTaskRunning = false;
            }
            if (ReactInstanceManagerImpl.this.mPendingReactContextInitParams != null) {
                ReactInstanceManagerImpl.this.recreateReactContextInBackground(ReactInstanceManagerImpl.this.mPendingReactContextInitParams.getJsExecutor(), ReactInstanceManagerImpl.this.mPendingReactContextInitParams.getJsBundleLoader());
                ReactInstanceManagerImpl.this.mPendingReactContextInitParams = null;
            }
        }
    }

    private class ReactContextInitParams {
        private final JavaScriptExecutor mJsExecutor;
        private final JSBundleLoader mJsBundleLoader;

        public ReactContextInitParams(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
            this.mJsExecutor = (JavaScriptExecutor)Assertions.assertNotNull((Object)jsExecutor);
            this.mJsBundleLoader = (JSBundleLoader)Assertions.assertNotNull((Object)jsBundleLoader);
        }

        public JavaScriptExecutor getJsExecutor() {
            return this.mJsExecutor;
        }

        public JSBundleLoader getJsBundleLoader() {
            return this.mJsBundleLoader;
        }
    }
}

