/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.soloader.SoLoader;

@DoNotStrip
public class WritableNativeMap
extends ReadableNativeMap
implements WritableMap {
    @Override
    public native void putBoolean(String var1, boolean var2);

    @Override
    public native void putDouble(String var1, double var2);

    @Override
    public native void putInt(String var1, int var2);

    @Override
    public native void putString(String var1, String var2);

    @Override
    public native void putNull(String var1);

    @Override
    public void putMap(String key, WritableMap value) {
        Assertions.assertCondition((value == null || value instanceof WritableNativeMap ? 1 : 0) != 0, (String)"Illegal type provided");
        this.putNativeMap(key, (WritableNativeMap)value);
    }

    @Override
    public void putArray(String key, WritableArray value) {
        Assertions.assertCondition((value == null || value instanceof WritableNativeArray ? 1 : 0) != 0, (String)"Illegal type provided");
        this.putNativeArray(key, (WritableNativeArray)value);
    }

    @Override
    public void merge(ReadableMap source) {
        Assertions.assertCondition((boolean)(source instanceof ReadableNativeMap), (String)"Illegal type provided");
        this.mergeNativeMap((ReadableNativeMap)source);
    }

    private native void putNativeMap(String var1, WritableNativeMap var2);

    private native void putNativeArray(String var1, WritableNativeArray var2);

    private native void mergeNativeMap(ReadableNativeMap var1);

    static {
        SoLoader.loadLibrary("reactnativejni");
    }
}

