/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Looper;
import com.facebook.common.logging.FLog;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadHandler;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.common.futures.SimpleSettableFuture;

@DoNotStrip
class MessageQueueThreadImpl
implements MessageQueueThread {
    private final String mName;
    private final Looper mLooper;
    private final MessageQueueThreadHandler mHandler;
    private final String mAssertionErrorMessage;
    private volatile boolean mIsFinished = false;

    private MessageQueueThreadImpl(String name, Looper looper, QueueThreadExceptionHandler exceptionHandler) {
        this.mName = name;
        this.mLooper = looper;
        this.mHandler = new MessageQueueThreadHandler(looper, exceptionHandler);
        this.mAssertionErrorMessage = "Expected to be called from the '" + this.getName() + "' thread!";
    }

    @Override
    @DoNotStrip
    public void runOnQueue(Runnable runnable) {
        if (this.mIsFinished) {
            FLog.w((String)"React", (String)("Tried to enqueue runnable on already finished thread: '" + this.getName() + "... dropping Runnable."));
        }
        this.mHandler.post(runnable);
    }

    @Override
    public boolean isOnThread() {
        return this.mLooper.getThread() == Thread.currentThread();
    }

    @Override
    public void assertIsOnThread() {
        SoftAssertions.assertCondition(this.isOnThread(), this.mAssertionErrorMessage);
    }

    public void quitSynchronous() {
        this.mIsFinished = true;
        this.mLooper.quit();
        if (this.mLooper.getThread() != Thread.currentThread()) {
            try {
                this.mLooper.getThread().join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Got interrupted waiting to join thread " + this.mName);
            }
        }
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    public String getName() {
        return this.mName;
    }

    public static MessageQueueThreadImpl create(MessageQueueThreadSpec spec, QueueThreadExceptionHandler exceptionHandler) {
        switch (spec.getThreadType()) {
            case MAIN_UI: {
                return MessageQueueThreadImpl.createForMainThread(spec.getName(), exceptionHandler);
            }
            case NEW_BACKGROUND: {
                return MessageQueueThreadImpl.startNewBackgroundThread(spec.getName(), exceptionHandler);
            }
        }
        throw new RuntimeException("Unknown thread type: " + (Object)((Object)spec.getThreadType()));
    }

    private static MessageQueueThreadImpl createForMainThread(String name, QueueThreadExceptionHandler exceptionHandler) {
        Looper mainLooper = Looper.getMainLooper();
        return new MessageQueueThreadImpl(name, mainLooper, exceptionHandler);
    }

    private static MessageQueueThreadImpl startNewBackgroundThread(String name, QueueThreadExceptionHandler exceptionHandler) {
        final SimpleSettableFuture simpleSettableFuture = new SimpleSettableFuture();
        Thread bgThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                simpleSettableFuture.set(Looper.myLooper());
                Looper.loop();
            }
        }, "mqt_" + name);
        bgThread.start();
        return new MessageQueueThreadImpl(name, (Looper)simpleSettableFuture.get(5000L), exceptionHandler);
    }
}

