/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.DebugServerException;
import com.facebook.react.devsupport.DevInternalSettings;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class DevServerHelper {
    public static final String RELOAD_APP_EXTRA_JS_PROXY = "jsproxy";
    private static final String RELOAD_APP_ACTION_SUFFIX = ".RELOAD_APP_ACTION";
    private static final String EMULATOR_LOCALHOST = "10.0.2.2:8081";
    private static final String GENYMOTION_LOCALHOST = "10.0.3.2:8081";
    private static final String DEVICE_LOCALHOST = "localhost:8081";
    private static final String BUNDLE_URL_FORMAT = "http://%s/%s.bundle?platform=android&dev=%s";
    private static final String SOURCE_MAP_URL_FORMAT = "http://%s/%s.bundle?platform=android&dev=%s".replaceFirst("\\.bundle", ".map");
    private static final String LAUNCH_CHROME_DEVTOOLS_COMMAND_URL_FORMAT = "http://%s/launch-chrome-devtools";
    private static final String ONCHANGE_ENDPOINT_URL_FORMAT = "http://%s/onchange";
    private static final String WEBSOCKET_PROXY_URL_FORMAT = "ws://%s/debugger-proxy";
    private static final String PACKAGER_STATUS_URL_FORMAT = "http://%s/status";
    private static final String PACKAGER_OK_STATUS = "packager-status:running";
    private static final int LONG_POLL_KEEP_ALIVE_DURATION_MS = 120000;
    private static final int LONG_POLL_FAILURE_DELAY_MS = 5000;
    private static final int HTTP_CONNECT_TIMEOUT_MS = 5000;
    private final DevInternalSettings mSettings;
    private final OkHttpClient mClient;
    private final Handler mRestartOnChangePollingHandler;
    private boolean mOnChangePollingEnabled;
    @Nullable
    private OkHttpClient mOnChangePollingClient;
    @Nullable
    private OnServerContentChangeListener mOnServerContentChangeListener;

    public DevServerHelper(DevInternalSettings settings) {
        this.mSettings = settings;
        this.mClient = new OkHttpClient();
        this.mClient.setConnectTimeout(5000L, TimeUnit.MILLISECONDS);
        this.mClient.setReadTimeout(0L, TimeUnit.MILLISECONDS);
        this.mClient.setWriteTimeout(0L, TimeUnit.MILLISECONDS);
        this.mRestartOnChangePollingHandler = new Handler();
    }

    public static String getReloadAppAction(Context context) {
        return context.getPackageName() + RELOAD_APP_ACTION_SUFFIX;
    }

    public String getWebsocketProxyURL() {
        return String.format(Locale.US, WEBSOCKET_PROXY_URL_FORMAT, this.getDebugServerHost());
    }

    private static String getHostForJSProxy() {
        return DEVICE_LOCALHOST;
    }

    private boolean getDevMode() {
        return this.mSettings.isJSDevModeEnabled();
    }

    private String getDebugServerHost() {
        String hostFromSettings = this.mSettings.getDebugServerHost();
        if (!TextUtils.isEmpty((CharSequence)hostFromSettings)) {
            return (String)Assertions.assertNotNull((Object)hostFromSettings);
        }
        if (this.isRunningOnGenymotion()) {
            return GENYMOTION_LOCALHOST;
        }
        if (this.isRunningOnStockEmulator()) {
            return EMULATOR_LOCALHOST;
        }
        FLog.w((String)"React", (String)"You seem to be running on device. Run 'adb reverse tcp:8081 tcp:8081' to forward the debug server's port to the device.");
        return DEVICE_LOCALHOST;
    }

    private boolean isRunningOnGenymotion() {
        return Build.FINGERPRINT.contains("vbox");
    }

    private boolean isRunningOnStockEmulator() {
        return Build.FINGERPRINT.contains("generic");
    }

    private static String createBundleURL(String host, String jsModulePath, boolean devMode) {
        return String.format(Locale.US, BUNDLE_URL_FORMAT, host, jsModulePath, devMode);
    }

    public void downloadBundleFromURL(final BundleDownloadCallback callback, String jsModulePath, final File outputFile) {
        String bundleURL = DevServerHelper.createBundleURL(this.getDebugServerHost(), jsModulePath, this.getDevMode());
        Request request = new Request.Builder().url(bundleURL).build();
        Call call = this.mClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                callback.onFailure(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Response response) throws IOException {
                if (!response.isSuccessful()) {
                    String body = response.body().string();
                    DebugServerException debugServerException = DebugServerException.parse(body);
                    if (debugServerException != null) {
                        callback.onFailure(debugServerException);
                    } else {
                        callback.onFailure(new IOException("Unexpected response code: " + response.code()));
                    }
                    return;
                }
                try (Sink output = null;){
                    output = Okio.sink((File)outputFile);
                    Okio.buffer((Source)response.body().source()).readAll(output);
                    callback.onSuccess();
                }
            }
        });
    }

    public void isPackagerRunning(final PackagerStatusCallback callback) {
        String statusURL = DevServerHelper.createPackagerStatusURL(this.getDebugServerHost());
        Request request = new Request.Builder().url(statusURL).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                FLog.e((String)"React", (String)"IOException requesting status from packager", (Throwable)e);
                callback.onPackagerStatusFetched(false);
            }

            public void onResponse(Response response) throws IOException {
                if (!response.isSuccessful()) {
                    FLog.e((String)"React", (String)("Got non-success http code from packager when requesting status: " + response.code()));
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                ResponseBody body = response.body();
                if (body == null) {
                    FLog.e((String)"React", (String)"Got null body response from packager when requesting status");
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                if (!DevServerHelper.PACKAGER_OK_STATUS.equals(body.string())) {
                    FLog.e((String)"React", (String)("Got unexpected response from packager when requesting status: " + body.string()));
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                callback.onPackagerStatusFetched(true);
            }
        });
    }

    private static String createPackagerStatusURL(String host) {
        return String.format(Locale.US, PACKAGER_STATUS_URL_FORMAT, host);
    }

    public void stopPollingOnChangeEndpoint() {
        this.mOnChangePollingEnabled = false;
        this.mRestartOnChangePollingHandler.removeCallbacksAndMessages(null);
        if (this.mOnChangePollingClient != null) {
            this.mOnChangePollingClient.cancel((Object)this);
            this.mOnChangePollingClient = null;
        }
        this.mOnServerContentChangeListener = null;
    }

    public void startPollingOnChangeEndpoint(OnServerContentChangeListener onServerContentChangeListener) {
        if (this.mOnChangePollingEnabled) {
            return;
        }
        this.mOnChangePollingEnabled = true;
        this.mOnServerContentChangeListener = onServerContentChangeListener;
        this.mOnChangePollingClient = new OkHttpClient();
        this.mOnChangePollingClient.setConnectionPool(new ConnectionPool(1, 120000L)).setConnectTimeout(5000L, TimeUnit.MILLISECONDS);
        this.enqueueOnChangeEndpointLongPolling();
    }

    private void handleOnChangePollingResponse(boolean didServerContentChanged) {
        if (this.mOnChangePollingEnabled) {
            if (didServerContentChanged) {
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (DevServerHelper.this.mOnServerContentChangeListener != null) {
                            DevServerHelper.this.mOnServerContentChangeListener.onServerContentChanged();
                        }
                    }
                });
            }
            this.enqueueOnChangeEndpointLongPolling();
        }
    }

    private void enqueueOnChangeEndpointLongPolling() {
        Request request = new Request.Builder().url(this.createOnChangeEndpointUrl()).tag((Object)this).build();
        ((OkHttpClient)Assertions.assertNotNull((Object)this.mOnChangePollingClient)).newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DevServerHelper.this.mOnChangePollingEnabled) {
                    FLog.d((String)"React", (String)"Error while requesting /onchange endpoint", (Throwable)e);
                    DevServerHelper.this.mRestartOnChangePollingHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DevServerHelper.this.handleOnChangePollingResponse(false);
                        }
                    }, 5000L);
                }
            }

            public void onResponse(Response response) throws IOException {
                DevServerHelper.this.handleOnChangePollingResponse(response.code() == 205);
            }
        });
    }

    private String createOnChangeEndpointUrl() {
        return String.format(Locale.US, ONCHANGE_ENDPOINT_URL_FORMAT, this.getDebugServerHost());
    }

    private String createLaunchChromeDevtoolsCommandUrl() {
        return String.format(LAUNCH_CHROME_DEVTOOLS_COMMAND_URL_FORMAT, this.getDebugServerHost());
    }

    public void launchChromeDevtools() {
        Request request = new Request.Builder().url(this.createLaunchChromeDevtoolsCommandUrl()).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
            }

            public void onResponse(Response response) throws IOException {
            }
        });
    }

    public String getSourceMapUrl(String mainModuleName) {
        return String.format(Locale.US, SOURCE_MAP_URL_FORMAT, this.getDebugServerHost(), mainModuleName, this.getDevMode());
    }

    public String getSourceUrl(String mainModuleName) {
        return String.format(Locale.US, BUNDLE_URL_FORMAT, this.getDebugServerHost(), mainModuleName, this.getDevMode());
    }

    public String getJSBundleURLForRemoteDebugging(String mainModuleName) {
        return DevServerHelper.createBundleURL(DevServerHelper.getHostForJSProxy(), mainModuleName, this.getDevMode());
    }

    public static interface PackagerStatusCallback {
        public void onPackagerStatusFetched(boolean var1);
    }

    public static interface OnServerContentChangeListener {
        public void onServerContentChanged();
    }

    public static interface BundleDownloadCallback {
        public void onSuccess();

        public void onFailure(Exception var1);
    }
}

