/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.intent;

import android.content.Intent;
import android.net.Uri;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;

public class IntentModule
extends ReactContextBaseJavaModule {
    public IntentModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "IntentAndroid";
    }

    @ReactMethod
    public void openURL(String url) {
        if (url == null || url.isEmpty()) {
            throw new JSApplicationIllegalArgumentException("Invalid URL: " + url);
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            this.getReactApplicationContext().startActivity(intent);
        }
        catch (Exception e) {
            throw new JSApplicationIllegalArgumentException("Could not open URL '" + url + "': " + e.getMessage());
        }
    }

    @ReactMethod
    public void canOpenURL(String url, Callback callback) {
        if (url == null || url.isEmpty()) {
            throw new JSApplicationIllegalArgumentException("Invalid URL: " + url);
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            boolean canOpen = intent.resolveActivity(this.getReactApplicationContext().getPackageManager()) != null;
            callback.invoke(canOpen);
        }
        catch (Exception e) {
            throw new JSApplicationIllegalArgumentException("Could not check if URL '" + url + "' can be opened: " + e.getMessage());
        }
    }
}

