/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import com.facebook.react.bridge.ReactContext;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.squareup.okhttp.OkHttpClient;
import java.net.CookieHandler;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class OkHttpClientProvider {
    @Nullable
    private static OkHttpClient sClient;
    private static ForwardingCookieHandler sCookieHandler;

    public static OkHttpClient getOkHttpClient() {
        if (sClient == null) {
            sClient = OkHttpClientProvider.createClient();
        }
        return sClient;
    }

    public static OkHttpClient getCookieAwareOkHttpClient(ReactContext context) {
        if (sCookieHandler == null) {
            sCookieHandler = new ForwardingCookieHandler(context);
            OkHttpClientProvider.getOkHttpClient().setCookieHandler((CookieHandler)sCookieHandler);
        }
        return OkHttpClientProvider.getOkHttpClient();
    }

    private static OkHttpClient createClient() {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(0L, TimeUnit.MILLISECONDS);
        client.setReadTimeout(0L, TimeUnit.MILLISECONDS);
        client.setWriteTimeout(0L, TimeUnit.MILLISECONDS);
        return client;
    }
}

