/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.SparseBooleanArray;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ShadowNodeRegistry;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewProps;
import javax.annotation.Nullable;

public class NativeViewHierarchyOptimizer {
    private static final boolean ENABLED = true;
    private final UIViewOperationQueue mUIViewOperationQueue;
    private final ShadowNodeRegistry mShadowNodeRegistry;
    private final SparseBooleanArray mTagsWithLayoutVisited = new SparseBooleanArray();

    public NativeViewHierarchyOptimizer(UIViewOperationQueue uiViewOperationQueue, ShadowNodeRegistry shadowNodeRegistry) {
        this.mUIViewOperationQueue = uiViewOperationQueue;
        this.mShadowNodeRegistry = shadowNodeRegistry;
    }

    public void handleCreateView(ReactShadowNode node, int rootViewTag, @Nullable CatalystStylesDiffMap initialProps) {
        boolean isLayoutOnly = node.getViewClass().equals("RCTView") && NativeViewHierarchyOptimizer.isLayoutOnlyAndCollapsable(initialProps);
        node.setIsLayoutOnly(isLayoutOnly);
        if (!isLayoutOnly) {
            this.mUIViewOperationQueue.enqueueCreateView(rootViewTag, node.getReactTag(), node.getViewClass(), initialProps);
        }
    }

    public void handleDropViews(int[] viewTagsToDrop, int length) {
        this.mUIViewOperationQueue.enqueueDropViews(viewTagsToDrop, length);
    }

    public static void handleRemoveNode(ReactShadowNode node) {
        node.removeAllNativeChildren();
    }

    public void handleUpdateView(ReactShadowNode node, String className, CatalystStylesDiffMap props) {
        boolean needsToLeaveLayoutOnly;
        boolean bl = needsToLeaveLayoutOnly = node.isLayoutOnly() && !NativeViewHierarchyOptimizer.isLayoutOnlyAndCollapsable(props);
        if (needsToLeaveLayoutOnly) {
            this.transitionLayoutOnlyViewToNativeView(node, props);
        } else if (!node.isLayoutOnly()) {
            this.mUIViewOperationQueue.enqueueUpdateProperties(node.getReactTag(), className, props);
        }
    }

    public void handleManageChildren(ReactShadowNode nodeToManage, int[] indicesToRemove, int[] tagsToRemove, ViewAtIndex[] viewsToAdd, int[] tagsToDelete) {
        int i;
        for (i = 0; i < tagsToRemove.length; ++i) {
            int tagToRemove = tagsToRemove[i];
            boolean delete = false;
            for (int j = 0; j < tagsToDelete.length; ++j) {
                if (tagsToDelete[j] != tagToRemove) continue;
                delete = true;
                break;
            }
            ReactShadowNode nodeToRemove = this.mShadowNodeRegistry.getNode(tagToRemove);
            this.removeNodeFromParent(nodeToRemove, delete);
        }
        for (i = 0; i < viewsToAdd.length; ++i) {
            ViewAtIndex toAdd = viewsToAdd[i];
            ReactShadowNode nodeToAdd = this.mShadowNodeRegistry.getNode(toAdd.mTag);
            this.addNodeToNode(nodeToManage, nodeToAdd, toAdd.mIndex);
        }
    }

    public void handleUpdateLayout(ReactShadowNode node) {
        this.applyLayoutBase(node);
    }

    public void onBatchComplete() {
        this.mTagsWithLayoutVisited.clear();
    }

    private void addNodeToNode(ReactShadowNode parent, ReactShadowNode child, int index) {
        int indexInNativeChildren = parent.getNativeOffsetForChild(parent.getChildAt(index));
        boolean parentIsLayoutOnly = parent.isLayoutOnly();
        boolean childIsLayoutOnly = child.isLayoutOnly();
        if (!parentIsLayoutOnly && !childIsLayoutOnly) {
            this.addNonLayoutNodeToNonLayoutNode(parent, child, indexInNativeChildren);
        } else if (!childIsLayoutOnly) {
            this.addNonLayoutOnlyNodeToLayoutOnlyNode(parent, child, indexInNativeChildren);
        } else if (!parentIsLayoutOnly) {
            this.addLayoutOnlyNodeToNonLayoutOnlyNode(parent, child, indexInNativeChildren);
        } else {
            this.addLayoutOnlyNodeToLayoutOnlyNode(parent, child, indexInNativeChildren);
        }
    }

    private void removeNodeFromParent(ReactShadowNode nodeToRemove, boolean shouldDelete) {
        ReactShadowNode nativeNodeToRemoveFrom = nodeToRemove.getNativeParent();
        if (nativeNodeToRemoveFrom != null) {
            int[] nArray;
            int index = nativeNodeToRemoveFrom.indexOfNativeChild(nodeToRemove);
            nativeNodeToRemoveFrom.removeNativeChildAt(index);
            int n = nativeNodeToRemoveFrom.getReactTag();
            int[] nArray2 = new int[]{index};
            if (shouldDelete) {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = nodeToRemove.getReactTag();
            } else {
                nArray = null;
            }
            this.mUIViewOperationQueue.enqueueManageChildren(n, nArray2, null, nArray);
        } else {
            for (int i = nodeToRemove.getChildCount() - 1; i >= 0; --i) {
                this.removeNodeFromParent(nodeToRemove.getChildAt(i), shouldDelete);
            }
        }
    }

    private void addLayoutOnlyNodeToLayoutOnlyNode(ReactShadowNode parent, ReactShadowNode child, int index) {
        ReactShadowNode parentParent = parent.getParent();
        if (parentParent == null) {
            return;
        }
        int transformedIndex = index + parentParent.getNativeOffsetForChild(parent);
        if (parentParent.isLayoutOnly()) {
            this.addLayoutOnlyNodeToLayoutOnlyNode(parentParent, child, transformedIndex);
        } else {
            this.addLayoutOnlyNodeToNonLayoutOnlyNode(parentParent, child, transformedIndex);
        }
    }

    private void addNonLayoutOnlyNodeToLayoutOnlyNode(ReactShadowNode layoutOnlyNode, ReactShadowNode nonLayoutOnlyNode, int index) {
        ReactShadowNode parent = layoutOnlyNode.getParent();
        if (parent == null) {
            return;
        }
        int transformedIndex = index + parent.getNativeOffsetForChild(layoutOnlyNode);
        if (parent.isLayoutOnly()) {
            this.addNonLayoutOnlyNodeToLayoutOnlyNode(parent, nonLayoutOnlyNode, transformedIndex);
        } else {
            this.addNonLayoutNodeToNonLayoutNode(parent, nonLayoutOnlyNode, transformedIndex);
        }
    }

    private void addLayoutOnlyNodeToNonLayoutOnlyNode(ReactShadowNode nonLayoutOnlyNode, ReactShadowNode layoutOnlyNode, int index) {
        int currentIndex = index;
        for (int i = 0; i < layoutOnlyNode.getChildCount(); ++i) {
            ReactShadowNode childToAdd = layoutOnlyNode.getChildAt(i);
            Assertions.assertCondition((childToAdd.getNativeParent() == null ? 1 : 0) != 0);
            if (childToAdd.isLayoutOnly()) {
                int childCountBefore = nonLayoutOnlyNode.getNativeChildCount();
                this.addLayoutOnlyNodeToNonLayoutOnlyNode(nonLayoutOnlyNode, childToAdd, currentIndex);
                int childCountAfter = nonLayoutOnlyNode.getNativeChildCount();
                currentIndex += childCountAfter - childCountBefore;
                continue;
            }
            this.addNonLayoutNodeToNonLayoutNode(nonLayoutOnlyNode, childToAdd, currentIndex);
            ++currentIndex;
        }
    }

    private void addNonLayoutNodeToNonLayoutNode(ReactShadowNode parent, ReactShadowNode child, int index) {
        parent.addNativeChildAt(child, index);
        this.mUIViewOperationQueue.enqueueManageChildren(parent.getReactTag(), null, new ViewAtIndex[]{new ViewAtIndex(child.getReactTag(), index)}, null);
    }

    private void applyLayoutBase(ReactShadowNode node) {
        int tag = node.getReactTag();
        if (this.mTagsWithLayoutVisited.get(tag)) {
            return;
        }
        this.mTagsWithLayoutVisited.put(tag, true);
        int x = node.getScreenX();
        int y = node.getScreenY();
        for (ReactShadowNode parent = node.getParent(); parent != null && parent.isLayoutOnly(); parent = parent.getParent()) {
            x += Math.round(parent.getLayoutX());
            y += Math.round(parent.getLayoutY());
        }
        this.applyLayoutRecursive(node, x, y);
    }

    private void applyLayoutRecursive(ReactShadowNode toUpdate, int x, int y) {
        if (!toUpdate.isLayoutOnly() && toUpdate.getNativeParent() != null) {
            int tag = toUpdate.getReactTag();
            this.mUIViewOperationQueue.enqueueUpdateLayout(toUpdate.getNativeParent().getReactTag(), tag, x, y, toUpdate.getScreenWidth(), toUpdate.getScreenHeight());
            return;
        }
        for (int i = 0; i < toUpdate.getChildCount(); ++i) {
            ReactShadowNode child = toUpdate.getChildAt(i);
            int childTag = child.getReactTag();
            if (this.mTagsWithLayoutVisited.get(childTag)) continue;
            this.mTagsWithLayoutVisited.put(childTag, true);
            int childX = child.getScreenX();
            int childY = child.getScreenY();
            this.applyLayoutRecursive(child, childX += x, childY += y);
        }
    }

    private void transitionLayoutOnlyViewToNativeView(ReactShadowNode node, @Nullable CatalystStylesDiffMap props) {
        int i;
        ReactShadowNode parent = node.getParent();
        if (parent == null) {
            node.setIsLayoutOnly(false);
            return;
        }
        int childIndex = parent.indexOf(node);
        parent.removeChildAt(childIndex);
        this.removeNodeFromParent(node, false);
        node.setIsLayoutOnly(false);
        this.mUIViewOperationQueue.enqueueCreateView(node.getRootNode().getReactTag(), node.getReactTag(), node.getViewClass(), props);
        parent.addChildAt(node, childIndex);
        this.addNodeToNode(parent, node, childIndex);
        for (i = 0; i < node.getChildCount(); ++i) {
            this.addNodeToNode(node, node.getChildAt(i), i);
        }
        Assertions.assertCondition((this.mTagsWithLayoutVisited.size() == 0 ? 1 : 0) != 0);
        this.applyLayoutBase(node);
        for (i = 0; i < node.getChildCount(); ++i) {
            this.applyLayoutBase(node.getChildAt(i));
        }
        this.mTagsWithLayoutVisited.clear();
    }

    private static boolean isLayoutOnlyAndCollapsable(@Nullable CatalystStylesDiffMap props) {
        if (props == null) {
            return true;
        }
        if (props.hasKey("collapsable") && !props.getBoolean("collapsable", true)) {
            return false;
        }
        ReadableMapKeySetIterator keyIterator = props.mBackingMap.keySetIterator();
        while (keyIterator.hasNextKey()) {
            if (ViewProps.isLayoutOnly(keyIterator.nextKey())) continue;
            return false;
        }
        return true;
    }
}

