/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Spannable;
import android.text.style.ReplacementSpan;
import android.widget.TextView;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import javax.annotation.Nullable;

public class TextInlineImageSpan
extends ReplacementSpan {
    @Nullable
    private Drawable mDrawable;
    private DraweeHolder<GenericDraweeHierarchy> mDraweeHolder;
    private int mHeight;
    private Uri mUri;
    private int mWidth;
    @Nullable
    private TextView mTextView;

    public TextInlineImageSpan(Resources resources, int height, int width, @Nullable Uri uri) {
        this.mDraweeHolder = new DraweeHolder((DraweeHierarchy)GenericDraweeHierarchyBuilder.newInstance((Resources)resources).build());
        this.mHeight = height;
        this.mWidth = width;
        this.mUri = uri != null ? uri : Uri.EMPTY;
    }

    public void onDetachedFromWindow() {
        this.mDraweeHolder.onDetach();
    }

    public void onStartTemporaryDetach() {
        this.mDraweeHolder.onDetach();
    }

    public void onAttachedToWindow() {
        this.mDraweeHolder.onAttach();
    }

    public void onFinishTemporaryDetach() {
        this.mDraweeHolder.onAttach();
    }

    @Nullable
    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (fm != null) {
            fm.ascent = -this.mHeight;
            fm.descent = 0;
            fm.top = fm.ascent;
            fm.bottom = 0;
        }
        return this.mWidth;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (this.mDrawable == null) {
            ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)this.mUri).build();
            AbstractDraweeController draweeController = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setOldController(this.mDraweeHolder.getController())).setImageRequest((Object)imageRequest)).build();
            this.mDraweeHolder.setController((DraweeController)draweeController);
            this.mDrawable = this.mDraweeHolder.getTopLevelDrawable();
            this.mDrawable.setBounds(0, 0, this.mWidth, this.mHeight);
            this.mDrawable.setCallback((Drawable.Callback)this.mTextView);
        }
        canvas.save();
        int transY = bottom - this.mDrawable.getBounds().bottom;
        canvas.translate(x, (float)transY);
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    public static void possiblyUpdateInlineImageSpans(Spannable spannable, TextView view) {
        TextInlineImageSpan[] spans;
        for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])spannable.getSpans(0, spannable.length(), TextInlineImageSpan.class)) {
            span.onAttachedToWindow();
            span.mTextView = view;
        }
    }
}

