/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.viewpager;

import android.view.View;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.views.viewpager.ReactViewPager;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactViewPagerManager
extends ViewGroupManager<ReactViewPager> {
    private static final String REACT_CLASS = "AndroidViewPager";
    public static final int COMMAND_SET_PAGE = 1;
    public static final int COMMAND_SET_PAGE_WITHOUT_ANIMATION = 2;

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected ReactViewPager createViewInstance(ThemedReactContext reactContext) {
        return new ReactViewPager(reactContext);
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of("topPageScroll", MapBuilder.of("registrationName", "onPageScroll"), "topPageSelected", MapBuilder.of("registrationName", "onPageSelected"));
    }

    @Override
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("setPage", 1, "setPageWithoutAnimation", 2);
    }

    @Override
    public void receiveCommand(ReactViewPager viewPager, int commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull((Object)((Object)viewPager));
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case 1: {
                viewPager.setCurrentItemFromJs(args.getInt(0), true);
                return;
            }
            case 2: {
                viewPager.setCurrentItemFromJs(args.getInt(0), false);
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %d received by %s.", commandType, this.getClass().getSimpleName()));
    }

    @Override
    public void addView(ReactViewPager parent, View child, int index) {
        parent.addViewToAdapter(child, index);
    }

    @Override
    public int getChildCount(ReactViewPager parent) {
        return parent.getViewCountInAdapter();
    }

    @Override
    public View getChildAt(ReactViewPager parent, int index) {
        return parent.getViewFromAdapter(index);
    }

    @Override
    public void removeViewAt(ReactViewPager parent, int index) {
        parent.removeViewFromAdapter(index);
    }
}

