/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.csslayout;

import com.facebook.csslayout.CSSAlign;
import com.facebook.csslayout.CSSDirection;
import com.facebook.csslayout.CSSFlexDirection;
import com.facebook.csslayout.CSSJustify;
import com.facebook.csslayout.CSSLayoutContext;
import com.facebook.csslayout.CSSMeasureMode;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.CSSPositionType;
import com.facebook.csslayout.CSSWrap;
import com.facebook.csslayout.FloatUtil;
import com.facebook.csslayout.MeasureOutput;

public class LayoutEngine {
    private static final int CSS_FLEX_DIRECTION_COLUMN = CSSFlexDirection.COLUMN.ordinal();
    private static final int CSS_FLEX_DIRECTION_COLUMN_REVERSE = CSSFlexDirection.COLUMN_REVERSE.ordinal();
    private static final int CSS_FLEX_DIRECTION_ROW = CSSFlexDirection.ROW.ordinal();
    private static final int CSS_FLEX_DIRECTION_ROW_REVERSE = CSSFlexDirection.ROW_REVERSE.ordinal();
    private static final int CSS_POSITION_RELATIVE = CSSPositionType.RELATIVE.ordinal();
    private static final int CSS_POSITION_ABSOLUTE = CSSPositionType.ABSOLUTE.ordinal();
    private static final int[] leading = new int[]{1, 3, 0, 2};
    private static final int[] trailing = new int[]{3, 1, 2, 0};
    private static final int[] pos = new int[]{1, 3, 0, 2};
    private static final int[] dim = new int[]{1, 1, 0, 0};
    private static final int[] leadingSpacing = new int[]{1, 3, 6, 6};
    private static final int[] trailingSpacing = new int[]{3, 1, 7, 7};

    private static float boundAxis(CSSNode node, int axis, float value) {
        float min = Float.NaN;
        float max = Float.NaN;
        if (axis == CSS_FLEX_DIRECTION_COLUMN || axis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
            min = node.style.minHeight;
            max = node.style.maxHeight;
        } else if (axis == CSS_FLEX_DIRECTION_ROW || axis == CSS_FLEX_DIRECTION_ROW_REVERSE) {
            min = node.style.minWidth;
            max = node.style.maxWidth;
        }
        float boundValue = value;
        if (!Float.isNaN(max) && (double)max >= 0.0 && boundValue > max) {
            boundValue = max;
        }
        if (!Float.isNaN(min) && (double)min >= 0.0 && boundValue < min) {
            boundValue = min;
        }
        return boundValue;
    }

    private static void setDimensionFromStyle(CSSNode node, int axis) {
        float maxLayoutDimension;
        if (!Float.isNaN(node.layout.dimensions[dim[axis]])) {
            return;
        }
        if (Float.isNaN(node.style.dimensions[dim[axis]]) || (double)node.style.dimensions[dim[axis]] <= 0.0) {
            return;
        }
        node.layout.dimensions[LayoutEngine.dim[axis]] = maxLayoutDimension = Math.max(LayoutEngine.boundAxis(node, axis, node.style.dimensions[dim[axis]]), node.style.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + node.style.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + node.style.border.getWithFallback(leadingSpacing[axis], leading[axis]) + node.style.border.getWithFallback(trailingSpacing[axis], trailing[axis]));
    }

    private static float getRelativePosition(CSSNode node, int axis) {
        float lead = node.style.position[leading[axis]];
        if (!Float.isNaN(lead)) {
            return lead;
        }
        float trailingPos = node.style.position[trailing[axis]];
        return Float.isNaN(trailingPos) ? 0.0f : -trailingPos;
    }

    private static int resolveAxis(int axis, CSSDirection direction) {
        if (direction == CSSDirection.RTL) {
            if (axis == CSS_FLEX_DIRECTION_ROW) {
                return CSS_FLEX_DIRECTION_ROW_REVERSE;
            }
            if (axis == CSS_FLEX_DIRECTION_ROW_REVERSE) {
                return CSS_FLEX_DIRECTION_ROW;
            }
        }
        return axis;
    }

    private static CSSDirection resolveDirection(CSSNode node, CSSDirection parentDirection) {
        CSSDirection direction = node.style.direction;
        if (direction == CSSDirection.INHERIT) {
            direction = parentDirection == null ? CSSDirection.LTR : parentDirection;
        }
        return direction;
    }

    private static int getFlexDirection(CSSNode node) {
        return node.style.flexDirection.ordinal();
    }

    private static int getCrossFlexDirection(int axis, CSSDirection direction) {
        if (axis == CSS_FLEX_DIRECTION_COLUMN || axis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
            return LayoutEngine.resolveAxis(CSS_FLEX_DIRECTION_ROW, direction);
        }
        return CSS_FLEX_DIRECTION_COLUMN;
    }

    private static CSSAlign getAlignItem(CSSNode node, CSSNode child) {
        if (child.style.alignSelf != CSSAlign.AUTO) {
            return child.style.alignSelf;
        }
        return node.style.alignItems;
    }

    private static boolean isMeasureDefined(CSSNode node) {
        return node.isMeasureDefined();
    }

    static boolean needsRelayout(CSSNode node, float parentMaxWidth, float parentMaxHeight) {
        return node.isDirty() || !FloatUtil.floatsEqual(node.lastLayout.requestedHeight, node.layout.dimensions[1]) || !FloatUtil.floatsEqual(node.lastLayout.requestedWidth, node.layout.dimensions[0]) || !FloatUtil.floatsEqual(node.lastLayout.parentMaxWidth, parentMaxWidth) || !FloatUtil.floatsEqual(node.lastLayout.parentMaxHeight, parentMaxHeight);
    }

    static void layoutNode(CSSLayoutContext layoutContext, CSSNode node, float parentMaxWidth, float parentMaxHeight, CSSDirection parentDirection) {
        if (LayoutEngine.needsRelayout(node, parentMaxWidth, parentMaxHeight)) {
            node.lastLayout.requestedWidth = node.layout.dimensions[0];
            node.lastLayout.requestedHeight = node.layout.dimensions[1];
            node.lastLayout.parentMaxWidth = parentMaxWidth;
            node.lastLayout.parentMaxHeight = parentMaxHeight;
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                node.getChildAt((int)i).layout.resetResult();
            }
            LayoutEngine.layoutNodeImpl(layoutContext, node, parentMaxWidth, parentMaxHeight, parentDirection);
            node.lastLayout.copy(node.layout);
        } else {
            node.layout.copy(node.lastLayout);
        }
        node.markHasNewLayout();
    }

    private static void layoutNodeImpl(CSSLayoutContext layoutContext, CSSNode node, float parentMaxWidth, float parentMaxHeight, CSSDirection parentDirection) {
        int axis;
        int ii;
        CSSNode child;
        int i;
        CSSDirection direction = LayoutEngine.resolveDirection(node, parentDirection);
        int mainAxis = LayoutEngine.resolveAxis(LayoutEngine.getFlexDirection(node), direction);
        int crossAxis = LayoutEngine.getCrossFlexDirection(mainAxis, direction);
        int resolvedRowAxis = LayoutEngine.resolveAxis(CSS_FLEX_DIRECTION_ROW, direction);
        LayoutEngine.setDimensionFromStyle(node, mainAxis);
        LayoutEngine.setDimensionFromStyle(node, crossAxis);
        node.layout.direction = direction;
        int n = leading[mainAxis];
        node.layout.position[n] = node.layout.position[n] + (node.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + LayoutEngine.getRelativePosition(node, mainAxis));
        int n2 = trailing[mainAxis];
        node.layout.position[n2] = node.layout.position[n2] + (node.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + LayoutEngine.getRelativePosition(node, mainAxis));
        int n3 = leading[crossAxis];
        node.layout.position[n3] = node.layout.position[n3] + (node.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + LayoutEngine.getRelativePosition(node, crossAxis));
        int n4 = trailing[crossAxis];
        node.layout.position[n4] = node.layout.position[n4] + (node.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + LayoutEngine.getRelativePosition(node, crossAxis));
        int childCount = node.getChildCount();
        float paddingAndBorderAxisResolvedRow = node.style.padding.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.style.border.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + (node.style.padding.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis]) + node.style.border.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis]));
        float paddingAndBorderAxisColumn = node.style.padding.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + (node.style.padding.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]) + node.style.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]));
        if (LayoutEngine.isMeasureDefined(node)) {
            boolean isColumnUndefined;
            boolean isResolvedRowDimDefined = !Float.isNaN(node.layout.dimensions[dim[resolvedRowAxis]]) && (double)node.layout.dimensions[dim[resolvedRowAxis]] >= 0.0;
            float width = Float.NaN;
            CSSMeasureMode widthMode = CSSMeasureMode.UNDEFINED;
            if (!Float.isNaN(node.style.dimensions[dim[resolvedRowAxis]]) && (double)node.style.dimensions[dim[resolvedRowAxis]] >= 0.0) {
                width = node.style.dimensions[0];
                widthMode = CSSMeasureMode.EXACTLY;
            } else if (isResolvedRowDimDefined) {
                width = node.layout.dimensions[dim[resolvedRowAxis]];
                widthMode = CSSMeasureMode.EXACTLY;
            } else {
                width = parentMaxWidth - (node.style.margin.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.style.margin.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis]));
                widthMode = CSSMeasureMode.AT_MOST;
            }
            if (Float.isNaN(width -= paddingAndBorderAxisResolvedRow)) {
                widthMode = CSSMeasureMode.UNDEFINED;
            }
            float height = Float.NaN;
            CSSMeasureMode heightMode = CSSMeasureMode.UNDEFINED;
            if (!Float.isNaN(node.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]]) && (double)node.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0) {
                height = node.style.dimensions[1];
                heightMode = CSSMeasureMode.EXACTLY;
            } else if (!Float.isNaN(node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]]) && (double)node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0) {
                height = node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]];
                heightMode = CSSMeasureMode.EXACTLY;
            } else {
                height = parentMaxHeight - (node.style.margin.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.style.margin.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis]));
                heightMode = CSSMeasureMode.AT_MOST;
            }
            if (Float.isNaN(height -= node.style.padding.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + (node.style.padding.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]) + node.style.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN])))) {
                heightMode = CSSMeasureMode.UNDEFINED;
            }
            boolean isRowUndefined = !(!Float.isNaN(node.style.dimensions[dim[resolvedRowAxis]]) && (double)node.style.dimensions[dim[resolvedRowAxis]] >= 0.0 || isResolvedRowDimDefined);
            boolean bl = isColumnUndefined = !(!Float.isNaN(node.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]]) && (double)node.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0 || !Float.isNaN(node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]]));
            if (isRowUndefined || isColumnUndefined) {
                MeasureOutput measureDim = node.measure(layoutContext.measureOutput, width, widthMode, height, heightMode);
                if (isRowUndefined) {
                    node.layout.dimensions[0] = measureDim.width + paddingAndBorderAxisResolvedRow;
                }
                if (isColumnUndefined) {
                    node.layout.dimensions[1] = measureDim.height + paddingAndBorderAxisColumn;
                }
            }
            if (childCount == 0) {
                return;
            }
        }
        boolean isNodeFlexWrap = node.style.flexWrap == CSSWrap.WRAP;
        CSSJustify justifyContent = node.style.justifyContent;
        float leadingPaddingAndBorderMain = node.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + node.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]);
        float leadingPaddingAndBorderCross = node.style.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + node.style.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
        float paddingAndBorderAxisMain = node.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + node.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (node.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + node.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
        float paddingAndBorderAxisCross = node.style.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + node.style.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + (node.style.padding.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + node.style.border.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]));
        boolean isMainDimDefined = !Float.isNaN(node.layout.dimensions[dim[mainAxis]]) && (double)node.layout.dimensions[dim[mainAxis]] >= 0.0;
        boolean isCrossDimDefined = !Float.isNaN(node.layout.dimensions[dim[crossAxis]]) && (double)node.layout.dimensions[dim[crossAxis]] >= 0.0;
        boolean isMainRowDirection = mainAxis == CSS_FLEX_DIRECTION_ROW || mainAxis == CSS_FLEX_DIRECTION_ROW_REVERSE;
        CSSNode firstAbsoluteChild = null;
        CSSNode currentAbsoluteChild = null;
        float definedMainDim = Float.NaN;
        if (isMainDimDefined) {
            definedMainDim = node.layout.dimensions[dim[mainAxis]] - paddingAndBorderAxisMain;
        }
        int startLine = 0;
        int endLine = 0;
        boolean alreadyComputedNextLayout = false;
        float linesCrossDim = 0.0f;
        float linesMainDim = 0.0f;
        int linesCount = 0;
        while (endLine < childCount) {
            float mainContentDim = 0.0f;
            int flexibleChildrenCount = 0;
            float totalFlexible = 0.0f;
            int nonFlexibleChildrenCount = 0;
            boolean isSimpleStackMain = isMainDimDefined && justifyContent == CSSJustify.FLEX_START || !isMainDimDefined && justifyContent != CSSJustify.CENTER;
            int firstComplexMain = isSimpleStackMain ? childCount : startLine;
            boolean isSimpleStackCross = true;
            int firstComplexCross = childCount;
            CSSNode firstFlexChild = null;
            CSSNode currentFlexChild = null;
            float mainDim = leadingPaddingAndBorderMain;
            float crossDim = 0.0f;
            float maxWidth = Float.NaN;
            float maxHeight = Float.NaN;
            for (i = startLine; i < childCount; ++i) {
                child = node.getChildAt(i);
                child.lineIndex = linesCount;
                child.nextAbsoluteChild = null;
                child.nextFlexChild = null;
                CSSAlign alignItem = LayoutEngine.getAlignItem(node, child);
                if (alignItem == CSSAlign.STRETCH && child.style.positionType == CSSPositionType.RELATIVE && isCrossDimDefined && (Float.isNaN(child.style.dimensions[dim[crossAxis]]) || !((double)child.style.dimensions[dim[crossAxis]] >= 0.0))) {
                    child.layout.dimensions[LayoutEngine.dim[crossAxis]] = Math.max(LayoutEngine.boundAxis(child, crossAxis, node.layout.dimensions[dim[crossAxis]] - paddingAndBorderAxisCross - (child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]))), child.style.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + (child.style.padding.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + child.style.border.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                } else if (child.style.positionType == CSSPositionType.ABSOLUTE) {
                    if (firstAbsoluteChild == null) {
                        firstAbsoluteChild = child;
                    }
                    if (currentAbsoluteChild != null) {
                        currentAbsoluteChild.nextAbsoluteChild = child;
                    }
                    currentAbsoluteChild = child;
                    for (ii = 0; ii < 2; ++ii) {
                        int n5 = axis = ii != 0 ? CSS_FLEX_DIRECTION_ROW : CSS_FLEX_DIRECTION_COLUMN;
                        if (Float.isNaN(node.layout.dimensions[dim[axis]]) || !((double)node.layout.dimensions[dim[axis]] >= 0.0) || !Float.isNaN(child.style.dimensions[dim[axis]]) && (double)child.style.dimensions[dim[axis]] >= 0.0 || Float.isNaN(child.style.position[leading[axis]]) || Float.isNaN(child.style.position[trailing[axis]])) continue;
                        child.layout.dimensions[LayoutEngine.dim[axis]] = Math.max(LayoutEngine.boundAxis(child, axis, node.layout.dimensions[dim[axis]] - (node.style.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + node.style.border.getWithFallback(leadingSpacing[axis], leading[axis]) + (node.style.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + node.style.border.getWithFallback(trailingSpacing[axis], trailing[axis]))) - (child.style.margin.getWithFallback(leadingSpacing[axis], leading[axis]) + child.style.margin.getWithFallback(trailingSpacing[axis], trailing[axis])) - (Float.isNaN(child.style.position[leading[axis]]) ? 0.0f : child.style.position[leading[axis]]) - (Float.isNaN(child.style.position[trailing[axis]]) ? 0.0f : child.style.position[trailing[axis]])), child.style.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + child.style.border.getWithFallback(leadingSpacing[axis], leading[axis]) + (child.style.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + child.style.border.getWithFallback(trailingSpacing[axis], trailing[axis])));
                    }
                }
                float nextContentDim = 0.0f;
                if (isMainDimDefined && child.style.positionType == CSSPositionType.RELATIVE && child.style.flex > 0.0f) {
                    ++flexibleChildrenCount;
                    totalFlexible += child.style.flex;
                    if (firstFlexChild == null) {
                        firstFlexChild = child;
                    }
                    if (currentFlexChild != null) {
                        currentFlexChild.nextFlexChild = child;
                    }
                    currentFlexChild = child;
                    nextContentDim = child.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (child.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + child.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis])) + (child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
                } else {
                    maxWidth = Float.NaN;
                    maxHeight = Float.NaN;
                    if (!isMainRowDirection) {
                        maxWidth = !Float.isNaN(node.layout.dimensions[dim[resolvedRowAxis]]) && (double)node.layout.dimensions[dim[resolvedRowAxis]] >= 0.0 ? node.layout.dimensions[dim[resolvedRowAxis]] - paddingAndBorderAxisResolvedRow : parentMaxWidth - (node.style.margin.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.style.margin.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis])) - paddingAndBorderAxisResolvedRow;
                    } else {
                        maxHeight = !Float.isNaN(node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]]) && (double)node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0 ? node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] - paddingAndBorderAxisColumn : parentMaxHeight - (node.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN])) - paddingAndBorderAxisColumn;
                    }
                    if (!alreadyComputedNextLayout) {
                        LayoutEngine.layoutNode(layoutContext, child, maxWidth, maxHeight, direction);
                    }
                    if (child.style.positionType == CSSPositionType.RELATIVE) {
                        ++nonFlexibleChildrenCount;
                        nextContentDim = child.layout.dimensions[dim[mainAxis]] + child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]);
                    }
                }
                if (isNodeFlexWrap && isMainDimDefined && mainContentDim + nextContentDim > definedMainDim && i != startLine) {
                    --nonFlexibleChildrenCount;
                    alreadyComputedNextLayout = true;
                    break;
                }
                if (isSimpleStackMain && (child.style.positionType != CSSPositionType.RELATIVE || child.style.positionType == CSSPositionType.RELATIVE && child.style.flex > 0.0f)) {
                    isSimpleStackMain = false;
                    firstComplexMain = i;
                }
                if (isSimpleStackCross && (child.style.positionType != CSSPositionType.RELATIVE || alignItem != CSSAlign.STRETCH && alignItem != CSSAlign.FLEX_START || alignItem == CSSAlign.STRETCH && !isCrossDimDefined)) {
                    isSimpleStackCross = false;
                    firstComplexCross = i;
                }
                if (isSimpleStackMain) {
                    int n6 = pos[mainAxis];
                    child.layout.position[n6] = child.layout.position[n6] + mainDim;
                    if (isMainDimDefined) {
                        child.layout.position[LayoutEngine.trailing[mainAxis]] = node.layout.dimensions[dim[mainAxis]] - child.layout.dimensions[dim[mainAxis]] - child.layout.position[pos[mainAxis]];
                    }
                    mainDim += child.layout.dimensions[dim[mainAxis]] + child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]);
                    crossDim = Math.max(crossDim, LayoutEngine.boundAxis(child, crossAxis, child.layout.dimensions[dim[crossAxis]] + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                }
                if (isSimpleStackCross) {
                    int n7 = pos[crossAxis];
                    child.layout.position[n7] = child.layout.position[n7] + (linesCrossDim + leadingPaddingAndBorderCross);
                    if (isCrossDimDefined) {
                        child.layout.position[LayoutEngine.trailing[crossAxis]] = node.layout.dimensions[dim[crossAxis]] - child.layout.dimensions[dim[crossAxis]] - child.layout.position[pos[crossAxis]];
                    }
                }
                alreadyComputedNextLayout = false;
                mainContentDim += nextContentDim;
                endLine = i + 1;
            }
            float leadingMainDim = 0.0f;
            float betweenMainDim = 0.0f;
            float remainingMainDim = 0.0f;
            remainingMainDim = isMainDimDefined ? definedMainDim - mainContentDim : Math.max(mainContentDim, 0.0f) - mainContentDim;
            if (flexibleChildrenCount != 0) {
                float flexibleMainDim = remainingMainDim / totalFlexible;
                currentFlexChild = firstFlexChild;
                while (currentFlexChild != null) {
                    float boundMainDim;
                    float baseMainDim = flexibleMainDim * currentFlexChild.style.flex + (currentFlexChild.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + currentFlexChild.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (currentFlexChild.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + currentFlexChild.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis])));
                    if (baseMainDim != (boundMainDim = LayoutEngine.boundAxis(currentFlexChild, mainAxis, baseMainDim))) {
                        remainingMainDim -= boundMainDim;
                        totalFlexible -= currentFlexChild.style.flex;
                    }
                    currentFlexChild = currentFlexChild.nextFlexChild;
                }
                flexibleMainDim = remainingMainDim / totalFlexible;
                if (flexibleMainDim < 0.0f) {
                    flexibleMainDim = 0.0f;
                }
                currentFlexChild = firstFlexChild;
                while (currentFlexChild != null) {
                    currentFlexChild.layout.dimensions[LayoutEngine.dim[mainAxis]] = LayoutEngine.boundAxis(currentFlexChild, mainAxis, flexibleMainDim * currentFlexChild.style.flex + (currentFlexChild.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + currentFlexChild.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (currentFlexChild.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + currentFlexChild.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]))));
                    maxWidth = Float.NaN;
                    if (!Float.isNaN(node.layout.dimensions[dim[resolvedRowAxis]]) && (double)node.layout.dimensions[dim[resolvedRowAxis]] >= 0.0) {
                        maxWidth = node.layout.dimensions[dim[resolvedRowAxis]] - paddingAndBorderAxisResolvedRow;
                    } else if (!isMainRowDirection) {
                        maxWidth = parentMaxWidth - (node.style.margin.getWithFallback(leadingSpacing[resolvedRowAxis], leading[resolvedRowAxis]) + node.style.margin.getWithFallback(trailingSpacing[resolvedRowAxis], trailing[resolvedRowAxis])) - paddingAndBorderAxisResolvedRow;
                    }
                    maxHeight = Float.NaN;
                    if (!Float.isNaN(node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]]) && (double)node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0) {
                        maxHeight = node.layout.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] - paddingAndBorderAxisColumn;
                    } else if (isMainRowDirection) {
                        maxHeight = parentMaxHeight - (node.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN])) - paddingAndBorderAxisColumn;
                    }
                    LayoutEngine.layoutNode(layoutContext, currentFlexChild, maxWidth, maxHeight, direction);
                    child = currentFlexChild;
                    currentFlexChild = currentFlexChild.nextFlexChild;
                    child.nextFlexChild = null;
                }
            } else if (justifyContent != CSSJustify.FLEX_START) {
                if (justifyContent == CSSJustify.CENTER) {
                    leadingMainDim = remainingMainDim / 2.0f;
                } else if (justifyContent == CSSJustify.FLEX_END) {
                    leadingMainDim = remainingMainDim;
                } else if (justifyContent == CSSJustify.SPACE_BETWEEN) {
                    remainingMainDim = Math.max(remainingMainDim, 0.0f);
                    betweenMainDim = flexibleChildrenCount + nonFlexibleChildrenCount - 1 != 0 ? remainingMainDim / (float)(flexibleChildrenCount + nonFlexibleChildrenCount - 1) : 0.0f;
                } else if (justifyContent == CSSJustify.SPACE_AROUND) {
                    betweenMainDim = remainingMainDim / (float)(flexibleChildrenCount + nonFlexibleChildrenCount);
                    leadingMainDim = betweenMainDim / 2.0f;
                }
            }
            mainDim += leadingMainDim;
            for (i = firstComplexMain; i < endLine; ++i) {
                child = node.getChildAt(i);
                if (child.style.positionType == CSSPositionType.ABSOLUTE && !Float.isNaN(child.style.position[leading[mainAxis]])) {
                    child.layout.position[LayoutEngine.pos[mainAxis]] = (Float.isNaN(child.style.position[leading[mainAxis]]) ? 0.0f : child.style.position[leading[mainAxis]]) + node.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]);
                    continue;
                }
                int n8 = pos[mainAxis];
                child.layout.position[n8] = child.layout.position[n8] + mainDim;
                if (isMainDimDefined) {
                    child.layout.position[LayoutEngine.trailing[mainAxis]] = node.layout.dimensions[dim[mainAxis]] - child.layout.dimensions[dim[mainAxis]] - child.layout.position[pos[mainAxis]];
                }
                if (child.style.positionType != CSSPositionType.RELATIVE) continue;
                mainDim += betweenMainDim + (child.layout.dimensions[dim[mainAxis]] + child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
                crossDim = Math.max(crossDim, LayoutEngine.boundAxis(child, crossAxis, child.layout.dimensions[dim[crossAxis]] + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
            }
            float containerCrossAxis = node.layout.dimensions[dim[crossAxis]];
            if (!isCrossDimDefined) {
                containerCrossAxis = Math.max(LayoutEngine.boundAxis(node, crossAxis, crossDim + paddingAndBorderAxisCross), paddingAndBorderAxisCross);
            }
            for (i = firstComplexCross; i < endLine; ++i) {
                child = node.getChildAt(i);
                if (child.style.positionType == CSSPositionType.ABSOLUTE && !Float.isNaN(child.style.position[leading[crossAxis]])) {
                    child.layout.position[LayoutEngine.pos[crossAxis]] = (Float.isNaN(child.style.position[leading[crossAxis]]) ? 0.0f : child.style.position[leading[crossAxis]]) + node.style.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                    continue;
                }
                float leadingCrossDim = leadingPaddingAndBorderCross;
                if (child.style.positionType == CSSPositionType.RELATIVE) {
                    CSSAlign alignItem = LayoutEngine.getAlignItem(node, child);
                    if (alignItem == CSSAlign.STRETCH) {
                        if (Float.isNaN(child.style.dimensions[dim[crossAxis]]) || !((double)child.style.dimensions[dim[crossAxis]] >= 0.0)) {
                            float dimCrossAxis = child.layout.dimensions[dim[crossAxis]];
                            child.layout.dimensions[LayoutEngine.dim[crossAxis]] = Math.max(LayoutEngine.boundAxis(child, crossAxis, containerCrossAxis - paddingAndBorderAxisCross - (child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]))), child.style.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + (child.style.padding.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + child.style.border.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                            if (dimCrossAxis != child.layout.dimensions[dim[crossAxis]] && child.getChildCount() > 0) {
                                int n9 = leading[mainAxis];
                                child.layout.position[n9] = child.layout.position[n9] - (child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + LayoutEngine.getRelativePosition(child, mainAxis));
                                int n10 = trailing[mainAxis];
                                child.layout.position[n10] = child.layout.position[n10] - (child.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + LayoutEngine.getRelativePosition(child, mainAxis));
                                int n11 = leading[crossAxis];
                                child.layout.position[n11] = child.layout.position[n11] - (child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + LayoutEngine.getRelativePosition(child, crossAxis));
                                int n12 = trailing[crossAxis];
                                child.layout.position[n12] = child.layout.position[n12] - (child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + LayoutEngine.getRelativePosition(child, crossAxis));
                                LayoutEngine.layoutNode(layoutContext, child, maxWidth, maxHeight, direction);
                            }
                        }
                    } else if (alignItem != CSSAlign.FLEX_START) {
                        float remainingCrossDim = containerCrossAxis - paddingAndBorderAxisCross - (child.layout.dimensions[dim[crossAxis]] + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]));
                        leadingCrossDim = alignItem == CSSAlign.CENTER ? (leadingCrossDim += remainingCrossDim / 2.0f) : (leadingCrossDim += remainingCrossDim);
                    }
                }
                int n13 = pos[crossAxis];
                child.layout.position[n13] = child.layout.position[n13] + (linesCrossDim + leadingCrossDim);
                if (!isCrossDimDefined) continue;
                child.layout.position[LayoutEngine.trailing[crossAxis]] = node.layout.dimensions[dim[crossAxis]] - child.layout.dimensions[dim[crossAxis]] - child.layout.position[pos[crossAxis]];
            }
            linesCrossDim += crossDim;
            linesMainDim = Math.max(linesMainDim, mainDim);
            ++linesCount;
            startLine = endLine;
        }
        if (linesCount > 1 && isCrossDimDefined) {
            float nodeCrossAxisInnerSize = node.layout.dimensions[dim[crossAxis]] - paddingAndBorderAxisCross;
            float remainingAlignContentDim = nodeCrossAxisInnerSize - linesCrossDim;
            float crossDimLead = 0.0f;
            float currentLead = leadingPaddingAndBorderCross;
            CSSAlign alignContent = node.style.alignContent;
            if (alignContent == CSSAlign.FLEX_END) {
                currentLead += remainingAlignContentDim;
            } else if (alignContent == CSSAlign.CENTER) {
                currentLead += remainingAlignContentDim / 2.0f;
            } else if (alignContent == CSSAlign.STRETCH && nodeCrossAxisInnerSize > linesCrossDim) {
                crossDimLead = remainingAlignContentDim / (float)linesCount;
            }
            int endIndex = 0;
            for (i = 0; i < linesCount; ++i) {
                int startIndex = endIndex;
                float lineHeight = 0.0f;
                for (ii = startIndex; ii < childCount; ++ii) {
                    child = node.getChildAt(ii);
                    if (child.style.positionType != CSSPositionType.RELATIVE) continue;
                    if (child.lineIndex != i) break;
                    if (Float.isNaN(child.layout.dimensions[dim[crossAxis]]) || !((double)child.layout.dimensions[dim[crossAxis]] >= 0.0)) continue;
                    lineHeight = Math.max(lineHeight, child.layout.dimensions[dim[crossAxis]] + (child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                }
                endIndex = ii;
                lineHeight += crossDimLead;
                for (ii = startIndex; ii < endIndex; ++ii) {
                    child = node.getChildAt(ii);
                    if (child.style.positionType != CSSPositionType.RELATIVE) continue;
                    CSSAlign alignContentAlignItem = LayoutEngine.getAlignItem(node, child);
                    if (alignContentAlignItem == CSSAlign.FLEX_START) {
                        child.layout.position[LayoutEngine.pos[crossAxis]] = currentLead + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                        continue;
                    }
                    if (alignContentAlignItem == CSSAlign.FLEX_END) {
                        child.layout.position[LayoutEngine.pos[crossAxis]] = currentLead + lineHeight - child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) - child.layout.dimensions[dim[crossAxis]];
                        continue;
                    }
                    if (alignContentAlignItem == CSSAlign.CENTER) {
                        float childHeight = child.layout.dimensions[dim[crossAxis]];
                        child.layout.position[LayoutEngine.pos[crossAxis]] = currentLead + (lineHeight - childHeight) / 2.0f;
                        continue;
                    }
                    if (alignContentAlignItem != CSSAlign.STRETCH) continue;
                    child.layout.position[LayoutEngine.pos[crossAxis]] = currentLead + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                }
                currentLead += lineHeight;
            }
        }
        boolean needsMainTrailingPos = false;
        boolean needsCrossTrailingPos = false;
        if (!isMainDimDefined) {
            node.layout.dimensions[LayoutEngine.dim[mainAxis]] = Math.max(LayoutEngine.boundAxis(node, mainAxis, linesMainDim + (node.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + node.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]))), paddingAndBorderAxisMain);
            if (mainAxis == CSS_FLEX_DIRECTION_ROW_REVERSE || mainAxis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
                needsMainTrailingPos = true;
            }
        }
        if (!isCrossDimDefined) {
            node.layout.dimensions[LayoutEngine.dim[crossAxis]] = Math.max(LayoutEngine.boundAxis(node, crossAxis, linesCrossDim + paddingAndBorderAxisCross), paddingAndBorderAxisCross);
            if (crossAxis == CSS_FLEX_DIRECTION_ROW_REVERSE || crossAxis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
                needsCrossTrailingPos = true;
            }
        }
        if (needsMainTrailingPos || needsCrossTrailingPos) {
            for (i = 0; i < childCount; ++i) {
                child = node.getChildAt(i);
                if (needsMainTrailingPos) {
                    child.layout.position[LayoutEngine.trailing[mainAxis]] = node.layout.dimensions[dim[mainAxis]] - child.layout.dimensions[dim[mainAxis]] - child.layout.position[pos[mainAxis]];
                }
                if (!needsCrossTrailingPos) continue;
                child.layout.position[LayoutEngine.trailing[crossAxis]] = node.layout.dimensions[dim[crossAxis]] - child.layout.dimensions[dim[crossAxis]] - child.layout.position[pos[crossAxis]];
            }
        }
        currentAbsoluteChild = firstAbsoluteChild;
        while (currentAbsoluteChild != null) {
            for (ii = 0; ii < 2; ++ii) {
                int n14 = axis = ii != 0 ? CSS_FLEX_DIRECTION_ROW : CSS_FLEX_DIRECTION_COLUMN;
                if (!(Float.isNaN(node.layout.dimensions[dim[axis]]) || !((double)node.layout.dimensions[dim[axis]] >= 0.0) || !Float.isNaN(currentAbsoluteChild.style.dimensions[dim[axis]]) && (double)currentAbsoluteChild.style.dimensions[dim[axis]] >= 0.0 || Float.isNaN(currentAbsoluteChild.style.position[leading[axis]]) || Float.isNaN(currentAbsoluteChild.style.position[trailing[axis]]))) {
                    currentAbsoluteChild.layout.dimensions[LayoutEngine.dim[axis]] = Math.max(LayoutEngine.boundAxis(currentAbsoluteChild, axis, node.layout.dimensions[dim[axis]] - (node.style.border.getWithFallback(leadingSpacing[axis], leading[axis]) + node.style.border.getWithFallback(trailingSpacing[axis], trailing[axis])) - (currentAbsoluteChild.style.margin.getWithFallback(leadingSpacing[axis], leading[axis]) + currentAbsoluteChild.style.margin.getWithFallback(trailingSpacing[axis], trailing[axis])) - (Float.isNaN(currentAbsoluteChild.style.position[leading[axis]]) ? 0.0f : currentAbsoluteChild.style.position[leading[axis]]) - (Float.isNaN(currentAbsoluteChild.style.position[trailing[axis]]) ? 0.0f : currentAbsoluteChild.style.position[trailing[axis]])), currentAbsoluteChild.style.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + currentAbsoluteChild.style.border.getWithFallback(leadingSpacing[axis], leading[axis]) + (currentAbsoluteChild.style.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + currentAbsoluteChild.style.border.getWithFallback(trailingSpacing[axis], trailing[axis])));
                }
                if (Float.isNaN(currentAbsoluteChild.style.position[trailing[axis]]) || !Float.isNaN(currentAbsoluteChild.style.position[leading[axis]])) continue;
                currentAbsoluteChild.layout.position[LayoutEngine.leading[axis]] = node.layout.dimensions[dim[axis]] - currentAbsoluteChild.layout.dimensions[dim[axis]] - (Float.isNaN(currentAbsoluteChild.style.position[trailing[axis]]) ? 0.0f : currentAbsoluteChild.style.position[trailing[axis]]);
            }
            child = currentAbsoluteChild;
            currentAbsoluteChild = currentAbsoluteChild.nextAbsoluteChild;
            child.nextAbsoluteChild = null;
        }
    }
}

