/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.JavaScriptModule;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JavaScriptModuleRegistration {
    private final Class<? extends JavaScriptModule> mModuleInterface;
    private final Map<Method, String> mMethodsToTracingNames;

    public JavaScriptModuleRegistration(Class<? extends JavaScriptModule> moduleInterface) {
        this.mModuleInterface = moduleInterface;
        this.mMethodsToTracingNames = new HashMap<Method, String>();
    }

    public String getTracingName(Method method) {
        String name = this.mMethodsToTracingNames.get(method);
        if (name == null) {
            name = "JSCall__" + this.getName() + "_" + method.getName();
            this.mMethodsToTracingNames.put(method, name);
        }
        return name;
    }

    public Class<? extends JavaScriptModule> getModuleInterface() {
        return this.mModuleInterface;
    }

    public String getName() {
        String name = this.mModuleInterface.getSimpleName();
        int dollarSignIndex = name.lastIndexOf(36);
        if (dollarSignIndex != -1) {
            name = name.substring(dollarSignIndex + 1);
        }
        return name;
    }

    public List<Method> getMethods() {
        return Arrays.asList(this.mModuleInterface.getDeclaredMethods());
    }
}

