/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.res.AssetManager;
import com.facebook.jni.Countable;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.MemoryPressure;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.ReactCallback;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.soloader.SoLoader;
import javax.annotation.Nullable;

@DoNotStrip
public class ReactBridge
extends Countable {
    static final String REACT_NATIVE_LIB = "reactnativejni";
    private final ReactCallback mCallback;
    private final JavaScriptExecutor mJSExecutor;
    private final MessageQueueThread mNativeModulesQueueThread;

    public ReactBridge(JavaScriptExecutor jsExecutor, ReactCallback callback, MessageQueueThread nativeModulesQueueThread) {
        this.mJSExecutor = jsExecutor;
        this.mCallback = callback;
        this.mNativeModulesQueueThread = nativeModulesQueueThread;
        this.initialize(jsExecutor, callback, this.mNativeModulesQueueThread);
    }

    @Override
    public void dispose() {
        this.mJSExecutor.close();
        this.mJSExecutor.dispose();
        super.dispose();
    }

    public void handleMemoryPressure(MemoryPressure level) {
        switch (level) {
            case MODERATE: {
                this.handleMemoryPressureModerate();
                break;
            }
            case CRITICAL: {
                this.handleMemoryPressureCritical();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level: " + (Object)((Object)level));
            }
        }
    }

    private native void initialize(JavaScriptExecutor var1, ReactCallback var2, MessageQueueThread var3);

    public native void loadScriptFromAssets(AssetManager var1, String var2);

    public native void loadScriptFromFile(@Nullable String var1, @Nullable String var2);

    public native void callFunction(ExecutorToken var1, String var2, String var3, NativeArray var4, String var5);

    public native void invokeCallback(ExecutorToken var1, int var2, NativeArray var3);

    public native void setGlobalVariable(String var1, String var2);

    public native boolean supportsProfiling();

    public native void startProfiler(String var1);

    public native void stopProfiler(String var1, String var2);

    public native ExecutorToken getMainExecutorToken();

    private native void handleMemoryPressureModerate();

    private native void handleMemoryPressureCritical();

    public native void destroy();

    public native long getJavaScriptContextNativePtrExperimental();

    static {
        SoLoader.loadLibrary(REACT_NATIVE_LIB);
    }
}

