/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.animation.Animation;
import com.facebook.react.animation.AnimationRegistry;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.GuardedChoreographerFrameCallback;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.NoSuchNativeViewException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactChoreographer;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class UIViewOperationQueue {
    private final int[] mMeasureBuffer = new int[4];
    private final NativeViewHierarchyManager mNativeViewHierarchyManager;
    private final AnimationRegistry mAnimationRegistry;
    private final Object mDispatchRunnablesLock = new Object();
    private final Object mNonBatchedOperationsLock = new Object();
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    private final ReactApplicationContext mReactApplicationContext;
    @GuardedBy(value="mDispatchRunnablesLock")
    private final ArrayList<Runnable> mDispatchUIRunnables = new ArrayList();
    private ArrayList<UIOperation> mOperations = new ArrayList();
    @GuardedBy(value="mNonBatchedOperationsLock")
    private ArrayDeque<UIOperation> mNonBatchedOperations = new ArrayDeque();
    @Nullable
    private NotThreadSafeViewHierarchyUpdateDebugListener mViewHierarchyUpdateDebugListener;

    public UIViewOperationQueue(ReactApplicationContext reactContext, NativeViewHierarchyManager nativeViewHierarchyManager) {
        this.mNativeViewHierarchyManager = nativeViewHierarchyManager;
        this.mAnimationRegistry = nativeViewHierarchyManager.getAnimationRegistry();
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext);
        this.mReactApplicationContext = reactContext;
    }

    NativeViewHierarchyManager getNativeViewHierarchyManager() {
        return this.mNativeViewHierarchyManager;
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mViewHierarchyUpdateDebugListener = listener;
    }

    public boolean isEmpty() {
        return this.mOperations.isEmpty();
    }

    public void addRootView(final int tag, final SizeMonitoringFrameLayout rootView, final ThemedReactContext themedRootContext) {
        if (UiThreadUtil.isOnUiThread()) {
            this.mNativeViewHierarchyManager.addRootView(tag, rootView, themedRootContext);
        } else {
            final Semaphore semaphore = new Semaphore(0);
            this.mReactApplicationContext.runOnUiQueueThread(new Runnable(){

                @Override
                public void run() {
                    UIViewOperationQueue.this.mNativeViewHierarchyManager.addRootView(tag, rootView, themedRootContext);
                    semaphore.release();
                }
            });
            try {
                SoftAssertions.assertCondition(semaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS), "Timed out adding root view");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void enqueueUIOperation(UIOperation operation) {
        this.mOperations.add(operation);
    }

    public void enqueueRemoveRootView(int rootViewTag) {
        this.mOperations.add(new RemoveRootViewOperation(rootViewTag));
    }

    public void enqueueSetJSResponder(int tag, int initialTag, boolean blockNativeResponder) {
        this.mOperations.add(new ChangeJSResponderOperation(tag, initialTag, false, blockNativeResponder));
    }

    public void enqueueClearJSResponder() {
        this.mOperations.add(new ChangeJSResponderOperation(0, 0, true, false));
    }

    public void enqueueDispatchCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        this.mOperations.add(new DispatchCommandOperation(reactTag, commandId, commandArgs));
    }

    public void enqueueUpdateExtraData(int reactTag, Object extraData) {
        this.mOperations.add(new UpdateViewExtraData(reactTag, extraData));
    }

    public void enqueueShowPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.mOperations.add(new ShowPopupMenuOperation(reactTag, items, success));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueCreateView(ThemedReactContext themedContext, int viewReactTag, String viewClassName, @Nullable ReactStylesDiffMap initialProps) {
        Object object = this.mNonBatchedOperationsLock;
        synchronized (object) {
            this.mNonBatchedOperations.addLast(new CreateViewOperation(themedContext, viewReactTag, viewClassName, initialProps));
        }
    }

    public void enqueueUpdateProperties(int reactTag, String className, ReactStylesDiffMap props) {
        this.mOperations.add(new UpdatePropertiesOperation(reactTag, props));
    }

    public void enqueueUpdateLayout(int parentTag, int reactTag, int x, int y, int width, int height) {
        this.mOperations.add(new UpdateLayoutOperation(parentTag, reactTag, x, y, width, height));
    }

    public void enqueueManageChildren(int reactTag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, @Nullable int[] tagsToDelete) {
        this.mOperations.add(new ManageChildrenOperation(reactTag, indicesToRemove, viewsToAdd, tagsToDelete));
    }

    public void enqueueSetChildren(int reactTag, ReadableArray childrenTags) {
        this.mOperations.add(new SetChildrenOperation(reactTag, childrenTags));
    }

    public void enqueueRegisterAnimation(Animation animation) {
        this.mOperations.add(new RegisterAnimationOperation(animation));
    }

    public void enqueueAddAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.mOperations.add(new AddAnimationOperation(reactTag, animationID, onSuccess));
    }

    public void enqueueRemoveAnimation(int animationID) {
        this.mOperations.add(new RemoveAnimationOperation(animationID));
    }

    public void enqueueSetLayoutAnimationEnabled(boolean enabled) {
        this.mOperations.add(new SetLayoutAnimationEnabledOperation(enabled));
    }

    public void enqueueConfigureLayoutAnimation(ReadableMap config, Callback onSuccess, Callback onError) {
        this.mOperations.add(new ConfigureLayoutAnimationOperation(config));
    }

    public void enqueueMeasure(int reactTag, Callback callback) {
        this.mOperations.add(new MeasureOperation(reactTag, callback));
    }

    public void enqueueMeasureInWindow(int reactTag, Callback callback) {
        this.mOperations.add(new MeasureInWindowOperation(reactTag, callback));
    }

    public void enqueueFindTargetForTouch(int reactTag, float targetX, float targetY, Callback callback) {
        this.mOperations.add(new FindTargetForTouchOperation(reactTag, targetX, targetY, callback));
    }

    public void enqueueSendAccessibilityEvent(int tag, int eventType) {
        this.mOperations.add(new SendAccessibilityEvent(tag, eventType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchViewUpdates(final int batchId) {
        UIOperation[] nonBatchedOperations;
        ArrayList<UIOperation> operations;
        ArrayList<UIOperation> arrayList = operations = this.mOperations.isEmpty() ? null : this.mOperations;
        if (operations != null) {
            this.mOperations = new ArrayList();
        }
        Object object = this.mNonBatchedOperationsLock;
        synchronized (object) {
            if (!this.mNonBatchedOperations.isEmpty()) {
                nonBatchedOperations = this.mNonBatchedOperations.toArray(new UIOperation[this.mNonBatchedOperations.size()]);
                this.mNonBatchedOperations.clear();
            } else {
                nonBatchedOperations = null;
            }
        }
        if (this.mViewHierarchyUpdateDebugListener != null) {
            this.mViewHierarchyUpdateDebugListener.onViewHierarchyUpdateEnqueued();
        }
        object = this.mDispatchRunnablesLock;
        synchronized (object) {
            this.mDispatchUIRunnables.add(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SystraceMessage.beginSection(0L, "DispatchUI").arg("BatchId", batchId).flush();
                    try {
                        if (nonBatchedOperations != null) {
                            for (UIOperation op : nonBatchedOperations) {
                                op.execute();
                            }
                        }
                        if (operations != null) {
                            for (int i = 0; i < operations.size(); ++i) {
                                ((UIOperation)operations.get(i)).execute();
                            }
                        }
                        UIViewOperationQueue.this.mNativeViewHierarchyManager.clearLayoutAnimation();
                        if (UIViewOperationQueue.this.mViewHierarchyUpdateDebugListener != null) {
                            UIViewOperationQueue.this.mViewHierarchyUpdateDebugListener.onViewHierarchyUpdateFinished();
                        }
                    }
                    finally {
                        Systrace.endSection(0L);
                    }
                }
            });
        }
    }

    void resumeFrameCallback() {
        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    void pauseFrameCallback() {
        ReactChoreographer.getInstance().removeFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    private class DispatchUIFrameCallback
    extends GuardedChoreographerFrameCallback {
        private static final int MIN_TIME_LEFT_IN_FRAME_TO_SCHEDULE_MORE_WORK_MS = 8;
        private static final int FRAME_TIME_MS = 16;

        private DispatchUIFrameCallback(ReactContext reactContext) {
            super(reactContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFrameGuarded(long frameTimeNanos) {
            Systrace.beginSection(0L, "dispatchNonBatchedUIOperations");
            try {
                this.dispatchPendingNonBatchedOperations(frameTimeNanos);
            }
            finally {
                Systrace.endSection(0L);
            }
            Object object = UIViewOperationQueue.this.mDispatchRunnablesLock;
            synchronized (object) {
                for (int i = 0; i < UIViewOperationQueue.this.mDispatchUIRunnables.size(); ++i) {
                    ((Runnable)UIViewOperationQueue.this.mDispatchUIRunnables.get(i)).run();
                }
                UIViewOperationQueue.this.mDispatchUIRunnables.clear();
            }
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchPendingNonBatchedOperations(long frameTimeNanos) {
            long timeLeftInFrame;
            while ((timeLeftInFrame = 16L - (System.nanoTime() - frameTimeNanos) / 1000000L) >= 8L) {
                UIOperation nextOperation;
                Object object = UIViewOperationQueue.this.mNonBatchedOperationsLock;
                synchronized (object) {
                    if (UIViewOperationQueue.this.mNonBatchedOperations.isEmpty()) {
                        break;
                    }
                    nextOperation = (UIOperation)UIViewOperationQueue.this.mNonBatchedOperations.pollFirst();
                }
                nextOperation.execute();
            }
        }
    }

    private final class SendAccessibilityEvent
    extends ViewOperation {
        private final int mEventType;

        private SendAccessibilityEvent(int tag, int eventType) {
            super(tag);
            this.mEventType = eventType;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.sendAccessibilityEvent(this.mTag, this.mEventType);
        }
    }

    private final class FindTargetForTouchOperation
    implements UIOperation {
        private final int mReactTag;
        private final float mTargetX;
        private final float mTargetY;
        private final Callback mCallback;

        private FindTargetForTouchOperation(int reactTag, float targetX, float targetY, Callback callback) {
            this.mReactTag = reactTag;
            this.mTargetX = targetX;
            this.mTargetY = targetY;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float containerX = UIViewOperationQueue.this.mMeasureBuffer[0];
            float containerY = UIViewOperationQueue.this.mMeasureBuffer[1];
            int touchTargetReactTag = UIViewOperationQueue.this.mNativeViewHierarchyManager.findTargetTagForTouch(this.mReactTag, this.mTargetX, this.mTargetY);
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(touchTargetReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (IllegalViewOperationException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel((float)UIViewOperationQueue.this.mMeasureBuffer[0] - containerX);
            float y = PixelUtil.toDIPFromPixel((float)UIViewOperationQueue.this.mMeasureBuffer[1] - containerY);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(touchTargetReactTag, Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
    }

    private final class MeasureInWindowOperation
    implements UIOperation {
        private final int mReactTag;
        private final Callback mCallback;

        private MeasureInWindowOperation(int reactTag, Callback callback) {
            this.mReactTag = reactTag;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measureInWindow(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (NoSuchNativeViewException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[0]);
            float y = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height));
        }
    }

    private final class MeasureOperation
    implements UIOperation {
        private final int mReactTag;
        private final Callback mCallback;

        private MeasureOperation(int reactTag, Callback callback) {
            this.mReactTag = reactTag;
            this.mCallback = callback;
        }

        @Override
        public void execute() {
            try {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.measure(this.mReactTag, UIViewOperationQueue.this.mMeasureBuffer);
            }
            catch (NoSuchNativeViewException e) {
                this.mCallback.invoke(new Object[0]);
                return;
            }
            float x = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[0]);
            float y = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(UIViewOperationQueue.this.mMeasureBuffer[3]);
            this.mCallback.invoke(0, 0, Float.valueOf(width), Float.valueOf(height), Float.valueOf(x), Float.valueOf(y));
        }
    }

    private class ConfigureLayoutAnimationOperation
    implements UIOperation {
        private final ReadableMap mConfig;

        private ConfigureLayoutAnimationOperation(ReadableMap config) {
            this.mConfig = config;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.configureLayoutAnimation(this.mConfig);
        }
    }

    private class SetLayoutAnimationEnabledOperation
    implements UIOperation {
        private final boolean mEnabled;

        private SetLayoutAnimationEnabledOperation(boolean enabled) {
            this.mEnabled = enabled;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.setLayoutAnimationEnabled(this.mEnabled);
        }
    }

    private final class RemoveAnimationOperation
    extends AnimationOperation {
        private RemoveAnimationOperation(int animationID) {
            super(animationID);
        }

        @Override
        public void execute() {
            Animation animation = UIViewOperationQueue.this.mAnimationRegistry.getAnimation(this.mAnimationID);
            if (animation != null) {
                animation.cancel();
            }
        }
    }

    private class AddAnimationOperation
    extends AnimationOperation {
        private final int mReactTag;
        private final Callback mSuccessCallback;

        private AddAnimationOperation(int reactTag, int animationID, Callback successCallback) {
            super(animationID);
            this.mReactTag = reactTag;
            this.mSuccessCallback = successCallback;
        }

        @Override
        public void execute() {
            Animation animation = UIViewOperationQueue.this.mAnimationRegistry.getAnimation(this.mAnimationID);
            if (animation == null) {
                throw new IllegalViewOperationException("Animation with id " + this.mAnimationID + " was not found");
            }
            UIViewOperationQueue.this.mNativeViewHierarchyManager.startAnimationForNativeView(this.mReactTag, animation, this.mSuccessCallback);
        }
    }

    private class RegisterAnimationOperation
    extends AnimationOperation {
        private final Animation mAnimation;

        private RegisterAnimationOperation(Animation animation) {
            super(animation.getAnimationID());
            this.mAnimation = animation;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mAnimationRegistry.registerAnimation(this.mAnimation);
        }
    }

    private static abstract class AnimationOperation
    implements UIOperation {
        protected final int mAnimationID;

        public AnimationOperation(int animationID) {
            this.mAnimationID = animationID;
        }
    }

    private final class ShowPopupMenuOperation
    extends ViewOperation {
        private final ReadableArray mItems;
        private final Callback mSuccess;

        public ShowPopupMenuOperation(int tag, ReadableArray items, Callback success) {
            super(tag);
            this.mItems = items;
            this.mSuccess = success;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.showPopupMenu(this.mTag, this.mItems, this.mSuccess);
        }
    }

    private final class DispatchCommandOperation
    extends ViewOperation {
        private final int mCommand;
        @Nullable
        private final ReadableArray mArgs;

        public DispatchCommandOperation(int tag, @Nullable int command, ReadableArray args) {
            super(tag);
            this.mCommand = command;
            this.mArgs = args;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.dispatchCommand(this.mTag, this.mCommand, this.mArgs);
        }
    }

    private final class ChangeJSResponderOperation
    extends ViewOperation {
        private final int mInitialTag;
        private final boolean mBlockNativeResponder;
        private final boolean mClearResponder;

        public ChangeJSResponderOperation(int tag, int initialTag, boolean clearResponder, boolean blockNativeResponder) {
            super(tag);
            this.mInitialTag = initialTag;
            this.mClearResponder = clearResponder;
            this.mBlockNativeResponder = blockNativeResponder;
        }

        @Override
        public void execute() {
            if (!this.mClearResponder) {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.setJSResponder(this.mTag, this.mInitialTag, this.mBlockNativeResponder);
            } else {
                UIViewOperationQueue.this.mNativeViewHierarchyManager.clearJSResponder();
            }
        }
    }

    private final class UpdateViewExtraData
    extends ViewOperation {
        private final Object mExtraData;

        public UpdateViewExtraData(int tag, Object extraData) {
            super(tag);
            this.mExtraData = extraData;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateViewExtraData(this.mTag, this.mExtraData);
        }
    }

    private final class SetChildrenOperation
    extends ViewOperation {
        private final ReadableArray mChildrenTags;

        public SetChildrenOperation(int tag, ReadableArray childrenTags) {
            super(tag);
            this.mChildrenTags = childrenTags;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.setChildren(this.mTag, this.mChildrenTags);
        }
    }

    private final class ManageChildrenOperation
    extends ViewOperation {
        @Nullable
        private final int[] mIndicesToRemove;
        @Nullable
        private final ViewAtIndex[] mViewsToAdd;
        @Nullable
        private final int[] mTagsToDelete;

        public ManageChildrenOperation(@Nullable int tag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, int[] tagsToDelete) {
            super(tag);
            this.mIndicesToRemove = indicesToRemove;
            this.mViewsToAdd = viewsToAdd;
            this.mTagsToDelete = tagsToDelete;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.manageChildren(this.mTag, this.mIndicesToRemove, this.mViewsToAdd, this.mTagsToDelete);
        }
    }

    private final class CreateViewOperation
    extends ViewOperation {
        private final ThemedReactContext mThemedContext;
        private final String mClassName;
        @Nullable
        private final ReactStylesDiffMap mInitialProps;

        public CreateViewOperation(ThemedReactContext themedContext, int tag, @Nullable String className, ReactStylesDiffMap initialProps) {
            super(tag);
            this.mThemedContext = themedContext;
            this.mClassName = className;
            this.mInitialProps = initialProps;
            Systrace.startAsyncFlow(0L, "createView", this.mTag);
        }

        @Override
        public void execute() {
            Systrace.endAsyncFlow(0L, "createView", this.mTag);
            UIViewOperationQueue.this.mNativeViewHierarchyManager.createView(this.mThemedContext, this.mTag, this.mClassName, this.mInitialProps);
        }
    }

    private final class UpdateLayoutOperation
    extends ViewOperation {
        private final int mParentTag;
        private final int mX;
        private final int mY;
        private final int mWidth;
        private final int mHeight;

        public UpdateLayoutOperation(int parentTag, int tag, int x, int y, int width, int height) {
            super(tag);
            this.mParentTag = parentTag;
            this.mX = x;
            this.mY = y;
            this.mWidth = width;
            this.mHeight = height;
            Systrace.startAsyncFlow(0L, "updateLayout", this.mTag);
        }

        @Override
        public void execute() {
            Systrace.endAsyncFlow(0L, "updateLayout", this.mTag);
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateLayout(this.mParentTag, this.mTag, this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }

    private final class UpdatePropertiesOperation
    extends ViewOperation {
        private final ReactStylesDiffMap mProps;

        private UpdatePropertiesOperation(int tag, ReactStylesDiffMap props) {
            super(tag);
            this.mProps = props;
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.updateProperties(this.mTag, this.mProps);
        }
    }

    private final class RemoveRootViewOperation
    extends ViewOperation {
        public RemoveRootViewOperation(int tag) {
            super(tag);
        }

        @Override
        public void execute() {
            UIViewOperationQueue.this.mNativeViewHierarchyManager.removeRootView(this.mTag);
        }
    }

    private abstract class ViewOperation
    implements UIOperation {
        public int mTag;

        public ViewOperation(int tag) {
            this.mTag = tag;
        }
    }

    protected static interface UIOperation {
        public void execute();
    }
}

