/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.util.SparseIntArray;

public class TouchEventCoalescingKeyHelper {
    private static final SparseIntArray sDownTimeToCoalescingKey = new SparseIntArray();

    public static void addCoalescingKey(long downTime) {
        sDownTimeToCoalescingKey.put((int)downTime, 0);
    }

    public static void incrementCoalescingKey(long downTime) {
        int currentValue = sDownTimeToCoalescingKey.get((int)downTime, -1);
        if (currentValue == -1) {
            throw new RuntimeException("Tried to increment non-existent cookie");
        }
        sDownTimeToCoalescingKey.put((int)downTime, currentValue + 1);
    }

    public static short getCoalescingKey(long downTime) {
        int currentValue = sDownTimeToCoalescingKey.get((int)downTime, -1);
        if (currentValue == -1) {
            throw new RuntimeException("Tried to get non-existent cookie");
        }
        return (short)(0xFFFF & currentValue);
    }

    public static void removeCoalescingKey(long downTime) {
        sDownTimeToCoalescingKey.delete((int)downTime);
    }

    public static boolean hasCoalescingKey(long downTime) {
        int currentValue = sDownTimeToCoalescingKey.get((int)downTime, -1);
        return currentValue != -1;
    }
}

