/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.layoutanimation.AbstractLayoutAnimation;
import com.facebook.react.uimanager.layoutanimation.OpacityAnimation;

abstract class BaseLayoutAnimation
extends AbstractLayoutAnimation {
    BaseLayoutAnimation() {
    }

    abstract boolean isReverse();

    @Override
    boolean isValid() {
        return this.mDurationMs > 0 && this.mAnimatedProperty != null;
    }

    @Override
    Animation createAnimationImpl(View view, int x, int y, int width, int height) {
        float toValue;
        float fromValue = this.isReverse() ? 1.0f : 0.0f;
        float f = toValue = this.isReverse() ? 0.0f : 1.0f;
        if (this.mAnimatedProperty != null) {
            switch (this.mAnimatedProperty) {
                case OPACITY: {
                    return new OpacityAnimation(view, fromValue, toValue);
                }
                case SCALE_XY: {
                    return new ScaleAnimation(fromValue, toValue, fromValue, toValue, 1, 0.5f, 1, 0.5f);
                }
            }
            throw new IllegalViewOperationException("Missing animation for property : " + (Object)((Object)this.mAnimatedProperty));
        }
        throw new IllegalViewOperationException("Missing animated property from animation config");
    }
}

