/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.widget.ProgressBar;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.progressbar.ProgressBarContainerView;
import com.facebook.react.views.progressbar.ProgressBarShadowNode;
import javax.annotation.Nullable;

public class ReactProgressBarViewManager
extends BaseViewManager<ProgressBarContainerView, ProgressBarShadowNode> {
    static final String PROP_STYLE = "styleAttr";
    static final String PROP_INDETERMINATE = "indeterminate";
    static final String PROP_PROGRESS = "progress";
    static final String REACT_CLASS = "AndroidProgressBar";
    static final String DEFAULT_STYLE = "Normal";
    private static Object sProgressBarCtorLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressBar createProgressBar(Context context, int style2) {
        Object object = sProgressBarCtorLock;
        synchronized (object) {
            return new ProgressBar(context, null, style2);
        }
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected ProgressBarContainerView createViewInstance(ThemedReactContext context) {
        return new ProgressBarContainerView((Context)context);
    }

    @ReactProp(name="styleAttr")
    public void setStyle(ProgressBarContainerView view, @Nullable String styleName) {
        view.setStyle(styleName);
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(ProgressBarContainerView view, @Nullable Integer color) {
        view.setColor(color);
    }

    @ReactProp(name="indeterminate")
    public void setIndeterminate(ProgressBarContainerView view, boolean indeterminate) {
        view.setIndeterminate(indeterminate);
    }

    @ReactProp(name="progress")
    public void setProgress(ProgressBarContainerView view, double progress) {
        view.setProgress(progress);
    }

    @Override
    public ProgressBarShadowNode createShadowNodeInstance() {
        return new ProgressBarShadowNode();
    }

    @Override
    public Class<ProgressBarShadowNode> getShadowNodeClass() {
        return ProgressBarShadowNode.class;
    }

    @Override
    public void updateExtraData(ProgressBarContainerView root, Object extraData) {
    }

    @Override
    protected void onAfterUpdateTransaction(ProgressBarContainerView view) {
        view.apply();
    }

    static int getStyleFromString(@Nullable String styleStr) {
        if (styleStr == null) {
            throw new JSApplicationIllegalArgumentException("ProgressBar needs to have a style, null received");
        }
        if (styleStr.equals("Horizontal")) {
            return 16842872;
        }
        if (styleStr.equals("Small")) {
            return 16842873;
        }
        if (styleStr.equals("Large")) {
            return 16842874;
        }
        if (styleStr.equals("Inverse")) {
            return 16843399;
        }
        if (styleStr.equals("SmallInverse")) {
            return 16843400;
        }
        if (styleStr.equals("LargeInverse")) {
            return 16843401;
        }
        if (styleStr.equals(DEFAULT_STYLE)) {
            return 0x1010077;
        }
        throw new JSApplicationIllegalArgumentException("Unknown ProgressBar style: " + styleStr);
    }
}

